/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controls;

import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.controls.IChildControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ItemSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.efuse.controller.EfuseController;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controller.utils.StorageEfuseUtils;
import com.nxp.swtools.efuse.gui.EfuseSceneCreator;
import com.nxp.swtools.efuse.gui.utils.EfuseActions;
import com.nxp.swtools.efuse.gui.utils.EfuseGuiUtils;
import com.nxp.swtools.efuse.model.EfuseEntity;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.mcu.IEfuseMcu;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.ui.xml.settings.ArraySetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseEnumSetting;
import com.nxp.swtools.efuse.xml.settings.AdvancedFuseSetting;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import org.eclipse.ui.services.IDisposable;

public class EnumSettingControl
extends HBox
implements IChildControl,
IDisposable {
    private EfuseEnumSetting enumSetting;
    protected Parent parent;
    private ComboBox<String> enumCmb;
    private ObservableList<String> items = FXCollections.observableArrayList();

    public EnumSettingControl(EfuseEnumSetting enumSetting, Parent parent) {
        this.enumSetting = enumSetting;
        this.parent = parent;
        this.enumCmb = new ComboBox();
        this.create();
    }

    public void create() {
        ItemSetting defaultSelectedItem;
        this.enumCmb.setId(this.enumSetting.getId());
        Label enumSettingLabel = new Label();
        enumSettingLabel.setGraphic(this.enumCmb);
        enumSettingLabel.setContentDisplay(ContentDisplay.RIGHT);
        enumSettingLabel.getStyleClass().add((Object)"default-c-style");
        enumSettingLabel.setText(EfuseControllerUtils.getLabel((ABaseUIComponentSetting)this.enumSetting));
        List enumSettingItems = EfuseControllerUtils.getEnumSettingItems((EfuseEnumSetting)this.enumSetting);
        for (ItemSetting item : enumSettingItems) {
            this.items.add((Object)item.getLabel());
        }
        this.enumCmb.setItems(this.items);
        if (this.enumSetting.getId().equals("fuse_word_advanced")) {
            this.enumCmb.showingProperty().addListener((obs, hidden, showing) -> {
                if (showing.booleanValue()) {
                    this.enumCmb.setCellFactory((Callback)new ComboBoxCellFactory());
                }
            });
        }
        if ((defaultSelectedItem = this.enumSetting.getItemById(this.enumSetting.getCurrentValue())) != null) {
            this.enumSetting.setCurrentSelection(defaultSelectedItem.getLabel());
            this.enumSetting.setCurrentValue(defaultSelectedItem.getId());
            this.enumCmb.getSelectionModel().select((Object)defaultSelectedItem.getLabel());
        }
        this.getChildren().add((Object)enumSettingLabel);
        this.getChildren().add(this.enumCmb);
        UctLayoutUtils.registerListenerForControl((AUctController)EfuseController.getInstance(), (IChildControl)this, (int)4);
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.enumSetting);
        this.enumCmb.getSelectionModel().selectedItemProperty().addListener(this.getEnumCmbListener());
        IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
        if (EfuseUtils.isFuseFieldAssociatedWithMultipleComponents((IEfuseMcu)mcu, (String)this.enumSetting.getFuseFieldID())) {
            this.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(@Nullable ObservableValue<? extends Boolean> observableValue, Boolean wasVisible, Boolean isVisible) {
                    if (isVisible.booleanValue()) {
                        StorageEfuseUtils.updateStorageComponent((ABaseUIComponentSetting)EnumSettingControl.this.enumSetting);
                    }
                }
            });
        }
        this.disabledProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(@Nullable ObservableValue<? extends Boolean> observableValue, Boolean wasDisabled, Boolean isDisabled) {
                StorageEfuseUtils.updateStorageComponent((ABaseUIComponentSetting)EnumSettingControl.this.enumSetting);
            }
        });
        EfuseSceneCreator.getNodes().add((Node)this);
        EfuseSceneCreator.getNodes().add((Node)this.enumCmb);
        EfuseSceneCreator.getNodes().add((Node)enumSettingLabel);
    }

    public void refresh() {
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.enumSetting);
        String currentItem = (String)this.enumCmb.getSelectionModel().getSelectedItem();
        if (currentItem != null) {
            ItemSetting newSelectedItem;
            ItemSetting currentSelectedItem = this.enumSetting.getItemByName(currentItem);
            if (currentSelectedItem != null && !this.enumSetting.getCurrentValue().equals(currentSelectedItem.getId()) && (newSelectedItem = this.enumSetting.getItemById(this.enumSetting.getCurrentValue())) != null) {
                this.enumSetting.setCurrentSelection(newSelectedItem.getLabel());
                this.enumCmb.getSelectionModel().select((Object)newSelectedItem.getLabel());
            }
        } else {
            String currentEnumValue = this.enumSetting.getCurrentSelection().getLabel();
            if (!this.enumCmb.getItems().contains((Object)currentEnumValue)) {
                this.enumCmb.getSelectionModel().selectFirst();
            }
        }
    }

    public Parent getParentControl() {
        return this.parent;
    }

    public void setParentControl(Parent parent) {
        this.parent = parent;
    }

    public ChangeListener<String> getEnumCmbListener() {
        ChangeListener enumComboboxListener = (obs, oldValue, newValue) -> {
            if (newValue != null && !this.enumSetting.isDisabled()) {
                Scene scene;
                IEfuseMcu mcu;
                FuseField associatedFuseField;
                this.enumSetting.setCurrentSelection(newValue);
                this.enumSetting.setCurrentValue(this.enumSetting.getCurrentSelection().getId());
                EfuseEntity enumEfuseEntity = EfuseControllerUtils.getEfuseEntity((ABaseUIComponentSetting)this.enumSetting);
                if (enumEfuseEntity != null && (associatedFuseField = enumEfuseEntity.getFuseField()) != null) {
                    mcu = EfuseController.getInstance().getEfuseMcu();
                    if (EfuseUtils.isFuseFieldAssociatedWithMultipleComponents((IEfuseMcu)mcu, (String)this.enumSetting.getFuseFieldID())) {
                        if (this.enumSetting.isVisible()) {
                            ItemSetting selectedItem = this.enumSetting.getCurrentSelection();
                            associatedFuseField.setValueToWrite(selectedItem.getValueToWrite());
                        }
                    } else {
                        ItemSetting selectedItem = this.enumSetting.getCurrentSelection();
                        associatedFuseField.setValueToWrite(selectedItem.getValueToWrite());
                    }
                }
                EfuseActions.executeAction(this.enumSetting.getAction());
                EfuseActions.executeUpdateDependentNodesAction(this, this.getEnumSettingItemIdByLabel((String)oldValue), this.enumSetting.getCurrentValue(), this.enumSetting.getAction());
                EfuseControllerUtils.updateComponentsState((ABaseUIComponentSetting)this.enumSetting);
                EfuseGuiUtils.updateEnumComboBoxesItems();
                if (EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.ADVANCED)) {
                    EfuseGuiUtils.refreshEfuseBinaryConfigurationTable();
                }
                if ((scene = this.getScene()) != null) {
                    EfuseGuiUtils.refreshUI(scene);
                }
                if (EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.STANDARD)) {
                    mcu = EfuseController.getInstance().getEfuseMcu();
                    if (EfuseUtils.isFuseFieldAssociatedWithMultipleComponents((IEfuseMcu)mcu, (String)this.enumSetting.getFuseFieldID())) {
                        if (this.enumSetting.isVisible()) {
                            StorageEfuseUtils.updateStorageComponent((Object)((Object)this), (ABaseUIComponentSetting)this.enumSetting);
                        }
                    } else {
                        StorageEfuseUtils.updateStorageComponent((Object)((Object)this), (ABaseUIComponentSetting)this.enumSetting);
                    }
                }
            }
        };
        return enumComboboxListener;
    }

    public ObservableList<String> getEnumCmbItems() {
        return this.items;
    }

    public ComboBox<String> getEnumCmb() {
        return this.enumCmb;
    }

    public void dispose() {
        UctLayoutUtils.removeListenerForControl((AUctController)EfuseController.getInstance(), (IChildControl)this);
        EfuseSceneCreator.getNodes().remove((Object)this);
        EfuseSceneCreator.getNodes().remove(this.enumCmb);
        this.getChildren().clear();
    }

    protected @Nullable String getEnumSettingItemIdByLabel(@Nullable String label) {
        if (label == null) {
            return null;
        }
        List enumSettingItems = EfuseControllerUtils.getEnumSettingItems((EfuseEnumSetting)this.enumSetting);
        for (ItemSetting item : enumSettingItems) {
            if (!label.equals(item.getLabel())) continue;
            return item.getId();
        }
        return null;
    }

    public EfuseEnumSetting getEnumSetting() {
        return this.enumSetting;
    }

    public class ComboBoxCellFactory
    implements Callback<ListView<String>, ListCell<String>> {
        public ListCell<String> call(ListView<String> param) {
            return new ListCell<String>(){

                public void updateItem(String item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (item != null || !empty) {
                        AdvancedFuseSetting result;
                        String label;
                        this.setText(item);
                        this.setDisable(false);
                        ArraySetting fuseArray = EfuseControllerUtils.getAdvancedFusesArray();
                        if (fuseArray != null && (label = EnumSettingControl.this.getEnumSettingItemIdByLabel(item)) != null && (result = fuseArray.getAdvancedFuseSettingByFuseWordId(label)) != null) {
                            this.setDisable(true);
                        }
                    }
                }
            };
        }
    }
}

