/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.gui.utils;

import java.util.Arrays;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;

public class BitField
extends GridPane {
    private static final String DISABLED_CONTROL_STYLE_CLASS = "disabled-control";
    private static final String BIT_FIELD = "bit-field";
    private static final char ZERO_CHAR = '0';
    private static final char ONE_CHAR = '1';
    private short size = 1;
    private static final int MAX_CHARS = 16;
    private StringProperty text = new SimpleStringProperty();

    public BitField() {
        this.setFocusTraversable(true);
        this.getStyleClass().add((Object)DISABLED_CONTROL_STYLE_CLASS);
        this.getStyleClass().add((Object)BIT_FIELD);
        this.addEventFilter(ContextMenuEvent.CONTEXT_MENU_REQUESTED, Event::consume);
        this.addEventFilter(KeyEvent.ANY, Event::consume);
        char[] array = new char[this.size];
        Arrays.fill(array, '0');
        this.setText(new String(array));
    }

    void toggleBit(int position) {
        char[] crtText = this.getText().toCharArray();
        if (position >= crtText.length) {
            return;
        }
        crtText[position] = crtText[position] == '0' ? 49 : 48;
        this.setText(String.valueOf(crtText));
    }

    public void setText(String bits) {
        this.getChildren().clear();
        if (bits.isEmpty()) {
            this.text.set((Object)"");
            return;
        }
        int bitsSize = bits.length();
        int rows = (int)Math.ceil((double)bitsSize / 16.0);
        int rowIndex = 0;
        while (rowIndex < rows) {
            int cols = Math.min(16, bitsSize - rowIndex * 16);
            int colIndex = 0;
            while (colIndex < cols) {
                Label label = new Label(String.valueOf(bits.charAt(16 * rowIndex + colIndex)));
                label.setMinWidth(label.getFont().getSize() / 2.0);
                int rowLocal = rowIndex;
                int colLocal = colIndex;
                label.setOnMouseClicked(event -> this.toggleBit(rowLocal * 16 + colLocal));
                this.add((Node)label, colIndex, rowIndex);
                ++colIndex;
            }
            ++rowIndex;
        }
        Label label = (Label)this.getChildren().get(0);
        this.setMinWidth(label.getFont().getSize() * (double)Math.min(16, bitsSize) / 2.0);
        this.text.set((Object)bits);
    }

    public String getText() {
        String textValue = (String)this.text.get();
        if (textValue == null) {
            return "";
        }
        return textValue;
    }

    public StringProperty textProperty() {
        return this.text;
    }
}

