/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.control;

import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ModelSdk;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ToolChainHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.control.AbstractSdkResourceControl;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.module.SdkModule;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.module.SdkModulesHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.ExtendedPath;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkFileResource;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkResource;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkGroup;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class BinaryResourcesControl
extends AbstractSdkResourceControl {
    public static final String LIBRARIES_SUFFIX = "B";
    private static final int ORDERING_ITEMS_LIST_HEIGHT_HINT = 110;
    private StructuredViewer orderingItemsViewer;
    private Button moveUpButton;
    private Button moveDownButton;

    public BinaryResourcesControl(Composite parent, boolean isEditable, Map<String, ToolChainHolder> toolChainHolders) {
        super(parent, ResourceSdkCore.binaryFilesMatcher, isEditable, false, LIBRARIES_SUFFIX, toolChainHolders);
        this.resourceType = ResourceSdkGroup.BINARY_RESOURCES;
        this.createOredringItemsList(parent);
    }

    @Override
    public void setInput(AbstractSdkResourceControl.InputWrapper inputWrapper, boolean isCreateMode, boolean isExpand) {
        super.setInput(inputWrapper, isCreateMode, isExpand);
        this.setOrderingItemsListInput();
    }

    @Override
    public Map<String, Set<SdkResource>> getChecked() {
        Map<String, Set<SdkResource>> selectedItems = super.getChecked();
        LinkedHashMap<String, Set<SdkResource>> selectedLibriries = new LinkedHashMap<String, Set<SdkResource>>();
        selectedItems.entrySet().stream().forEach(e -> {
            Set<SdkResource> set = selectedLibriries.put((String)e.getKey(), BinaryResourcesControl.getFilteredResources((Set)e.getValue()));
        });
        return selectedLibriries;
    }

    @Override
    public void clearSelected() {
        super.clearSelected();
        this.setOrderingItemsListInput();
    }

    @Override
    protected void switchSelection(Tree tree, int id) {
        super.switchSelection(tree, id);
        this.setOrderingItemsListInput();
    }

    @Override
    protected EditingSupport getSelectColumnEditingSupport() {
        return new LibrarySelectColumnEditingSupport((ColumnViewer)this.viewer);
    }

    @Override
    protected SdkResource getResource(ExtendedPath path) {
        return new SdkFileResource(ResourceSdkKind.BINARY_FILE, path);
    }

    private void createOredringItemsList(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.SdKEditDialogBinaryResourcesControl_ordering_items_list_label);
        Composite listComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        listComposite.setFont(parent.getFont());
        this.createOrderingItemsViewer(listComposite);
        if (this.isEditable) {
            this.createButtonsGroup(listComposite);
        }
    }

    private void createOrderingItemsViewer(Composite parent) {
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 110;
        if (this.isEditable) {
            this.createOrderingItemsList(parent, layoutData);
        } else {
            this.createOrderingItemsTree(parent, layoutData);
        }
    }

    private void createOrderingItemsTree(Composite parent, GridData layoutData) {
        this.orderingItemsViewer = new TreeViewer(parent, 2820);
        Tree tree = ((TreeViewer)this.orderingItemsViewer).getTree();
        tree.setLayoutData((Object)layoutData);
        tree.setFont(parent.getFont());
        this.orderingItemsViewer.setContentProvider((IContentProvider)new OrderingItemsTreeContentProvider());
        this.orderingItemsViewer.setLabelProvider((IBaseLabelProvider)new OrderingItemsTreeNameColumnLabelProvider());
    }

    private void createOrderingItemsList(Composite parent, GridData listLayoutData) {
        this.orderingItemsViewer = new TableViewer(parent, 2820);
        Table list = ((TableViewer)this.orderingItemsViewer).getTable();
        list.setLayoutData((Object)listLayoutData);
        list.setFont(parent.getFont());
        this.orderingItemsViewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                return BinaryResourcesControl.this.selectedFiles.stream().filter(BinaryResourcesControl.isNotDirectory()).toArray(AbstractSdkResourceControl.SdkResourceDataHolder[]::new);
            }
        });
        this.orderingItemsViewer.setLabelProvider((IBaseLabelProvider)new OrderingItemsListLabelProvider());
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryResourcesControl.this.updateMoveButtonsEnabledState();
            }
        });
    }

    private void createButtonsGroup(Composite parent) {
        Composite groupComponent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(groupComponent);
        GridData buttonGroupGridData = new GridData();
        buttonGroupGridData.verticalAlignment = 4;
        buttonGroupGridData.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)buttonGroupGridData);
        groupComponent.setFont(parent.getFont());
        this.moveUpButton = new Button(groupComponent, 8);
        this.moveUpButton.setText(Messages.SdKEditDialogBinaryResourcesControl_ordering_items_list_button_move_up);
        this.moveUpButton.setLayoutData((Object)new GridData(4, 0, true, false));
        this.moveUpButton.setFont(groupComponent.getParent().getFont());
        this.moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.moveSelectedItemUp();
                BinaryResourcesControl.this.updateMoveButtonsEnabledState();
            }

            private void moveSelectedItemUp() {
                Table list = ((TableViewer)BinaryResourcesControl.this.orderingItemsViewer).getTable();
                int selectionIndex = list.getSelectionIndex();
                if (selectionIndex <= 0) {
                    return;
                }
                ArrayList<AbstractSdkResourceControl.SdkResourceDataHolder> orderedList = new ArrayList<AbstractSdkResourceControl.SdkResourceDataHolder>();
                orderedList.addAll(BinaryResourcesControl.this.selectedFiles);
                AbstractSdkResourceControl.SdkResourceDataHolder selectedItem = (AbstractSdkResourceControl.SdkResourceDataHolder)orderedList.remove(selectionIndex);
                orderedList.add(selectionIndex - 1, selectedItem);
                BinaryResourcesControl.this.selectedFiles.clear();
                BinaryResourcesControl.this.selectedFiles.addAll(orderedList);
                BinaryResourcesControl.this.setOrderingItemsListInput();
                list.setSelection(selectionIndex - 1);
            }
        });
        this.moveDownButton = new Button(groupComponent, 8);
        this.moveDownButton.setText(Messages.SdKEditDialogBinaryResourcesControl_ordering_items_list_button_move_down);
        this.moveDownButton.setLayoutData((Object)new GridData(4, 0, true, false));
        this.moveDownButton.setFont(groupComponent.getParent().getFont());
        this.moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.moveSelectedItemDown();
                BinaryResourcesControl.this.updateMoveButtonsEnabledState();
            }

            private void moveSelectedItemDown() {
                Table list = ((TableViewer)BinaryResourcesControl.this.orderingItemsViewer).getTable();
                Table itemsList = list;
                int selectionIndex = itemsList.getSelectionIndex();
                if (selectionIndex >= itemsList.getItemCount() - 1) {
                    return;
                }
                ArrayList<AbstractSdkResourceControl.SdkResourceDataHolder> orderedList = new ArrayList<AbstractSdkResourceControl.SdkResourceDataHolder>();
                orderedList.addAll(BinaryResourcesControl.this.selectedFiles);
                AbstractSdkResourceControl.SdkResourceDataHolder selectedItem = (AbstractSdkResourceControl.SdkResourceDataHolder)orderedList.remove(selectionIndex);
                orderedList.add(selectionIndex + 1, selectedItem);
                BinaryResourcesControl.this.selectedFiles.clear();
                BinaryResourcesControl.this.selectedFiles.addAll(orderedList);
                BinaryResourcesControl.this.setOrderingItemsListInput();
                list.setSelection(selectionIndex + 1);
            }
        });
        this.updateMoveButtonsEnabledState();
    }

    private void updateMoveButtonsEnabledState() {
        if (this.isEditable) {
            Table list = ((TableViewer)this.orderingItemsViewer).getTable();
            int selectionIndex = list.getSelectionIndex();
            boolean isSelectedNotEmpty = !this.selectedFiles.isEmpty();
            this.moveUpButton.setEnabled(isSelectedNotEmpty && selectionIndex > 0);
            this.moveDownButton.setEnabled(isSelectedNotEmpty && selectionIndex < list.getItemCount() - 1);
        }
    }

    private void setOrderingItemsListInput() {
        if (this.isEditable) {
            this.orderingItemsViewer.setInput(BinaryResourcesControl.getFilteredItems(this.selectedFiles));
        } else {
            AbstractSdkResourceControl.SdkDataHolder sdkDataHolder = ((AbstractSdkResourceControl.InputWrapper)this.getInput()).get();
            this.orderingItemsViewer.setInput((Object)sdkDataHolder);
        }
        this.orderingItemsViewer.refresh();
    }

    private static Set<AbstractSdkResourceControl.SdkResourceDataHolder> getFilteredItems(Set<AbstractSdkResourceControl.SdkResourceDataHolder> items) {
        return items.stream().filter(BinaryResourcesControl.isNotDirectory()).collect(Collectors.toSet());
    }

    private static Predicate<? super AbstractSdkResourceControl.SdkResourceDataHolder> isNotDirectory() {
        return res -> !res.getPath().toFile().isDirectory();
    }

    private static Set<SdkResource> getFilteredResources(Set<SdkResource> allResources) {
        return new LinkedHashSet<SdkResource>(allResources.stream().filter(r -> !r.isDirectory()).collect(Collectors.toList()));
    }

    class LibrarySelectColumnEditingSupport
    extends AbstractSdkResourceControl.SelectColumnEditingSupport {
        LibrarySelectColumnEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        @Override
        protected void setValue(Object element, Object value) {
            super.setValue(element, value);
            BinaryResourcesControl.this.setOrderingItemsListInput();
        }
    }

    private class OrderingItemsListLabelProvider
    extends AbstractSdkResourceControl.NameColumnLabelProvider {
        private OrderingItemsListLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (element instanceof AbstractSdkResourceControl.SdkResourceDataHolder) {
                String binaryFileName = this.getBinaryFileName((AbstractSdkResourceControl.SdkResourceDataHolder)element);
                return binaryFileName != null ? binaryFileName : super.getText(element);
            }
            return super.getText(element);
        }

        private String getBinaryFileName(AbstractSdkResourceControl.SdkResourceDataHolder resource) {
            SdkModulesHolder modulesHolder;
            ModelSdk sdk = ((AbstractSdkResourceControl.InputWrapper)BinaryResourcesControl.this.getInput()).get().getSdk();
            if (sdk != null && (modulesHolder = sdk.getModules()).hasModules()) {
                for (SdkModule refModule : modulesHolder.getRefModules()) {
                    String refModuleName = refModule.getName();
                    ModelSdk refSdk = refModule.getSdk();
                    IPath basePath = refModule.getBasePath();
                    if (refSdk == null || basePath == null || !BinaryResourcesControl.this.getModuleResources(refModuleName, refSdk).containsResourceWithPath(resource.getPath())) continue;
                    return resource.getPath().makeRelativeTo(basePath).toString();
                }
            }
            return resource.getPath().makeRelativeTo((IPath)BinaryResourcesControl.this.rootPathDataHolder.getPath()).toString();
        }
    }

    private class OrderingItemsTreeContentProvider
    extends AbstractSdkResourceControl.SourcesTreeContentProvider {
        private OrderingItemsTreeContentProvider() {
        }

        @Override
        protected Set<AbstractSdkResourceControl.SdkResourceDataHolder> getMatchedChildResources(AbstractSdkResourceControl.SdkResourceDataHolder parentDirectory) {
            Set<AbstractSdkResourceControl.SdkResourceDataHolder> childItems = super.getMatchedChildResources(parentDirectory);
            if (!childItems.isEmpty()) {
                return new LinkedHashSet<AbstractSdkResourceControl.SdkResourceDataHolder>(BinaryResourcesControl.this.selectedFiles);
            }
            return childItems;
        }
    }

    private class OrderingItemsTreeNameColumnLabelProvider
    extends AbstractSdkResourceControl.NameColumnLabelProvider {
        private OrderingItemsTreeNameColumnLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (element instanceof AbstractSdkResourceControl.SdkResourceDataHolder) {
                AbstractSdkResourceControl.SdkResourceDataHolder resource = (AbstractSdkResourceControl.SdkResourceDataHolder)element;
                String resourceToolChainId = resource.getToolChainId();
                if (resourceToolChainId == null || resourceToolChainId.isEmpty()) {
                    return resource.getPath().lastSegment();
                }
                String toolChainAlias = ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId((String)resource.getSdkId()).stream().filter(tc -> tc.getToolChainId().equals(resourceToolChainId)).map(ToolChainSdkDescriptor::getAlias).findFirst().orElse(null);
                if (toolChainAlias != null && !toolChainAlias.isEmpty()) {
                    return String.valueOf(resource.getPath().lastSegment()) + " [" + toolChainAlias + "]";
                }
                return resource.getPath().lastSegment();
            }
            return super.getText(element);
        }
    }
}

