/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.symbol;

import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.symbol.SdkSymbol;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkKind;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SdkSymbolsHolder {
    private final String toolChainId;
    private Map<SymbolSdkKind, List<SdkSymbol>> symbolsByType;

    public SdkSymbolsHolder(String toolChainId) {
        this.toolChainId = toolChainId;
        this.symbolsByType = new EnumMap<SymbolSdkKind, List<SdkSymbol>>(SymbolSdkKind.class);
    }

    public void addSymbol(SdkSymbol symbol, SymbolSdkKind type) {
        List<SdkSymbol> symbols = this.symbolsByType.get(type);
        if (symbols == null) {
            symbols = new LinkedList<SdkSymbol>();
        }
        if (symbols.stream().noneMatch(s -> symbol.getSymbolName().equals(s.getSymbolName()) && symbol.getLangId().equals(s.getLangId()) && type == this.getSymbolType((SdkSymbol)s))) {
            symbols.add(symbol);
        }
        this.symbolsByType.put(type, symbols);
    }

    public void addSymbols(String symbolsString) {
        if (symbolsString == null) {
            return;
        }
        this.addSymbols(symbolsString, "", SymbolSdkKind.DEFINED_SYMBOL);
    }

    public void addSymbols(String symbolsString, String langId, SymbolSdkKind type) {
        if (symbolsString == null) {
            return;
        }
        Arrays.stream(symbolsString.split(",")).map(String::trim).filter(symbolName -> !symbolName.isEmpty()).map(symbolName -> new SdkSymbol((String)symbolName, langId, this)).forEach(symbol -> this.addSymbol((SdkSymbol)symbol, type));
    }

    public void addSymbol(String symbolName, String langId, String configurations, SymbolSdkKind type) {
        if (symbolName == null || symbolName.isEmpty()) {
            return;
        }
        SdkSymbol symbol = new SdkSymbol(symbolName, langId, this);
        symbol.setRelatedConfigurations(configurations);
        this.addSymbol(symbol, type);
    }

    public void addSymbols(List<String> symbols, String langId, SymbolSdkKind type) {
        if (symbols == null) {
            return;
        }
        symbols.stream().map(String::trim).filter(symbolName -> !symbolName.isEmpty()).map(symbolName -> new SdkSymbol((String)symbolName, langId, this)).forEach(symbol -> this.addSymbol((SdkSymbol)symbol, type));
    }

    public Map<SymbolSdkKind, List<SdkSymbol>> getSymbols() {
        return this.symbolsByType;
    }

    public void removeSymbol(SdkSymbol symbol, SymbolSdkKind type) {
        this.getSymbolsByType(type).remove(symbol);
    }

    public List<SdkSymbol> getSymbolsByType(SymbolSdkKind type) {
        LinkedList symbols = this.symbolsByType.get(type);
        return symbols != null ? symbols : new LinkedList();
    }

    public String getToolChainId() {
        return this.toolChainId;
    }

    public SymbolSdkKind getSymbolType(SdkSymbol symbol) {
        for (Map.Entry<SymbolSdkKind, List<SdkSymbol>> e : this.symbolsByType.entrySet()) {
            if (!e.getValue().contains(symbol)) continue;
            return e.getKey();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.symbolsByType.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).forEach(s -> {
            StringBuilder stringBuilder2 = sb.append(s).append('\n');
        });
        return sb.toString();
    }

    public void merge(SdkSymbolsHolder sourceHolder) {
        sourceHolder.getSymbols().entrySet().forEach(moduleSymbols -> ((List)moduleSymbols.getValue()).forEach(symbol -> this.addSymbol((SdkSymbol)symbol, (SymbolSdkKind)moduleSymbols.getKey())));
    }
}

