/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.imports;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkEnvironmentNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkVersionValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportSdkRenameDialog
extends TitleAreaDialog {
    private Text sdkNameField;
    private Text sdkVersionField;
    private Button okButton;
    private String sdkName;
    private String sdkVersion;
    private String defaultMsg = null;
    private String newName;
    private String newVersion;
    private String envName;
    private IValidator<String> nameValidator = new SdkNameValidator();
    private IValidator<String> versionValidator = new SdkVersionValidator();
    private IValidator<String> environmentValidator = new SdkEnvironmentNameValidator();

    public ImportSdkRenameDialog(Shell parent, Map<String, String> parameters, String message) {
        super(parent);
        this.sdkName = Objects.requireNonNull(parameters.get("name"));
        this.sdkVersion = Objects.requireNonNull(parameters.get("version"));
        this.defaultMsg = message;
    }

    public ImportSdkRenameDialog(Shell parent, SdkDescriptor sdkDescriptor, String message) {
        super(parent);
        this.sdkName = Objects.requireNonNull(sdkDescriptor.getName());
        this.sdkVersion = Objects.requireNonNull(sdkDescriptor.getVersion());
        this.defaultMsg = message;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ImportSdkRenameDialog_tiltle);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = new Composite(parentComposite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)contents);
        this.setTitle(this.defaultMsg == null || this.defaultMsg.trim().isEmpty() ? Messages.ImportSdkRenameDialog_message : this.defaultMsg);
        contents.setLayout((Layout)new GridLayout(2, false));
        this.createWidgets(contents);
        ImportSdkRenameDialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.sdkNameField.setFocus();
        this.sdkNameField.setText(this.sdkName);
        this.sdkNameField.selectAll();
        this.sdkVersionField.setText(this.sdkVersion);
    }

    public String getNewName() {
        return this.newName;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    private void createWidgets(Composite contents) {
        Label label1 = new Label(contents, 16384);
        label1.setText(Messages.ImportSdkRenameDialog_label_name);
        label1.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.sdkNameField = new Text(contents, 2052);
        this.sdkNameField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sdkNameField.addModifyListener(e -> {
            this.envName = this.updateEnvName();
            this.validate();
        });
        Label label2 = new Label(contents, 16384);
        label2.setText(Messages.ImportSdkRenameDialog_label_version);
        label2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.sdkVersionField = new Text(contents, 2052);
        this.sdkVersionField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sdkVersionField.addModifyListener(e -> {
            this.envName = this.updateEnvName();
            this.validate();
        });
    }

    private String updateEnvName() {
        return this.sdkNameField.getText().toUpperCase().trim() + '_' + this.sdkVersionField.getText().trim() + "_PATH";
    }

    private void validate() {
        boolean isOk = true;
        IStatus status = this.nameValidator.validate((Object)this.sdkNameField.getText());
        if (status.isOK()) {
            status = this.versionValidator.validate((Object)this.sdkVersionField.getText());
        }
        if (!status.isOK()) {
            isOk = false;
            this.setErrorMessage(status.getMessage());
        }
        if (isOk && SdkManagementUtils.isSdkExists((String)this.sdkNameField.getText(), (String)this.sdkVersionField.getText())) {
            isOk = false;
            this.setErrorMessage(Messages.ImportSdkRenameDialog_error_sdk_with_same_name_version_exists);
        }
        if (isOk && !(status = this.environmentValidator.validate((Object)this.envName)).isOK()) {
            isOk = false;
            this.setErrorMessage(status.getMessage());
        }
        if (isOk) {
            this.setErrorMessage(null);
            this.newName = this.sdkNameField.getText();
            this.newVersion = this.sdkVersionField.getText();
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(this.getErrorMessage() == null);
        }
    }
}

