/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller.generation;

import com.nxp.swtools.codemanager.GeneratedCodeStatus;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.Messages;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.ICustomCopyrightHeaderRead;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.sources.ISourcesContentProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class GtmSourcesContentProvider
implements ISourcesContentProvider {
    public @Nullable String getStatus() {
        String status = Messages.CodeGenerationNoConfig;
        GtmController controller = GtmController.getInstance();
        if (!controller.getSharedConfig().isEmpty()) {
            ScriptResult result = controller.getGeneratedCode();
            status = !result.containsAnyError() ? Messages.CodeGenerationSuccess : Messages.CodeGenerationError;
        }
        return status;
    }

    public @Nullable String getErrorText() {
        return GtmController.getInstance().getGeneratedCode().getWarnings();
    }

    public @Nullable String getWarningText() {
        return GtmController.getInstance().getGeneratedCode().getErrors();
    }

    public boolean isOutOfSync() {
        GeneratedCodeStatus.getInstance().setCodeStatus(false);
        return false;
    }

    public boolean isExportBtnDisabled() {
        return true;
    }

    public @NonNull Collection<@NonNull ISourceFile> getContent() {
        GtmController controller = GtmController.getInstance();
        ScriptResult lastWorkingResult = null;
        if (!controller.getSharedConfig().isEmpty()) {
            controller.requestRegenerateCode();
            lastWorkingResult = controller.getGeneratedCode();
        }
        return lastWorkingResult != null ? SourceFileProviderFactory.buildSourceFileList((Map)lastWorkingResult.getOpenedFiles(), (ICustomCopyrightHeaderRead)SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().getCustomCopyright()) : new ArrayList<ISourceFile>();
    }
}

