/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtml.controller.utils;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.BoolSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.EnumSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.IntegerSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ItemSetting;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.Messages;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.xml.settings.GtmBoolSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmEnumSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmConfiguration;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmContainer;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmSetting;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmTool;
import java.util.ArrayList;
import java.util.List;

public class StorageGtmUtils {
    private static final String GTM_PANEL_ID = "gtm_panel";

    public static @Nullable StorageGtmTool getGtmStorage() {
        return GtmController.getInstance().getSharedConfig().getTools().getGtmTool();
    }

    public static @Nullable StorageGtmConfiguration getStorageGtmConfiguration() {
        StorageGtmTool gtmStorage = StorageGtmUtils.getGtmStorage();
        if (gtmStorage != null) {
            return gtmStorage.getGtmConfiguration();
        }
        return null;
    }

    public static void initAllStorageContainers(IGtmMcu mcu, StorageGtmTool stGtmTool) {
        GtmStructSetting configurationStruct;
        StorageGtmConfiguration stGtmConfiguration = stGtmTool.getGtmConfiguration();
        if (stGtmConfiguration != null && (configurationStruct = mcu.getGtmLayoutContent().getStructSettingById(GTM_PANEL_ID)) != null) {
            List structSettings = configurationStruct.getStructSettings();
            for (GtmStructSetting structSetting : structSettings) {
                StorageGtmContainer stGtmContainer = stGtmConfiguration.getContainerById(structSetting.getId());
                if (stGtmContainer == null) {
                    stGtmContainer = new StorageGtmContainer();
                    stGtmContainer.setId(structSetting.getId());
                    stGtmConfiguration.getContainers().add(stGtmContainer);
                }
                StorageGtmUtils.initContainerSettings(structSetting, stGtmContainer);
                StorageGtmUtils.initChildContainers(structSetting, stGtmContainer);
            }
        }
    }

    private static @Nullable StorageGtmContainer getGtmContainerById(String id) {
        StorageGtmConfiguration stGtmConfiguration = StorageGtmUtils.getStorageGtmConfiguration();
        if (stGtmConfiguration != null) {
            return StorageGtmUtils.findContainer(stGtmConfiguration.getContainers(), id);
        }
        return null;
    }

    private static @Nullable StorageGtmContainer findContainer(ArrayList<StorageGtmContainer> containers, String id) {
        for (StorageGtmContainer container : containers) {
            if (container.getId().equals(id)) {
                return container;
            }
            StorageGtmContainer childContainer = container.getChildContainerById(id);
            if (childContainer != null) {
                return childContainer;
            }
            StorageGtmContainer result = StorageGtmUtils.findContainer(container.getChildContainers(), id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void updateStorageForComponent(Object source, ABaseUIComponentSetting component) {
        EnumSetting enumComponent;
        ABaseUIComponentSetting parent;
        boolean storageChanged = false;
        GtmController.getInstance().stateShouldUpdate(source, false);
        if (component instanceof BoolSetting) {
            BoolSetting boolComponent = (BoolSetting)component;
            ABaseUIComponentSetting parent2 = boolComponent.getParent();
            if (parent2 != null) {
                storageChanged = StorageGtmUtils.updateSettingStorage(parent2.getId(), boolComponent.getId(), boolComponent.getValueToWrite() == 1L ? "true" : "false");
            }
        } else if (component instanceof IntegerSetting) {
            IntegerSetting integerComponent = (IntegerSetting)component;
            ABaseUIComponentSetting parent3 = integerComponent.getParent();
            if (parent3 != null) {
                storageChanged = StorageGtmUtils.updateSettingStorage(parent3.getId(), integerComponent.getId(), "0x" + Long.toHexString(integerComponent.getValueToWrite()));
            }
        } else if (component instanceof EnumSetting && (parent = (enumComponent = (EnumSetting)component).getParent()) != null) {
            storageChanged = StorageGtmUtils.updateSettingStorage(parent.getId(), enumComponent.getId(), enumComponent.getCurrentSelection().getLabel());
        }
        GtmController.getInstance().stateShouldUpdate(source, true);
        StorageGtmConfiguration stGtmConfig = StorageGtmUtils.getStorageGtmConfiguration();
        if (stGtmConfig != null && storageChanged) {
            GtmController.getInstance().handleSettingChange(4, source, null, Messages.Msg_ChangedGtmConfig);
        }
    }

    private static boolean updateSettingStorage(String parentId, String id, String value) {
        StorageGtmContainer gtmContainer = StorageGtmUtils.getGtmContainerById(parentId);
        if (gtmContainer != null) {
            StorageGtmSetting setting = gtmContainer.getSettingById(id);
            if (setting == null) {
                setting = new StorageGtmSetting();
                setting.setId(id);
                setting.setValue(value);
                gtmContainer.getSettings().add(setting);
                return true;
            }
            if (!setting.getValue().equals(value)) {
                setting.setValue(value);
                return true;
            }
        }
        return false;
    }

    private static void initChildContainers(GtmStructSetting structSetting, StorageGtmContainer parentContainer) {
        for (GtmStructSetting otherStruct : structSetting.getStructSettings()) {
            StorageGtmContainer childContainer = parentContainer.getChildContainerById(otherStruct.getId());
            if (childContainer == null) {
                childContainer = new StorageGtmContainer();
                childContainer.setId(otherStruct.getId());
                parentContainer.getChildContainers().add(childContainer);
            }
            StorageGtmUtils.initContainerSettings(otherStruct, childContainer);
            StorageGtmUtils.initChildContainers(otherStruct, childContainer);
        }
    }

    private static void initContainerSettings(GtmStructSetting structSetting, StorageGtmContainer stGtmContainer) {
        StorageGtmSetting setting;
        for (GtmBoolSetting boolSetting : structSetting.getBoolSettings()) {
            if (stGtmContainer.getSettingById(boolSetting.getId()) != null) continue;
            setting = new StorageGtmSetting();
            setting.setId(boolSetting.getId());
            setting.setValue(boolSetting.getInitValue());
            stGtmContainer.getSettings().add(setting);
        }
        for (GtmEnumSetting enumSetting : structSetting.getEnumSettings()) {
            if (stGtmContainer.getSettingById(enumSetting.getId()) != null) continue;
            setting = new StorageGtmSetting();
            ItemSetting defaultItem = enumSetting.getItemById(enumSetting.getInitValue());
            if (defaultItem == null) continue;
            setting.setId(enumSetting.getId());
            setting.setValue(defaultItem.getLabel());
            stGtmContainer.getSettings().add(setting);
        }
        for (GtmIntegerSetting integerSetting : structSetting.getIntegerSettings()) {
            if (stGtmContainer.getSettingById(integerSetting.getId()) != null) continue;
            setting = new StorageGtmSetting();
            setting.setId(integerSetting.getId());
            setting.setValue("0x" + Long.toHexString(UctUtils.getLongValueFromString((String)integerSetting.getInitValue())));
            stGtmContainer.getSettings().add(setting);
        }
    }
}

