/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.action;

import com.nxp.s32ds.cdt.svd.internal.ui.CdtSvdUiActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerBase;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInputs;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdActionBase;
import com.nxp.s32ds.cdt.svd.model.SvdAdresableContainer;
import com.nxp.s32ds.cdt.svd.model.SvdContainer;
import com.nxp.s32ds.cdt.svd.model.SvdField;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheralGroup;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModel;
import com.nxp.s32ds.cdt.svd.utils.SvdFields;
import com.nxp.s32ds.cdt.svd.utils.SvdNumberToStrings;
import java.io.Closeable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SvdCopyAction
extends SvdActionBase<SvdTreeViewerBase> {
    private static final String EMPTY = "";
    private static final String FORMAT_S_S = "%s,%s";
    private static final String FORMAT_S_S_S = "%s,%s,%s";
    private static final String FORMAT_S_D_D = "%s[%d-%d]";

    public SvdCopyAction(SvdTreeViewerBase viewer) {
        super(viewer);
        this.setText(Messages.SvdCopyAction_copy_name);
        this.setId(String.valueOf(CdtSvdUiActivator.getInstance().getBundleId()) + ".SvdCopyAction");
        this.setActionDefinitionId("org.eclipse.ui.edit.copy");
    }

    public void run() {
        this.update();
        if (!this.isEnabled()) {
            return;
        }
        List elements = Arrays.stream(((IStructuredSelection)this.viewer.getSelection()).toArray()).filter(e -> e instanceof SvdContainer).map(e -> (SvdContainer)e).collect(Collectors.toList());
        if (elements.isEmpty()) {
            return;
        }
        boolean requestValue = ((SvdContainer)elements.get(0)).getModel() instanceof SvdWatchModel;
        StringBuilder builder = new StringBuilder();
        for (SvdContainer element : elements) {
            this.append(builder, element, requestValue);
            builder.append(System.lineSeparator());
        }
        if (builder.length() == 0) {
            return;
        }
        this.writeToClipboard(builder.toString());
    }

    private void writeToClipboard(String s) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ClosableClipboard clipboard = new ClosableClipboard(this.viewer.getControl());){
            if (!clipboard.set(s) && MessageDialog.openQuestion((Shell)this.viewer.getControl().getShell(), (String)Messages.SvdCopyAction_problem_copying_to_clipboard, (String)Messages.SvdCopyAction_there_was_a_problem_when_accessing_the_system_clipboard_retry)) {
                this.writeToClipboard(s);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void append(StringBuilder builder, SvdContainer element, boolean requestValue) {
        String value;
        String path = SvdCopyAction.getPath(element);
        String address = SvdCopyAction.getAddress(element);
        String string = value = requestValue ? this.getValue(element) : EMPTY;
        if (requestValue) {
            builder.append(String.format(FORMAT_S_S_S, path, address, value));
        } else {
            builder.append(String.format(FORMAT_S_S, path, address));
        }
    }

    private static String getPath(SvdContainer element) {
        if (element instanceof SvdPeripheralGroup) {
            String name = element.getName();
            if (name == null) {
                name = Messages.SvdModelGroupContentProvider_default_name;
            }
            return name;
        }
        return SvdCopyAction.getPathToPeripheral(element);
    }

    private static String getAddress(SvdContainer element) {
        if (element instanceof SvdAdresableContainer) {
            return SvdNumberToStrings.toHexString((IAddress)((SvdAdresableContainer)element).getAddress(), (int)32);
        }
        if (element instanceof SvdField) {
            SvdField field = (SvdField)element;
            int bitOffset = field.getBitOffset();
            return String.format(FORMAT_S_D_D, SvdNumberToStrings.toHexString((IAddress)field.getParent().getAddress(), (int)32), bitOffset, bitOffset + field.getBitLength() - 1);
        }
        return EMPTY;
    }

    private String getValue(SvdContainer element) {
        if (element instanceof SvdField) {
            SvdField field = (SvdField)element;
            return Optional.ofNullable(SvdTreeViewerInputs.getValue(this.viewer, field)).map(v -> SvdFields.getFieldValue((SvdField)field, (BigInteger)v)).map(v -> SvdNumberToStrings.toHexString((BigInteger)v, (int)field.getBitLength())).orElse(EMPTY);
        }
        if (element instanceof SvdRegister) {
            SvdRegister register = (SvdRegister)element;
            return Optional.ofNullable(SvdTreeViewerInputs.getValue(this.viewer, register)).map(v -> SvdNumberToStrings.toHexString((BigInteger)v, (int)register.getBitLength())).orElse(EMPTY);
        }
        return EMPTY;
    }

    @Override
    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        this.setEnabled(!((IStructuredSelection)this.viewer.getSelection()).isEmpty());
    }

    private static String getPathToPeripheral(SvdContainer register) {
        ArrayList<String> names = new ArrayList<String>();
        SvdContainer e = register;
        while (!(e instanceof SvdPeripheralGroup)) {
            names.add(e.getName());
            e = e.getParent();
        }
        Collections.reverse(names);
        return String.join((CharSequence)"/", names);
    }

    private static class ClosableClipboard
    implements Closeable {
        private final Clipboard cd;

        public ClosableClipboard(Control control) {
            this.cd = new Clipboard(control.getDisplay());
        }

        public boolean set(String string) {
            try {
                this.cd.setContents((Object[])new String[]{string}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                return false;
            }
            return true;
        }

        @Override
        public void close() {
            this.cd.dispose();
        }
    }
}

