/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.memento;

import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerBase;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInput;
import com.nxp.s32ds.cdt.svd.internal.ui.view.memento.SvdMementos;
import com.nxp.s32ds.cdt.svd.model.SvdChildElement;
import com.nxp.s32ds.cdt.svd.model.SvdContainer;
import com.nxp.s32ds.cdt.svd.model.SvdModelBase;
import com.nxp.s32ds.cdt.svd.model.SvdNamedElement;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheralGroup;
import com.nxp.s32ds.ext.orbit.strings.SeparatedStrings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IMemento;

public class SvdTreeViewerExpandCollapceMemento
extends SvdMementos<SvdTreeViewerBase> {
    private static final String EXPANDED_PATHS = "expanded_paths";
    private static final String PATH = "path";

    public SvdTreeViewerExpandCollapceMemento(String mementoId) {
        super("SvdTreeViewerExpandCollapceMemento." + mementoId);
    }

    protected void saveToMemento(IMemento memento, SvdTreeViewerBase svdTreeViewer) {
        TreePath[] expandedTreePaths;
        IMemento expandedNodes = memento.getChild(EXPANDED_PATHS);
        if (expandedNodes == null) {
            expandedNodes = memento.createChild(EXPANDED_PATHS);
        }
        TreePath[] treePathArray = expandedTreePaths = svdTreeViewer.getTreeViewer().getExpandedTreePaths();
        int n = expandedTreePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            expandedNodes.createChild(PATH).putTextData(SvdTreeViewerExpandCollapceMemento.getPath(treePath));
            ++n2;
        }
    }

    protected SvdTreeViewerBase restoreFromMemento(IMemento memento, SvdTreeViewerBase svdTreeViewer) {
        SvdTreeViewerInput input = svdTreeViewer.getInput();
        if (input == null) {
            return svdTreeViewer;
        }
        IMemento node = memento.getChild(EXPANDED_PATHS);
        if (node != null) {
            boolean showStructure = svdTreeViewer.showStructure();
            ArrayList<TreePath> paths = new ArrayList<TreePath>();
            IMemento[] iMementoArray = node.getChildren(PATH);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento path = iMementoArray[n2];
                paths.add(SvdTreeViewerExpandCollapceMemento.getTreePath(input.model, path.getTextData(), showStructure));
                ++n2;
            }
            SvdTreeViewerExpandCollapceMemento.addTopLevelNodes(paths, showStructure);
            svdTreeViewer.getTreeViewer().setExpandedTreePaths(paths.toArray(new TreePath[paths.size()]));
        }
        return svdTreeViewer;
    }

    private static void addTopLevelNodes(List<TreePath> paths, boolean showStructure) {
        HashSet<SvdNamedElement> set = new HashSet<SvdNamedElement>();
        if (!showStructure) {
            return;
        }
        boolean hasExpandedTop = paths.stream().filter(tp -> tp.getSegmentCount() == 1).findAny().isPresent();
        if (hasExpandedTop) {
            return;
        }
        for (TreePath treePath : paths) {
            Object firstSegment;
            if (treePath.getSegmentCount() != 2 || !((firstSegment = treePath.getFirstSegment()) instanceof SvdPeripheralGroup)) continue;
            set.add((SvdNamedElement)firstSegment);
        }
        for (SvdNamedElement element : set) {
            paths.add(new TreePath(new Object[]{element}));
        }
    }

    private static TreePath getTreePath(SvdModelBase model, String textData, boolean showStructure) {
        List paths = SeparatedStrings.COMMA_SEPARATED.asList(textData);
        List<SvdChildElement> elements = new ArrayList();
        for (String path : paths) {
            SvdChildElement element = model.getByPath(path);
            if (element == null) break;
            elements.add(element);
        }
        if (elements.size() > 0 && !showStructure) {
            elements = elements.subList(1, elements.size());
        }
        if (elements.size() == 0) {
            return TreePath.EMPTY;
        }
        return new TreePath(elements.toArray());
    }

    private static String getPath(TreePath treePath) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < treePath.getSegmentCount()) {
            SvdContainer container = (SvdContainer)treePath.getSegment(i);
            if (i == 0 && !(container instanceof SvdPeripheralGroup)) {
                list.add(container.getParent().getPath());
            }
            list.add(container.getPath());
            ++i;
        }
        return SeparatedStrings.COMMA_SEPARATED.toString(list);
    }
}

