/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.provider;

import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class SvdColumnLabelCompositeProvider
extends ColumnLabelProvider {
    private final Map<Class<?>, SvdColumnLabelProvider<?>> providersMap = new HashMap();
    private final SvdColumnLabelProvider<Object> defaultProvider = new SvdColumnLabelProvider<Object>(Object.class);

    public SvdColumnLabelCompositeProvider(SvdColumnLabelProvider<?> ... providers) {
        SvdColumnLabelProvider<?>[] svdColumnLabelProviderArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            SvdColumnLabelProvider<?> provider = svdColumnLabelProviderArray[n2];
            this.add(provider);
            ++n2;
        }
    }

    public SvdColumnLabelCompositeProvider add(SvdColumnLabelProvider<?> provider) {
        this.providersMap.put(provider.getServicedClass(), provider);
        return this;
    }

    protected void initialize(ColumnViewer viewer, ViewerColumn column) {
        super.initialize(viewer, column);
        Collection<SvdColumnLabelProvider<?>> values = this.providersMap.values();
        for (SvdColumnLabelProvider<?> provider : values) {
            provider.initialize(viewer, column);
        }
    }

    public void update(ViewerCell cell) {
        this.getProvider(cell.getElement()).update(cell);
    }

    public Font getFont(Object element) {
        return this.getProvider(element).getFont(element);
    }

    public Color getBackground(Object element) {
        return this.getProvider(element).getBackground(element);
    }

    public Color getForeground(Object element) {
        return this.getProvider(element).getForeground(element);
    }

    public Image getImage(Object element) {
        return this.getProvider(element).getImage(element);
    }

    public String getText(Object element) {
        return this.getProvider(element).getText(element);
    }

    public String getToolTipText(Object element) {
        return this.getProvider(element).getToolTipText(element);
    }

    private SvdColumnLabelProvider<?> getProvider(Object element) {
        if (element == null) {
            return this.defaultProvider;
        }
        SvdColumnLabelProvider<Object> orDefault = this.providersMap.getOrDefault(element.getClass(), this.defaultProvider);
        return orDefault;
    }
}

