/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit;

import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit.Messages;
import com.nxp.s32ds.cdt.svd.utils.SvdTrace;
import java.math.BigInteger;
import java.util.Optional;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public abstract class SvdBinaryCellEditorBase<T>
extends CellEditor {
    private static final MouseListener LABEL_MOUSE_LISTENER = new LabelMouseAdapter();
    private static final int GAP = 2;
    private KeyListener keyListener;
    private Label[] b;
    private BigInteger value;
    protected final T object;
    private Composite composite;
    private boolean apply = false;

    public SvdBinaryCellEditorBase(Composite parent, T object) {
        super(parent, 0);
        this.object = object;
        this.postCreate();
        this.addListener(new SvdBinaryCellEditorListener());
    }

    protected Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        RowLayout layout = RowLayoutFactory.fillDefaults().wrap(false).extendedMargins(1, 1, 2, 1).spacing(3).create();
        layout.center = true;
        this.composite.setLayout((Layout)layout);
        this.composite.addTraverseListener(e -> {
            if (e.detail == 2 || e.detail == 4) {
                e.doit = false;
            }
        });
        this.keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SvdBinaryCellEditorBase.this.keyReleaseOccured(e);
            }
        };
        this.composite.addKeyListener(this.keyListener);
        SvdBinaryCellEditorBase.decorate((Control)this.composite, parent.getBackground());
        return this.composite;
    }

    private static void decorate(Control control, Color background) {
        control.setBackground(background);
    }

    private void postCreate() {
        Color background = this.composite.getBackground();
        int bitLength = this.getBitLength();
        int height = this.getItemHeight() - 2;
        this.b = new Label[bitLength];
        RowData data = new RowData();
        data.height = height;
        int i = 0;
        while (i < bitLength) {
            Composite internalComposite = new Composite(this.composite, 0);
            internalComposite.setLayoutData((Object)data);
            internalComposite.setLayout((Layout)new FillLayout());
            this.b[i] = new Label(internalComposite, 0x1800000);
            SvdBinaryCellEditorBase.decorate((Control)this.b[i], background);
            this.b[i].addMouseListener(LABEL_MOUSE_LISTENER);
            int bitNumber = bitLength - 1 - i;
            boolean editable = this.isEditable(bitNumber);
            this.b[i].setEnabled(editable);
            String toolTip = Optional.ofNullable(this.getBitToolTip(bitNumber)).orElse(NLS.bind((String)Messages.SvdBinaryCellEditorBase_bit_0, (Object)bitNumber));
            this.b[i].setToolTipText(toolTip);
            if (!editable) {
                internalComposite.setToolTipText(toolTip);
            }
            if (bitNumber > 0 && bitNumber % 4 == 0) {
                this.addSeparator(background, height, bitNumber);
            }
            ++i;
        }
        this.createSetButton(height);
    }

    private void createSetButton(int height) {
        Button setButton = new Button(this.composite, 0);
        setButton.setText(Messages.SvdBinaryCellEditorBase_set);
        setButton.addKeyListener(this.keyListener);
        setButton.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SvdBinaryCellEditorBase.this.focusLost();
            }
        });
        RowData data = new RowData();
        data.width = 45;
        data.height = height;
        setButton.setLayoutData((Object)data);
        setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SvdBinaryCellEditorBase.this.apply = true;
                SvdBinaryCellEditorBase.this.focusLost();
            }
        });
    }

    private void addSeparator(Color background, int height, int bitNumber) {
        Label l;
        RowData rowData = new RowData();
        rowData.width = 3;
        rowData.height = height;
        if (bitNumber % 8 == 0) {
            rowData.width = 7;
            l = new Label(this.composite, 514);
        } else {
            l = new Label(this.composite, 0);
            l.setText(Messages.SvdBinaryCellEditorBase_dot_separator);
        }
        SvdBinaryCellEditorBase.decorate((Control)l, background);
        l.setLayoutData((Object)rowData);
    }

    protected abstract boolean isEditable(int var1);

    protected abstract String getBitToolTip(int var1);

    protected abstract int getBitLength();

    protected void focusLost() {
        super.focusLost();
    }

    protected Object doGetValue() {
        if (!this.apply) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int bitLength = this.getBitLength();
        int i = 0;
        while (i < bitLength) {
            Integer bitValue = (Integer)this.b[i].getData();
            builder.append(bitValue > 0 ? (char)'1' : '0');
            ++i;
        }
        BigInteger newValue = new BigInteger(builder.toString(), 2);
        SvdTrace.trace((String)"get value {}", (Object[])new Object[]{SvdTrace.lazy(() -> newValue.toString(2))});
        if (newValue.equals(this.value)) {
            return null;
        }
        return newValue;
    }

    protected void doSetValue(Object objValue) {
        this.value = objValue instanceof BigInteger ? (BigInteger)objValue : BigInteger.ZERO;
        SvdTrace.trace((String)"set value {}", (Object[])new Object[]{SvdTrace.lazy(() -> this.value.toString(2))});
        int bitLength = this.getBitLength();
        int i = 0;
        while (i < bitLength) {
            int bitNumber = bitLength - 1 - i;
            int bitValue = this.value.testBit(bitNumber) ? 1 : 0;
            this.b[i].setData((Object)bitValue);
            this.b[i].setText(Integer.toString(bitValue));
            ++i;
        }
    }

    public CellEditor.LayoutData getLayoutData() {
        int itemHeight = this.getItemHeight();
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (itemHeight > 0) {
            layoutData.minimumHeight = itemHeight + 2;
        }
        return layoutData;
    }

    private int getItemHeight() {
        Composite parent = this.composite.getParent();
        if (parent instanceof Tree) {
            return ((Tree)parent).getItemHeight();
        }
        return parent.getSize().y;
    }

    protected void doSetFocus() {
        this.composite.setFocus();
    }

    private static class LabelMouseAdapter
    extends MouseAdapter {
        private LabelMouseAdapter() {
        }

        public void mouseDown(MouseEvent e) {
            Label label = (Label)e.getSource();
            if (!label.isEnabled()) {
                return;
            }
            Integer data = (Integer)label.getData();
            if (data == null) {
                return;
            }
            data = data == 0 ? Integer.valueOf(1) : Integer.valueOf(0);
            label.setData((Object)data);
            label.setText(data.toString());
        }
    }

    private class SvdBinaryCellEditorListener
    implements ICellEditorListener {
        private SvdBinaryCellEditorListener() {
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        }

        public void cancelEditor() {
            SvdBinaryCellEditorBase.this.apply = false;
        }

        public void applyEditorValue() {
            SvdBinaryCellEditorBase.this.apply = true;
        }
    }
}

