/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit;

import com.nxp.s32ds.cdt.svd.internal.ui.CdtSvdUiActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewer;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInputs;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit.SvdBinaryFieldCellEditor;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit.SvdBinaryRegisterCellEditor;
import com.nxp.s32ds.cdt.svd.model.SvdField;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.utils.SvdFields;
import java.math.BigInteger;
import java.util.Optional;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;

public class SvdBinaryColumnEditingSupport
extends EditingSupport {
    public SvdBinaryColumnEditingSupport(SvdTreeViewer viewer) {
        super((ColumnViewer)viewer);
    }

    public SvdTreeViewer getViewer() {
        return (SvdTreeViewer)super.getViewer();
    }

    protected boolean canEdit(Object element) {
        return SvdTreeViewerInputs.canWrite(this.getViewer(), element);
    }

    protected Object getValue(Object element) {
        Optional<BigInteger> value = Optional.ofNullable(SvdTreeViewerInputs.getValue(this.getViewer(), element));
        if (element instanceof SvdField) {
            SvdField field = (SvdField)element;
            return value.map(v -> SvdFields.getFieldValue((SvdField)field, (BigInteger)v)).orElse(BigInteger.ZERO);
        }
        if (element instanceof SvdRegister) {
            return value.orElse(BigInteger.ZERO);
        }
        return null;
    }

    protected void setValue(Object element, Object objValue) {
        if (!(objValue instanceof BigInteger)) {
            return;
        }
        BigInteger value = (BigInteger)objValue;
        if (element instanceof SvdField) {
            this.setFieldVallue(element, value);
            return;
        }
        if (element instanceof SvdRegister) {
            SvdTreeViewerInputs.setValue(this.getViewer(), (SvdRegister)element, value);
            return;
        }
        CdtSvdUiActivator.getInstance().logError("SvdBinaryColumnEditingSupport - unknown object type:" + element);
    }

    private void setFieldVallue(Object element, BigInteger value) {
        SvdField field = (SvdField)element;
        SvdRegister register = field.getParent();
        BigInteger registerValueBI = Optional.ofNullable(SvdTreeViewerInputs.getValue(this.getViewer(), register)).orElse(BigInteger.ZERO);
        SvdTreeViewerInputs.setValue(this.getViewer(), register, SvdFields.applyFieldValue((SvdField)field, (BigInteger)registerValueBI, (BigInteger)value));
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof SvdField) {
            return new SvdBinaryFieldCellEditor((Composite)this.getViewer().getControl(), (SvdField)element);
        }
        if (element instanceof SvdRegister) {
            return new SvdBinaryRegisterCellEditor((Composite)this.getViewer().getControl(), (SvdRegister)element);
        }
        return null;
    }
}

