/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.arm.core;

import com.freescale.s32ds.cross.core.model.DefaultWizardValueProvider;
import com.freescale.s32ds.cross.core.model.IWizardValueProvider;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.AbstractSdkSmartFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.FilterOptionsImplementation;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.filtering.FilterOptions;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilteringParameters;
import com.nxp.s32ds.cle.cdt.wizard.core.WizardProjectContextSdkFilter;
import com.nxp.s32ds.cle.ide.sdk.core.ProjectSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ArmWizardValueProvider
extends DefaultWizardValueProvider
implements IWizardValueProvider {
    private static final String TEMPLATE_VARIABLE_PEX = "pex";
    private static final String TEMPLATE_VARIABLE_UCT = "uct";
    private static final String TEMPLATE_VARIABLE_PROJECT_BASE_TEMPLATE = "project.base.template";
    private static final String TAG_VALUE_UCT = "uct";
    private static final String OP_TOOLCHAIN = "toolchain";
    private static final String HOST_TOOLCHAIN = "host_toolchain";
    private static final String CLUSTER_OP_MODE = "cluster_mode";
    private static final String CLUSTER_0_OP_MODE = "cluster_0_mode";
    private static final String CLUSTER_1_OP_MODE = "cluster_1_mode";
    private static final String CLUSTER_2_OP_MODE = "cluster_2_mode";
    private static final String CLUSTER_3_OP_MODE = "cluster_3_mode";
    private static final String CLUSTER_4_OP_MODE = "cluster_4_mode";
    private static final String CLUSTER_5_OP_MODE = "cluster_5_mode";
    private static final String CLUSTER_6_OP_MODE = "cluster_6_mode";
    private static final String CLUSTER_7_OP_MODE = "cluster_7_mode";
    private static final String CLUSTER_OP_MODE_NONE = "none";
    private static final String AUTOSTART_CORE = "true";
    private static final String CORE_0_NUMBER = "0";
    private static final String CORE_1_NUMBER = "1";
    private static final String CLUSTER_0_NUMBER = "0";
    private static final String CLUSTER_1_NUMBER = "1";
    private static final String CLUSTER_2_NUMBER = "2";
    private static final String CLUSTER_3_NUMBER = "3";

    public Map<String, String> createValueMap(ProjectContext context, String location) {
        Map mapSdkByTag;
        Map res = super.createValueMap(context, location);
        if (!(context instanceof CProjectContext)) {
            return res;
        }
        CProjectContext projectContext = (CProjectContext)context;
        ProcessorContext processorContext = projectContext.getProcessorContext();
        List coreNatures = processorContext.getCoreNatures();
        res.put("GROUP_NAME", coreNatures.size() < 2 ? "" : projectContext.getProjectBaseName());
        res.put("DEVICE_NAME", processorContext.getProcessor().getId());
        res.put("projectNameSafe", Pattern.quote(projectContext.getProjectName()));
        res.put("GROUP_SAFE", coreNatures.size() < 2 ? "" : Pattern.quote(projectContext.getProjectBaseName()));
        if (projectContext.isExecutable()) {
            res.put("FLASH_START", Long.toHexString(projectContext.getLongValue("flashStart")));
            res.put("RAM_START", Long.toHexString(projectContext.getLongValue("ramStart")));
            res.put("FLASH_LENGTH", Long.toString(projectContext.getLongValue("flashSize") / 1024L));
            res.put("RAM_LENGTH", Long.toString(projectContext.getLongValue("ramSize") / 1024L));
        }
        String tcId = projectContext.getTemplate().getTemplateInfo(projectContext.isExecutable()).getToolChainId();
        res.put(OP_TOOLCHAIN, tcId);
        String baseclustercoreopmode = CLUSTER_OP_MODE_NONE;
        String opmode = CLUSTER_OP_MODE_NONE;
        String opmode_0 = CLUSTER_OP_MODE_NONE;
        String opmode_1 = CLUSTER_OP_MODE_NONE;
        String opmode_2 = CLUSTER_OP_MODE_NONE;
        String opmode_3 = CLUSTER_OP_MODE_NONE;
        String opmode_4 = CLUSTER_OP_MODE_NONE;
        String opmode_5 = CLUSTER_OP_MODE_NONE;
        String opmode_6 = CLUSTER_OP_MODE_NONE;
        String opmode_7 = CLUSTER_OP_MODE_NONE;
        int cnt = 0;
        int num_cores = 0;
        for (CProjectContext c : processorContext.getProjectContexts()) {
            if (c.isAutoStart()) {
                String toolChainId = c.getTemplate().getTemplateInfo(projectContext.isExecutable()).getToolChainId();
                res.put(HOST_TOOLCHAIN, toolChainId);
            }
            String p = "TURN_ON_CPU" + cnt;
            String n = "PROJECT_NAME_" + cnt;
            String indx = "PROJECT_INDEX_" + cnt;
            res.put(p, Boolean.toString(c.isActive()));
            if (!c.getStringValue("opmode").isEmpty()) {
                String curClusterNum = this.getClusterNumber(projectContext);
                String curCoreNum = this.getCoreNumber(projectContext);
                if (!curClusterNum.isEmpty() && !curCoreNum.isEmpty() && this.isProjectForBaseCoreCluster(c, curClusterNum, curCoreNum)) {
                    baseclustercoreopmode = c.getStringValue("opmode");
                }
                if (!curClusterNum.isEmpty() && !curCoreNum.isEmpty() && projectContext.getStringValue("primaryCore").isEmpty() && this.isProjectForCoreCluster(c, curClusterNum, curCoreNum) && opmode == CLUSTER_OP_MODE_NONE) {
                    if (!projectContext.containsParameter("opmode")) {
                        opmode = baseclustercoreopmode;
                    }
                    if (projectContext.containsParameter("opmode")) {
                        opmode = c.getStringValue("opmode");
                    }
                }
                curClusterNum = this.getClusterNumber(c);
                curCoreNum = this.getCoreNumber(c);
                if (!(curClusterNum.isEmpty() || curCoreNum.isEmpty() || projectContext.getStringValue("primaryCore").isEmpty())) {
                    String primaryCore = projectContext.getStringValue("primaryCore");
                    String primaryClusterNum = this.getClusterNumber(primaryCore);
                    String primaryCoreNum = this.getCoreNumber(primaryCore);
                    if (curClusterNum.equals(primaryClusterNum) && curCoreNum.equals(primaryCoreNum)) {
                        opmode = c.getStringValue("opmode");
                    }
                }
                if (!curClusterNum.isEmpty() && !curCoreNum.isEmpty()) {
                    if ("0".equals(curClusterNum) && "0".equals(curCoreNum) && c.containsParameter("opmode")) {
                        opmode_0 = c.getStringValue("opmode");
                    }
                    if ("0".equals(curClusterNum) && "1".equals(curCoreNum) && c.containsParameter("opmode")) {
                        opmode_1 = c.getStringValue("opmode");
                    }
                    if ("1".equals(curClusterNum) && "0".equals(curCoreNum) && c.containsParameter("opmode")) {
                        if (opmode_1 == CLUSTER_OP_MODE_NONE) {
                            opmode_1 = c.getStringValue("opmode");
                        } else {
                            opmode_2 = c.getStringValue("opmode");
                        }
                    }
                    if ("1".equals(curClusterNum) && "1".equals(curCoreNum) && c.containsParameter("opmode")) {
                        opmode_3 = c.getStringValue("opmode");
                    }
                    if (CLUSTER_2_NUMBER.equals(curClusterNum) && "0".equals(curCoreNum) && c.containsParameter("opmode")) {
                        if (opmode_3 == CLUSTER_OP_MODE_NONE) {
                            opmode_2 = c.getStringValue("opmode");
                        } else {
                            opmode_4 = c.getStringValue("opmode");
                        }
                    }
                    if (CLUSTER_2_NUMBER.equals(curClusterNum) && "1".equals(curCoreNum) && c.containsParameter("opmode")) {
                        opmode_5 = c.getStringValue("opmode");
                    }
                    if (CLUSTER_3_NUMBER.equals(curClusterNum) && "0".equals(curCoreNum) && c.containsParameter("opmode")) {
                        if (opmode_5 == CLUSTER_OP_MODE_NONE) {
                            opmode_3 = c.getStringValue("opmode");
                        } else {
                            opmode_6 = c.getStringValue("opmode");
                        }
                    }
                    if (CLUSTER_3_NUMBER.equals(curClusterNum) && "1".equals(curCoreNum) && c.containsParameter("opmode")) {
                        opmode_7 = c.getStringValue("opmode");
                    }
                }
            }
            if (c.isExecutable()) {
                String f = "FLASH_START_" + (cnt + 1);
                String r = "RAM_START_" + (cnt + 1);
                String f_s = "FLASH_LENGTH_" + (cnt + 1);
                String r_s = "RAM_LENGTH_" + (cnt + 1);
                res.put(f, Long.toHexString(c.getLongValue("flashStart")));
                res.put(r, Long.toHexString(c.getLongValue("ramStart")));
                res.put(f_s, Long.toHexString(c.getLongValue("flashSize")));
                res.put(r_s, Long.toHexString(c.getLongValue("ramSize")));
            }
            if (c.isActive()) {
                res.put(indx, Integer.toString(num_cores));
                ++num_cores;
            } else {
                res.put(indx, Integer.toString(0));
            }
            String name_gr = coreNatures.size() < 2 ? "" : projectContext.getProjectBaseName();
            res.put(n, String.valueOf(name_gr) + "_" + c.getSuffix());
            ++cnt;
        }
        if (!CLUSTER_OP_MODE_NONE.equals(opmode)) {
            res.put(CLUSTER_OP_MODE, opmode);
        }
        if (!CLUSTER_OP_MODE_NONE.equals(opmode_0)) {
            res.put(CLUSTER_0_OP_MODE, opmode_0);
        }
        if (!CLUSTER_OP_MODE_NONE.equals(opmode_1)) {
            res.put(CLUSTER_1_OP_MODE, opmode_1);
        }
        if (!CLUSTER_OP_MODE_NONE.equals(opmode_2)) {
            res.put(CLUSTER_2_OP_MODE, opmode_2);
        }
        if (!CLUSTER_OP_MODE_NONE.equals(opmode_3)) {
            res.put(CLUSTER_3_OP_MODE, opmode_3);
        }
        if (!CLUSTER_OP_MODE_NONE.equals(opmode_4)) {
            res.put(CLUSTER_4_OP_MODE, opmode_4);
        }
        if (!CLUSTER_OP_MODE_NONE.equals(opmode_5)) {
            res.put(CLUSTER_5_OP_MODE, opmode_5);
        }
        if (!CLUSTER_OP_MODE_NONE.equals(opmode_6)) {
            res.put(CLUSTER_6_OP_MODE, opmode_6);
        }
        if (!CLUSTER_OP_MODE_NONE.equals(opmode_7)) {
            res.put(CLUSTER_7_OP_MODE, opmode_7);
        }
        res.put("NUMBER_OF_SLAVE_CORES", Integer.toString(num_cores - 1));
        res.put(TEMPLATE_VARIABLE_PEX, Boolean.toString(SdkManagementUtils.isPex((List)projectContext.getSdkList())));
        res.put("uct", Boolean.FALSE.toString());
        res.put(TEMPLATE_VARIABLE_PROJECT_BASE_TEMPLATE, Boolean.FALSE.toString());
        Map mapSdkByTargetProjectTemplate = SdkManagementUtils.getSdksTargetProjectTemplateIds((List)projectContext.getSdkList(), (SdkFilter)ArmWizardValueProvider.getSdkFilter(projectContext));
        if (mapSdkByTargetProjectTemplate != null && mapSdkByTargetProjectTemplate.containsKey(TEMPLATE_VARIABLE_PROJECT_BASE_TEMPLATE)) {
            res.put(TEMPLATE_VARIABLE_PROJECT_BASE_TEMPLATE, Boolean.TRUE.toString());
        }
        if ((mapSdkByTag = SdkManagementUtils.getSdksGroupByTags((List)projectContext.getSdkList())) != null && mapSdkByTag.containsKey("uct")) {
            res.put("uct", Boolean.TRUE.toString());
        }
        return res;
    }

    private boolean isProjectForCoreCluster(CProjectContext c, String curClusterNum, String curCoreNum) {
        return ("0".equals(curClusterNum) || "1".equals(curClusterNum) || CLUSTER_2_NUMBER.equals(curClusterNum) || CLUSTER_3_NUMBER.equals(curClusterNum)) && this.getClusterNumber(c).equals(curClusterNum) && this.getCoreNumber(c).equals(curCoreNum) || !"0".equals(curClusterNum) && !"1".equals(curClusterNum) && !CLUSTER_2_NUMBER.equals(curClusterNum) && !CLUSTER_3_NUMBER.equals(curClusterNum) && "0".equals(this.getClusterNumber(c)) && "0".equals(this.getCoreNumber(c));
    }

    private boolean isProjectForBaseCoreCluster(CProjectContext c, String curClusterNum, String curCoreNum) {
        return ("0".equals(curClusterNum) || "1".equals(curClusterNum) || CLUSTER_2_NUMBER.equals(curClusterNum) || CLUSTER_3_NUMBER.equals(curClusterNum)) && this.getClusterNumber(c).equals(curClusterNum) && "0".equals(this.getCoreNumber(c)) || !"0".equals(curClusterNum) && !"1".equals(curClusterNum) && !CLUSTER_2_NUMBER.equals(curClusterNum) && !CLUSTER_3_NUMBER.equals(curClusterNum) && "0".equals(this.getClusterNumber(c)) && "0".equals(this.getCoreNumber(c));
    }

    private String getClusterNumber(CProjectContext prtContext) {
        String[] parts = prtContext.getStringValue("core").split("_");
        if (parts.length > 2) {
            return parts[parts.length - 2];
        }
        return "";
    }

    private String getClusterNumber(String core) {
        String[] parts = core.split("_");
        if (parts.length > 2) {
            return parts[parts.length - 2];
        }
        return "";
    }

    private String getCoreNumber(CProjectContext prtContext) {
        String[] parts = prtContext.getStringValue("core").split("_");
        if (parts.length > 2) {
            return parts[parts.length - 1];
        }
        return "";
    }

    private String getCoreNumber(String core) {
        String[] parts = core.split("_");
        if (parts.length > 2) {
            return parts[parts.length - 1];
        }
        return "";
    }

    private static SdkFilter getSdkFilter(final CProjectContext projectContext) {
        return new AbstractSdkSmartFilter(){

            public boolean accept(SdkDescriptor sdk) {
                return ProjectSdkDescriptors.getProjectSdkDescriptorBySdkId((String)sdk.getId()) != null;
            }

            public FilterOptions options() {
                return FilterOptionsImplementation.createFilter((SdkFilteringParameters)new WizardProjectContextSdkFilter(projectContext));
            }
        };
    }
}

