/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.examples.core.utils;

import com.nxp.s32ds.ext.rcp.jse.utils.FuncUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.resources.RefreshExclusion;
import org.eclipse.cdt.core.resources.RefreshScopeManager;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;

public final class ExampleImportUtils {
    private static final String WSP_LOC_ESCAPED = "\\${workspace_loc:/";
    private static final String WSP_LOC = "${workspace_loc:/";
    private static final String WSP_LOC_UNBRACKETED = "workspace_loc:/";
    private static final String PROJ_DIR_RELATIVE_PATH = "${ProjDirPath}/../";
    private static final String QUO = "\"";
    public static final String EMPTY = "";
    private static final List<String> LIB_OPTIONS = Arrays.asList("gnu.c.link.option.paths", "gnu.c.link.option.libs", "gnu.cpp.link.option.paths", "gnu.cpp.link.option.libs");

    private ExampleImportUtils() {
    }

    public static void rename(IProject project, String projectSetsName, String name, Map<String, String> nameMap, IProgressMonitor monitor) throws CoreException, BuildException {
        HashMap<IProject, ICProjectDescription> changedProjects = new HashMap<IProject, ICProjectDescription>();
        if (CoreModel.hasCNature((IProject)project)) {
            ExampleImportUtils.updateCProject(project, projectSetsName, name, changedProjects);
            IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
            if (buildInfo != null) {
                ManagedProject managed = (ManagedProject)ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject();
                managed.setId(ExampleImportUtils.renameAll("(?<=^)[^.]*(?=\\..*$)", nameMap).apply(managed.getId()));
            }
        }
        ExampleImportUtils.updateReferencesProject(project, nameMap);
        ExampleImportUtils.updateRefreshScopes(nameMap, changedProjects);
        for (Map.Entry desc : changedProjects.entrySet()) {
            ICProjectDescription value = (ICProjectDescription)desc.getValue();
            if (value == null) continue;
            CoreModel.getDefault().setProjectDescription((IProject)desc.getKey(), value, true, monitor);
        }
        RefreshScopeManager rsm = RefreshScopeManager.getInstance();
        rsm.clearAllData();
        rsm.loadSettings();
    }

    private static void updateCProject(IProject project, String projectSetsName, String name, Map<IProject, ICProjectDescription> changedProjects) throws CoreException, BuildException {
        ICProjectDescription desc;
        if (!changedProjects.containsKey(project)) {
            changedProjects.put(project, CoreModel.getDefault().getProjectDescription(project));
        }
        if ((desc = changedProjects.get(project)) != null) {
            ICConfigurationDescription[] iCConfigurationDescriptionArray = desc.getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cConfig = iCConfigurationDescriptionArray[n2];
                IConfiguration configurationForDescription = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cConfig);
                if (configurationForDescription != null) {
                    IBuilder builder = configurationForDescription.getBuilder();
                    String oldName = WSP_LOC_ESCAPED + project.getDescription().getName() + '}';
                    String newName = WSP_LOC_ESCAPED + project.getName() + '}';
                    builder.setBuildPath(builder.getBuildPath().replace(oldName, newName));
                    Map referencesFrom = cConfig.getReferenceInfo();
                    HashMap<String, String> referencesTo = new HashMap<String, String>();
                    for (Map.Entry iter : referencesFrom.entrySet()) {
                        String key = ((String)iter.getKey()).replaceFirst(projectSetsName, name);
                        referencesTo.put(key, (String)iter.getValue());
                    }
                    cConfig.setReferenceInfo(referencesTo);
                    ITool[] iToolArray = configurationForDescription.getTools();
                    int n3 = iToolArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ITool tool = iToolArray[n4];
                        ExampleImportUtils.renameToolOptions(tool, projectSetsName, name);
                        ExampleImportUtils.updateLists(tool, project, projectSetsName, name);
                        ++n4;
                    }
                    ExampleImportUtils.updateSourceEntries(configurationForDescription, projectSetsName, name);
                    ExampleImportUtils.updateReferencesToRelatedProjects(configurationForDescription, projectSetsName, name);
                }
                ++n2;
            }
        }
    }

    private static void updateRefreshScopes(Map<String, String> nameMap, Map<IProject, ICProjectDescription> changedProjects) throws CoreException {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (CoreModel.hasCNature((IProject)project) && !nameMap.keySet().contains(project.getName())) {
                ExampleImportUtils.updateRefreshScope(project, changedProjects, nameMap);
            }
            ++n2;
        }
    }

    private static void updateRefreshScope(IProject project, Map<IProject, ICProjectDescription> changedProjects, Map<String, String> nameMap) throws CoreException {
        RefreshScopeManager rsm = RefreshScopeManager.getInstance();
        rsm.clearAllData();
        rsm.loadSettings();
        HashMap cfgToResourcesMap = rsm.getConfigurationToResourcesMap(project);
        boolean isChanged = false;
        for (Map.Entry en : cfgToResourcesMap.entrySet()) {
            isChanged |= ExampleImportUtils.updateRefreshScopeInCfg(project, (String)en.getKey(), (HashMap)en.getValue(), nameMap, rsm);
        }
        if (isChanged) {
            if (!changedProjects.containsKey(project)) {
                changedProjects.put(project, CoreModel.getDefault().getProjectDescription(project));
            }
            rsm.persistSettings(changedProjects.get(project));
        }
    }

    private static boolean updateRefreshScopeInCfg(IProject project, String configName, HashMap<IResource, List<RefreshExclusion>> vals, Map<String, String> nameMap, RefreshScopeManager rsm) {
        boolean result = false;
        for (IResource oldResource : new HashSet<IResource>(vals.keySet())) {
            String resourceProjectName = oldResource.getProject().getName();
            if (!nameMap.containsKey(resourceProjectName)) continue;
            String newProjectName = nameMap.get(resourceProjectName);
            List<RefreshExclusion> exclusion = vals.get(oldResource);
            IResource newResource = ExampleImportUtils.calcNewResource(oldResource, newProjectName);
            rsm.deleteResourceToRefresh(project, configName, oldResource);
            rsm.setExclusions(project, configName, newResource, exclusion);
            result = true;
        }
        return result;
    }

    private static IResource calcNewResource(IResource oldResource, String newProjectName) {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newProjectName);
        if (oldResource instanceof IProject) {
            return newProject;
        }
        if (oldResource instanceof IFolder) {
            return newProject.getFolder(oldResource.getProjectRelativePath());
        }
        if (oldResource instanceof IFile) {
            return newProject.getFile(oldResource.getProjectRelativePath());
        }
        return null;
    }

    private static void renameToolOptions(ITool tool, String projectSetsName, String name) throws BuildException {
        String toolName = tool.getBaseId();
        ArrayList<IOption> ghsOptionsToUpdate = new ArrayList<IOption>();
        if (toolName.indexOf("cx_linker") != -1 || toolName.indexOf("cc_linker") != -1) {
            String c_cpp_tool;
            String string = toolName.contains("cx_linker") ? "cx_linker" : (c_cpp_tool = toolName.contains("cc_linker") ? "cc_linker" : null);
            if (c_cpp_tool != null) {
                ExampleImportUtils.addIfNonNull(ghsOptionsToUpdate, tool, "ghs.managedmake.arm.executable.toolchain." + c_cpp_tool + ".linker.raw_import_files");
                ExampleImportUtils.addIfNonNull(ghsOptionsToUpdate, tool, "ghs.managedmake.arm64.executable.toolchain." + c_cpp_tool + ".linker.raw_import_files");
                ExampleImportUtils.addIfNonNull(ghsOptionsToUpdate, tool, "ghs.managedmake.arm.executable.toolchain." + c_cpp_tool + ".project.libraries");
                ExampleImportUtils.addIfNonNull(ghsOptionsToUpdate, tool, "ghs.managedmake.arm64.executable.toolchain." + c_cpp_tool + ".project.libraries");
            }
        }
        for (IOption opt : ghsOptionsToUpdate) {
            ArrayList<String> curValueList = new ArrayList<String>(Arrays.asList(opt.getBasicStringListValue()));
            if (opt.getBasicValueType() != 3) continue;
            opt.setValue(curValueList.stream().map(s -> s.replace(projectSetsName, name)).collect(Collectors.toList()));
        }
        if (toolName.indexOf(".linker") != -1 && toolName.indexOf("iar") != -1) {
            List opts = Stream.of("iar.arm.toolchain.linker.option.extraOptions.v5.4.0", "iar.arm.toolchain.linker.option.imageInput.v5.4.0").map(arg_0 -> ((ITool)tool).getOptionBySuperClassId(arg_0)).collect(Collectors.toList());
            if (opts.stream().allMatch(Objects::nonNull)) {
                opts.stream().forEach(ExampleImportUtils.renameOption(projectSetsName, name));
            }
        }
    }

    private static void addIfNonNull(List<IOption> options, ITool tool, String superClassId) {
        IOption option = tool.getOptionBySuperClassId(superClassId);
        if (option != null) {
            options.add(option);
        }
    }

    private static Consumer<IOption> renameOption(String oldName, String newName) {
        return FuncUtils.rethrowingConsumer(opt -> {
            if (opt.getBasicValueType() == 2) {
                opt.setValue(opt.getStringValue().replace(oldName, newName));
            }
        });
    }

    private static Function<String, String> renameAll(String regex, Map<String, String> nameMap) {
        return ExampleImportUtils.replaceAll(regex, key -> nameMap.getOrDefault(key, (String)key));
    }

    private static Function<String, String> replaceAll(String regexp, Function<String, String> func) {
        return input -> {
            Matcher matcher = Pattern.compile(regexp).matcher((CharSequence)input);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, (String)func.apply(matcher.group()));
            }
            matcher.appendTail(sb);
            return sb.toString();
        };
    }

    private static void updateReferencesProject(IProject project, Map<String, String> nameMap) throws CoreException {
        IProjectDescription pd = project.getDescription();
        pd.setName(nameMap.get(pd.getName()));
        URI locationURI = pd.getLocationURI();
        IStatus result = ResourcesPlugin.getWorkspace().validateProjectLocationURI(project, locationURI);
        if (!result.isOK()) {
            throw new CoreException(result);
        }
        Path path = new Path(locationURI.getRawPath());
        String lastSegment = URIUtil.lastSegment((URI)locationURI);
        String segmentReplacement = nameMap.get(lastSegment);
        if (segmentReplacement != null) {
            String newLastSegment = lastSegment.replace(lastSegment, segmentReplacement);
            IPath newPath = path.removeLastSegments(1).append(newLastSegment);
            pd.setLocation(newPath);
        }
        project.move(pd, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IProject toProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    private static void updateLists(ITool tool, IProject project, String oldSetName, String newSetName) throws CoreException {
        IOption[] iOptionArray = tool.getOptions();
        int n = iOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOption op = iOptionArray[n2];
            if (!ExampleImportUtils.isLibOption(op)) {
                ExampleImportUtils.updateOption(op, project, oldSetName, newSetName);
            }
            ++n2;
        }
    }

    private static boolean isLibOption(IOption option) {
        return LIB_OPTIONS.contains(option.getBaseId());
    }

    private static void updateOption(IOption op, IProject project, String oldSetName, String newSetName) throws CoreException {
        try {
            String[] data = ExampleImportUtils.getDataByValueType(op);
            if (data != null) {
                boolean isChanged = false;
                int i = 0;
                while (i < data.length) {
                    String res = ExampleImportUtils.updateValue(data[i], project, oldSetName, newSetName);
                    if (!data[i].equals(res)) {
                        data[i] = res;
                        isChanged = true;
                    }
                    ++i;
                }
                if (isChanged) {
                    op.setValue(data);
                }
            }
        }
        catch (BuildException e) {
            Status status = new Status(4, "com.nxp.s32ds.ext.cdt.examples.core", e.getMessage(), (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    private static String[] getDataByValueType(IOption op) throws BuildException {
        String[] data;
        switch (op.getValueType()) {
            case 3: {
                data = op.getStringListValue();
                break;
            }
            case 4: {
                data = op.getIncludePaths();
                break;
            }
            case 9: {
                data = op.getLibraryPaths();
                break;
            }
            case 7: {
                data = op.getBasicStringListValue();
                break;
            }
            default: {
                data = null;
            }
        }
        return data;
    }

    private static String updateValue(String oldValue, IProject project, String oldSetName, String newSetName) throws CoreException {
        String value = oldValue.replace('\\', '/');
        String quote = value.startsWith(QUO) ? QUO : EMPTY;
        String newName = project.getName();
        String oldLocation = (project.getLocation().removeLastSegments(1) + File.separator + project.getDescription().getName()).replace('\\', '/');
        String newLocation = (project.getLocation().removeLastSegments(1) + File.separator + newName).replace('\\', '/');
        String absolute = String.valueOf(quote) + oldLocation;
        if (value.startsWith(absolute)) {
            return String.valueOf(quote) + newLocation + value.substring(absolute.length());
        }
        String oldWsName = WSP_LOC + oldSetName;
        oldWsName = String.valueOf(quote) + oldWsName;
        if (value.startsWith(oldWsName)) {
            return value.replaceFirst(oldSetName, newSetName);
        }
        String oldPPName = PROJ_DIR_RELATIVE_PATH + oldSetName;
        oldPPName = String.valueOf(quote) + oldPPName;
        if (value.startsWith(oldPPName)) {
            return value.replaceFirst(oldSetName, newSetName);
        }
        return oldValue;
    }

    private static void updateSourceEntries(IConfiguration config, String oldName, String newName) {
        ICSourceEntry[] entries = new ICSourceEntry[config.getSourceEntries().length];
        int i = 0;
        ICSourceEntry[] iCSourceEntryArray = config.getSourceEntries();
        int n = iCSourceEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceEntry entry = iCSourceEntryArray[n2];
            IPath[] exclusions = new IPath[entry.getExclusionPatterns().length];
            int j = 0;
            IPath[] iPathArray = entry.getExclusionPatterns();
            int n3 = iPathArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath exclusion = iPathArray[n4];
                exclusions[j] = exclusion.toString().contains(oldName) ? new Path(exclusion.toString().replaceAll(oldName, newName)) : new Path(exclusion.toString());
                ++j;
                ++n4;
            }
            entries[i] = new CSourceEntry(entry.getName(), exclusions, entry.getFlags());
            ++i;
            ++n2;
        }
        config.setSourceEntries(entries);
    }

    private static void updateReferencesToRelatedProjects(IConfiguration config, String oldName, String newName) {
        String prebuildStep = config.getPrebuildStep();
        String postbuildStep = config.getPostbuildStep();
        if (prebuildStep.isEmpty() && postbuildStep.isEmpty() || !prebuildStep.contains(oldName) && !postbuildStep.contains(oldName)) {
            return;
        }
        String newPrebuildStep = prebuildStep.replaceAll(WSP_LOC_UNBRACKETED + oldName, WSP_LOC_UNBRACKETED + newName);
        String newPostBuildStep = postbuildStep.replaceAll(WSP_LOC_UNBRACKETED + oldName, WSP_LOC_UNBRACKETED + newName);
        config.setPrebuildStep(newPrebuildStep);
        config.setPostbuildStep(newPostBuildStep);
    }
}

