/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data;

import com.nxp.swtools.clocks.data.ClockSlice;
import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.model.ClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ClockComponent
implements IClockComponent {
    @NonNull
    private String compID;
    @NonNull
    private String peripheral;
    @NonNull
    private String name;
    @NonNull
    private @NonNull Map<@NonNull String, IClockElement> elements;
    @NonNull
    private @NonNull Collection<@NonNull IConfigElement> controlElements;
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull String> outputSignals;
    @Nullable
    private EnableSetting enableSetting;
    @NonNull
    private @NonNull List<@NonNull ClockSlice> slices;
    @NonNull
    protected @NonNull List<@NonNull Constraint> constraints;

    public ClockComponent(@NonNull String id, @NonNull String name, @NonNull String peripheral, @NonNull Map<@NonNull String, IClockElement> elements, @NonNull Map<@NonNull String, @NonNull String> outputSignals, @NonNull Collection<@NonNull IConfigElement> controlElements, @Nullable EnableSetting componentEnableSetting, @NonNull List<@NonNull Constraint> constraints) {
        this.compID = id;
        this.peripheral = peripheral;
        this.name = name;
        this.elements = elements;
        this.outputSignals = outputSignals;
        this.controlElements = controlElements;
        this.enableSetting = componentEnableSetting;
        this.slices = new ArrayList<ClockSlice>();
        this.constraints = (List)constraints.stream().filter(x -> id.equals(x.getElementID())).collect(CollectorsUtils.toList());
    }

    @Override
    public @NonNull String getPeripheral() {
        return this.peripheral;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public String getID() {
        return this.compID;
    }

    @Override
    public Map<String, IClockElement> getElementsMap() {
        return this.elements;
    }

    @Override
    public Collection<IClockElement> getElements() {
        return this.elements.values();
    }

    @Override
    public Map<String, String> getOutputMapping() {
        return this.outputSignals;
    }

    @Override
    public @NonNull Collection<@NonNull IConfigElement> getGlobalConfigElements() {
        return this.controlElements;
    }

    @Override
    public @Nullable IClockElement getClockElement(@NonNull String id) {
        if (this.elements.containsKey(id)) {
            return this.elements.get(id);
        }
        for (ClockSlice slice : this.slices) {
            if (!slice.getElements().containsKey(id)) continue;
            return slice.getElements().get(id);
        }
        for (IClockElement element : this.elements.values()) {
            List<IClockElement> internalElems = element.getInternalElements();
            if (internalElems == null) continue;
            for (IClockElement internalElement : internalElems) {
                if (!internalElement.getID().equals(id)) continue;
                return internalElement;
            }
        }
        return this.elements.get(String.valueOf(this.compID) + "." + id);
    }

    public void setEnableSetting(@Nullable EnableSetting enableSetting) {
        this.enableSetting = enableSetting;
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig config) {
        return this.enableSetting != null ? this.enableSetting.isEnabled(config) : true;
    }

    @Override
    public @Nullable EnableSetting getEnableSetting() {
        return this.enableSetting;
    }

    @Override
    public @NonNull List<@NonNull ClockSlice> getSlices() {
        return this.slices;
    }

    @Override
    public void setSlices(@NonNull List<@NonNull ClockSlice> slices) {
        this.slices = slices;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull List<@NonNull Constraint> evaluateConstraints(@NonNull ClocksConfig config) {
        @NonNull List violatedConstraints = (List)this.constraints.stream().filter(x -> !x.isValid(config)).collect(CollectorsUtils.toList());
        return violatedConstraints;
    }
}

