/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.ErrorHelper;
import com.nxp.swtools.clocks.data.IConstraint;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.AClockElement;
import com.nxp.swtools.clocks.data.elements.AClockModelCreationElement;
import com.nxp.swtools.clocks.data.elements.ClockElementData;
import com.nxp.swtools.clocks.data.elements.ElementType;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.PowerModeSpecificElement;
import com.nxp.swtools.clocks.data.elements.Prescaler;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.model.ClockModel;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.INode;
import com.nxp.swtools.clocks.model.ModelCreationI;
import com.nxp.swtools.clocks.model.MulConstr;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyCalculator;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Fll
extends AClockElement {
    @NonNull
    private final Prescaler multiplier;
    @NonNull
    private final @NonNull List<@NonNull IClockElement> internalElements = new ArrayList<IClockElement>(1);
    @NonNull
    private final ENodeType type;

    public Fll(@NonNull ClockElementData elementData, @NonNull Prescaler multiplier) {
        super(elementData.getRegisters(), elementData.getId(), elementData.getName(), elementData.getDescription(), elementData.getInputSignal(), elementData.getConstraints(), elementData.getConfigElements(), elementData.isPrioritized());
        super.setPowerModeSpecific(elementData.isPowerModeSpecific);
        this.multiplier = multiplier;
        this.internalElements.add(multiplier);
        EnableSetting fllEnable = new EnableSetting(this.id, (IElement)this, elementData.getEnableDisableConditions());
        this.addNestedSetting(fllEnable);
        this.type = multiplier.getElementConstraints().isEmpty() ? ENodeType.FLL : ENodeType.FLLext;
        this.modelDevice = new FllModel(this.id, this.type, multiplier);
        ISetting internalMultiplierSetting = multiplier.getFrequencyModifierSetting();
        if (internalMultiplierSetting != null) {
            this.settings.put(internalMultiplierSetting.getId(), internalMultiplierSetting);
        } else {
            LOGGER.severe("No multiplier for the FLL elemnt found!");
        }
        EnableSetting multiplierEnable = multiplier.getEnableSetting();
        if (multiplierEnable != null) {
            multiplierEnable.setSoftEnableCondition(Expression.create(fllEnable.getId()));
        }
    }

    @Override
    public @Nullable ISetting getMainSetting() {
        return null;
    }

    @Override
    public @NonNull List<@NonNull IClockElement> getInternalElements() {
        return this.internalElements;
    }

    @Override
    public String getType() {
        return ElementType.FLL.toString();
    }

    public @NonNull Prescaler getMultiplier() {
        return this.multiplier;
    }

    @Override
    public void updateMinMaxConstraints(@NonNull List<@NonNull Constraint> applicableConstraints, @NonNull Node compNode) {
    }

    @Override
    protected @NonNull List<@NonNull Constraint> getAllApplicableConstraints(@NonNull IClocksConfig config) {
        Node node = this.getMultiplier().getComputationNode(config);
        BigRational scale = node != null ? node.getScale() : BigRational.ZERO;
        BigRational divide = scale != null ? scale : BigRational.ZERO;
        return this.getValidApplicableConstraints(config, divide);
    }

    @Override
    protected @NonNull PowerModeSpecificElement createPowerModeSpecific() {
        return new PowerModeSpecificElement(() -> null, () -> {
            ArrayList<@NonNull IClockElement> allConfigElements = new ArrayList<IClockElement>(this.configElements);
            allConfigElements.addAll(this.internalElements);
            return allConfigElements;
        });
    }

    public static @NonNull ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ModelCreationI.FLLextSingleData> createDataForFllExt(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ModelCreationI.ScaleData scaleData, @NonNull Prescaler fllMultiplier) {
        List<@NonNull Constraint> elementConstraints = fllMultiplier.getElementConstraints();
        ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ModelCreationI.FLLextSingleData> data = new ArrayList<ModelCreationI.FLLextSingleData>();
        ArrayList<BigRational> scales = null;
        if (scaleData.scalelist != null) {
            scales = scaleData.scalelist;
        } else {
            BigRational low = scaleData.low;
            BigRational high = scaleData.high;
            BigRational step = scaleData.step;
            scales = new ArrayList<BigRational>();
            if (low != null && high != null && step != null) {
                BigRational i = low;
                while (i.compareTo(high) <= 0) {
                    BigRational scaleValue = i;
                    assert (scaleValue != null);
                    scales.add(scaleValue);
                    i = i.add(step);
                }
            }
        }
        for (BigRational scale : scales) {
            ModelCreationI.FLLextSingleData flLextSingleData = new ModelCreationI.FLLextSingleData(scale);
            for (Constraint constraint : elementConstraints) {
                Expression restriction = constraint.getRestriction();
                assert (restriction != null) : "FLLExt must contain restriction for each value";
                BigRational value = new BigRational(restriction.resolve().getLong());
                if (!constraint.getLevel().equals((Object)Constraint.Level.ERROR) || scale.compareTo(value) != 0) continue;
                Frequency frequency = constraint.getFrequencyWithAccuracy();
                Frequency maxFrequency = constraint.getMaxFrequencyWithAccuracy();
                Frequency minFrequency = constraint.getMinFrequencyWithAccuracy();
                if (constraint.isOnInput()) {
                    if (frequency != null) {
                        flLextSingleData.iHi = Converter.toHertz(frequency);
                        flLextSingleData.iLo = Converter.toHertz(frequency);
                        continue;
                    }
                    if (maxFrequency != null) {
                        flLextSingleData.iHi = Converter.toHertz(maxFrequency);
                    }
                    if (minFrequency == null) continue;
                    flLextSingleData.iLo = Converter.toHertz(minFrequency);
                    continue;
                }
                if (frequency != null) {
                    flLextSingleData.oHi = Converter.toHertz(frequency);
                    flLextSingleData.oLo = Converter.toHertz(frequency);
                    continue;
                }
                if (maxFrequency != null) {
                    flLextSingleData.oHi = Converter.toHertz(maxFrequency);
                }
                if (minFrequency == null) continue;
                flLextSingleData.oLo = Converter.toHertz(minFrequency);
            }
            data.add(flLextSingleData);
        }
        return data;
    }

    @Override
    protected void saveToModel(@NonNull IClocksConfig config, boolean lockedOnly) {
        SettingsConfig settingsConfig = config.getSettingsConfig();
        ISetting prescalerSetting = this.getFrequencyModifierSetting();
        assert (prescalerSetting != null);
        SettingValue prescalerSettingValue = settingsConfig.getSettingValue(prescalerSetting);
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            this.updateTiming(config, compNode);
            boolean frequencySaved = this.saveOutputFrequency(config, compNode, lockedOnly, false);
            if (this.type.equals((Object)ENodeType.FLL)) {
                compNode.setFraction(this.multiplier.getFraction(config));
            }
            LockState lockState = settingsConfig.getLockState(prescalerSetting);
            if (!frequencySaved || lockState != null) {
                BigRational currentValue = null;
                currentValue = prescalerSettingValue != SettingValue.N_A ? new BigRational(Integer.parseInt(prescalerSettingValue.getValue().toString())) : new BigRational(-1);
                if (this.type.equals((Object)ENodeType.FLLext)) {
                    compNode.setDefaultMulConst(currentValue);
                } else {
                    compNode.setDefaultMultiplier(currentValue);
                }
                BigRational valueToSet = null;
                if (!lockedOnly || lockState != null) {
                    BigRational bigRational = valueToSet = lockState == null ? currentValue : new BigRational(Integer.parseInt(lockState.getValue().getValue().toString()));
                }
                if (valueToSet != null) {
                    if (this.type.equals((Object)ENodeType.FLLext)) {
                        compNode.setMulConst(valueToSet);
                    } else {
                        compNode.setMultiplier(valueToSet);
                    }
                } else {
                    compNode.clean();
                }
            }
        }
    }

    private void updateTiming(@NonNull IClocksConfig config, @NonNull Node compNode) {
        ModelCreationI.ScaleData scaleData = this.multiplier.createScaleData(config);
        ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ModelCreationI.FLLextSingleData> fllExtData = Fll.createDataForFllExt(scaleData, this.multiplier);
        if (!fllExtData.isEmpty()) {
            compNode.resetAndCleanScale();
            if (this.type.equals((Object)ENodeType.FLLext)) {
                for (ModelCreationI.FLLextSingleData fd : fllExtData) {
                    compNode.addMulConstWConstr(fd.mulBy, fd.iLo, fd.iHi, fd.oLo, fd.oHi);
                }
            } else {
                compNode.setMulDivTimingScale(ClockModel.makeTimingScale((ModelCreationI.ScaleData)scaleData), null);
            }
        }
    }

    @Override
    protected void loadFromModel(@NonNull IClocksConfig config) {
        ISetting prescalerSetting = this.getFrequencyModifierSetting();
        assert (prescalerSetting != null);
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            BigRational scale = null;
            scale = this.type.equals((Object)ENodeType.FLLext) ? compNode.getMulConst() : compNode.getMultiplier();
            SettingValue value = null;
            if (scale != null) {
                value = prescalerSetting.parseValue(scale, config);
                if (value == null) {
                    value = SettingValue.N_A;
                }
                config.setSettingValue(prescalerSetting, value, false, false);
                BigRational finalScale = scale;
                List<@NonNull Constraint> elementConstraints = this.multiplier.getElementConstraints();
                elementConstraints.stream().filter(x -> x.getLevel().equals((Object)Constraint.Level.WARNING)).filter(x -> x.isApplicable(config, finalScale)).forEach(x -> this.resolveInputWarning((IConstraint)x, (INode)compNode, config));
            } else {
                LOGGER.warning("Not valid factor loaded for element: " + this.id);
            }
            config.setSettingValue(this.multiplier.getOutputFrequencySetting(), config.getSettingsConfig().getSettingValue(this.getOutputFrequencySetting()), false, false);
        }
    }

    private void resolveInputWarning(@NonNull IConstraint constraint, @NonNull INode compNode, @NonNull IClocksConfig config) {
        if (constraint.isOnInput()) {
            Frequency desiredFreq = constraint.getFrequency();
            BigRational input = compNode.getInputClock();
            if (input == null) {
                return;
            }
            if (desiredFreq != null) {
                BigRational desiredHertz = FrequencyCalculator.toHertz((Frequency)desiredFreq).getValue();
                if (desiredHertz.compareTo(input) != 0) {
                    config.addWarning(this.getID(), constraint.getDescription());
                }
            } else {
                BigRational maxHertz;
                BigRational minHertz;
                Frequency minFreq = constraint.getMinFrequency();
                if (minFreq != null && (minHertz = FrequencyCalculator.toHertz((Frequency)minFreq).getValue()).compareTo(input) > 0) {
                    config.addWarning(this.getID(), constraint.getDescription());
                    return;
                }
                Frequency maxFreq = constraint.getMinFrequency();
                if (maxFreq != null && (maxHertz = FrequencyCalculator.toHertz((Frequency)maxFreq).getValue()).compareTo(input) < 0) {
                    config.addWarning(this.getID(), constraint.getDescription());
                }
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void addFrequencyError(boolean isOnInput, @NonNull Map<@NonNull String, @NonNull String> errors, @NonNull Node device, @NonNull IClocksConfig config) {
        if (this.type.equals((Object)ENodeType.FLLext)) {
            for (MulConstr scaleData : device.getMultiplicativeScaleWConstraints()) {
                BigRational mulConst = device.getMulConst();
                if (mulConst == null || scaleData.mulBy.compareTo(mulConst) != 0) continue;
                BigRational min = isOnInput ? scaleData.inLo : scaleData.outLo;
                BigRational max = isOnInput ? scaleData.inHi : scaleData.outHi;
                @NonNull List ranges = isOnInput ? device.getInputFrequencyRanges() : device.getOutputFrequencyRanges();
                String message = ErrorHelper.extractFrequencyErrorMessage(isOnInput, min, max);
                if (message != null) {
                    List<@NonNull Constraint> activeConstraints = this.getAllApplicableConstraints(config);
                    int thisErrorIndex = Fll.getConstraintIndex(activeConstraints, min, max, config, ranges);
                    message = this.appendSeeConstraintsToMessage(message, thisErrorIndex, "Couldn't find corresponding constraint for FLL frequency error.");
                    ErrorHelper.addErrorIfNotPresent(this.getID(), message, errors);
                    ErrorHelper.addErrorIfNotPresent(this.multiplier.getID(), message, errors);
                } else {
                    LOGGER.warning("Error on frequency constraint of FLL, but can not find out which");
                }
                break;
            }
        } else {
            String message = Fll.composeFrequencyErrorMessage(isOnInput, device);
            if (message != null) {
                ErrorHelper.addErrorIfNotPresent(this.getID(), message, errors);
                ErrorHelper.addErrorIfNotPresent(this.multiplier.getID(), message, errors);
            } else {
                LOGGER.warning("Error on frequency constraint of FLL, but can not find out which");
            }
        }
    }

    @Override
    public void addDivisionError(EDividerError errorType, @NonNull Map<@NonNull String, @NonNull String> errors, @NonNull IMcu mcu, @NonNull Node device, @NonNull IClocksConfig config) {
        String message = ErrorHelper.extractDivisionErrorMessage(errorType, device, mcu, config, this.getFrequencyModifierSetting());
        ErrorHelper.addErrorIfNotPresent(this.getID(), message, errors);
        ErrorHelper.addErrorIfNotPresent(this.multiplier.getID(), message, errors);
    }

    @Override
    public void configureModel(@NonNull IClocksConfig config, boolean lockedOnly) {
        super.configureModel(config, lockedOnly);
        Node computationNodeLoc = this.getComputationNode(config);
        Node multiplierCompNodeLoc = this.getMultiplier().getComputationNode(config);
        if (computationNodeLoc != null && multiplierCompNodeLoc != null) {
            if (this.isEnabledForModel(config)) {
                multiplierCompNodeLoc.enable();
            } else {
                multiplierCompNodeLoc.disable();
            }
        }
    }

    @Override
    public void configureConfig(@NonNull IClocksConfig config) {
        super.configureConfig(config);
        if (this.isEnabledForModel(config)) {
            config.setEnabledByDefault(this.multiplier);
        } else {
            config.setDisabledByDefault(this.multiplier);
        }
    }

    private static class FllModel
    extends AClockModelCreationElement {
        @NonNull
        private ArrayList<ModelCreationI.FLLextSingleData> fllextData;
        @NonNull
        private ModelCreationI.ScaleData fllData;

        public FllModel(@NonNull String id, @NonNull ENodeType type, @NonNull Prescaler fllMultiplier) {
            super(id, type);
            ModelCreationI device = fllMultiplier.getDevice();
            assert (device != null);
            ModelCreationI.ScaleData scaleData = device.getScaleData();
            assert (scaleData != null);
            this.fllextData = type.equals((Object)ENodeType.FLLext) ? Fll.createDataForFllExt(scaleData, fllMultiplier) : new ArrayList();
            this.fllData = scaleData;
        }

        @Override
        public ModelCreationI.ScaleData getXLLMultiplier() {
            return this.fllData;
        }

        @Override
        public BigRational getDefaultMul() {
            return BigRational.ONE;
        }

        public ArrayList<ModelCreationI.FLLextSingleData> getFLLextData() {
            return this.fllextData;
        }

        @Override
        public BigRational getFLLextDefault() {
            return this.getDefaultMul();
        }
    }
}

