/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.ISignalReference;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.provider.configuration.dependencies.DependencyCreator;
import com.nxp.swtools.provider.configuration.dependencies.DependencyFactory;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import com.nxp.swtools.provider.configuration.storage.StorageDependencyFeature;
import com.nxp.swtools.provider.configuration.storage.StorageDependencyFeatureData;
import java.util.ArrayList;

@NonNullByDefault
public class Pin
implements IElement {
    public static final String UNIFIED_ID = "peripheralUnifiedSignal";
    public static final String COMMON_ID = "pinSignal";
    private static final String DEPENDENCY_DESC_PIN_ROUTED = "''{0}'' (Pins tool id: {1}, Clocks tool id: {2}) needs to be routed";
    private static final String DEPENDENCY_DESC_PIN_DIRECTION = "''{0}'' (Pins tool id: {1}, Clocks tool id: {2}) needs to have ''{3}'' direction";
    private static final int DEPENDENCY_LEVEL_PIN_ROUTED = 1;
    private String mId;
    private String mName;
    private Direction mDir;
    private ISignalReference mPeriphSignalRef;
    @Nullable
    private EnableSetting mSettings;
    @Nullable
    private String mDescription;
    private String mPeripheral;

    public Pin(String id, String name, Direction dir, @Nullable String description, String peripheral, ISignalReference signalReference) {
        this.mId = id;
        this.mName = name;
        this.mDir = dir;
        this.mPeriphSignalRef = signalReference;
        this.mSettings = null;
        this.mDescription = description;
        this.mPeripheral = peripheral;
    }

    @Override
    public @NonNull String getName() {
        return this.mName;
    }

    @Override
    public @NonNull String getID() {
        return this.mId;
    }

    public void setDirection(Direction dir) {
        this.mDir = dir;
    }

    public Direction getDirection() {
        return this.mDir;
    }

    public ISignalReference getSignalRef() {
        return this.mPeriphSignalRef;
    }

    public String toString() {
        String str = String.valueOf(this.getClass().getSimpleName()) + ": " + this.mId + "(" + this.mName + ", peripheral: " + this.mPeripheral + "), direction: " + (Object)((Object)this.mDir) + ", signalRef: " + this.mPeriphSignalRef.toString();
        if (this.mDescription != null) {
            str = String.valueOf(str) + ", description: " + this.mDescription;
        }
        return str;
    }

    public void setEnableSetting(EnableSetting settings) {
        this.mSettings = settings;
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig config) {
        if (this.mSettings != null) {
            return this.mSettings.isEnabled(config);
        }
        return false;
    }

    @Override
    public @Nullable EnableSetting getEnableSetting() {
        return this.mSettings;
    }

    @Override
    public @Nullable String getDescription() {
        return this.mDescription;
    }

    public StorageDependency createDirectionDependency(IClocksConfig config) {
        ISignalReference signal = this.mPeriphSignalRef;
        StorageDependencyFeatureData data = new StorageDependencyFeatureData();
        String direction = this.getDirection().getValue();
        data.setValue(direction);
        StorageDependencyFeature feature = new StorageDependencyFeature();
        feature.setName("direction");
        feature.setData(CollectionsUtils.asList((Object)data));
        StorageDependency dep = DependencyFactory.createDependency((String)signal.getDependencyType(), (String)signal.getSignalId(this.mPeripheral), (String)UtilsText.format((String)DEPENDENCY_DESC_PIN_DIRECTION, (Object[])new Object[]{this.getName(), signal.getSignalId(this.mPeripheral), this.getID(), direction}), (int)1, (String)("Clocks:" + config.getName()), (DependencyCreator)DependencyCreator.TOOL, (boolean)false);
        dep.setFeatures(CollectionsUtils.asList((Object)feature));
        return dep;
    }

    public StorageDependency createRoutedDependency(IClocksConfig config) {
        ArrayList<@NonNull StorageDependencyFeature> features = new ArrayList<StorageDependencyFeature>();
        StorageDependencyFeatureData routeData = new StorageDependencyFeatureData();
        routeData.setValue(Text.TRUE);
        StorageDependencyFeature routeFeature = new StorageDependencyFeature();
        routeFeature.setName("routed");
        routeFeature.setData(CollectionsUtils.asList((Object)routeData));
        features.add(routeFeature);
        if (SwToolsProduct.isUctProduct()) {
            StorageDependencyFeatureData directionData = new StorageDependencyFeatureData();
            String direction = this.getDirection().getValue();
            directionData.setValue(direction);
            StorageDependencyFeature directionFeature = new StorageDependencyFeature();
            directionFeature.setName("direction");
            directionFeature.setData(CollectionsUtils.asList((Object)directionData));
            features.add(directionFeature);
        }
        StorageDependency dep = DependencyFactory.createDependency((String)this.mPeriphSignalRef.getDependencyType(), (String)this.mPeriphSignalRef.getSignalId(this.mPeripheral), (String)UtilsText.format((String)DEPENDENCY_DESC_PIN_ROUTED, (Object[])new Object[]{this.getName(), this.mPeriphSignalRef.getSignalId(this.mPeripheral), this.getID()}), (int)1, (String)("Clocks:" + config.getName()), (DependencyCreator)DependencyCreator.TOOL, (boolean)false);
        dep.setFeatures(features);
        return dep;
    }

    public static enum Direction {
        IN("INPUT"),
        OUT("OUTPUT"),
        UNDEFINED("NOT_SPECIFIED");

        private final String value;

        private Direction(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

