/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.parser;

import com.nxp.swtools.clocks.data.BitFieldsCache;
import com.nxp.swtools.clocks.data.ClockSlice;
import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.DiagramData;
import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.IMcuDescriptor;
import com.nxp.swtools.clocks.data.Mcu;
import com.nxp.swtools.clocks.data.elements.ClockElementData;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.EnableDisableCondition;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.Pin;
import com.nxp.swtools.clocks.data.elements.PowerMode;
import com.nxp.swtools.clocks.data.parser.ClockSignalInterface;
import com.nxp.swtools.clocks.data.parser.ComponentParser;
import com.nxp.swtools.clocks.data.parser.ParserException;
import com.nxp.swtools.clocks.data.parser.XsdValidationHandler;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.expression.ComponentContext;
import com.nxp.swtools.clocks.expression.DefaultContext;
import com.nxp.swtools.clocks.resources.DataDirectory;
import com.nxp.swtools.clocks.resources.ProcessorFilterForClocksTool;
import com.nxp.swtools.clocks.script.McuInfo;
import com.nxp.swtools.clocks.ui.diagram.DiagramLoader;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.xml.UtilsXmlDom;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.clock.modules.ClockConsumers;
import com.nxp.swtools.expert.clock.modules.PeripheralComponentFile;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.registers.RegistersFactory;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.selector.McuSelectionFactory;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.features.SdkFeatures;
import com.nxp.swtools.provider.features.SdkFeaturesProvider;
import com.nxp.swtools.resourcetables.model.data.EmptyMcuResourceTables;
import com.nxp.swtools.resourcetables.model.data.McuResourceTables;
import com.nxp.swtools.resourcetables.model.resources.AProcessorFilterForResourceTable;
import com.nxp.swtools.utils.scripting.JavaScriptHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.CompiledScript;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.simpleframework.xml.core.Persister;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class McuParser {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(McuParser.class);

    public static @NonNull IMcu parse(@NonNull InputStream file, @NonNull IMcuDescriptor descriptor, @NonNull String fileName) throws ParserException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        try {
            DocumentBuilder dBuilder = factory.newDocumentBuilder();
            XsdValidationHandler handlerXSD = new XsdValidationHandler(LOGGER, fileName);
            dBuilder.setErrorHandler(handlerXSD);
            Document doc = dBuilder.parse(file);
            doc.normalize();
            UtilsXmlDom.setFileNameToUserData((Node)doc, (String)fileName);
            Element root = doc.getDocumentElement();
            assert (root != null) : "no root element found";
            File diagramFile = McuParser.getAbsolutePathFromTag(fileName, "diagram", root);
            File pwrModeFile = McuParser.getAbsolutePathFromTag(fileName, "power_modes", root);
            NodeList componentElements = root.getElementsByTagName("component");
            if (componentElements.getLength() == 1) {
                Element mcuComponent = (Element)componentElements.item(0);
                assert (mcuComponent != null);
                String customPmsDesc = McuParser.parseCustomPowerModeDescription(root);
                return McuParser.parseMcuComponent(McuParser.loadScript(descriptor), McuParser.loadRegistersDB(descriptor), descriptor, mcuComponent, McuParser.parsePowerModes(pwrModeFile), customPmsDesc, diagramFile);
            }
            throw new ParserException(String.format("Exactly one '%s' tag expected, but %s parsed.", "component", Integer.toString(componentElements.getLength())));
        }
        catch (ParserException | IOException | ParserConfigurationException | SAXException e) {
            throw new ParserException(e);
        }
        catch (Exception e) {
            throw new ParserException("Error while parsing! Caused by: " + e.getMessage(), e);
        }
    }

    private static @Nullable File getAbsolutePathFromTag(@NonNull String fileName, @NonNull String tag, @NonNull Element root) {
        File file = null;
        NodeList elements = root.getElementsByTagName(tag);
        if (elements == null) {
            LOGGER.warning("No '" + tag + "' tag found.");
        } else if (elements.getLength() != 1) {
            LOGGER.warning(String.format("Exactly one '%s' tag expected, but %s parsed.", tag, Integer.toString(elements.getLength())));
        } else {
            String relativePath = ((Element)Objects.requireNonNull(elements.item(0))).getAttribute("file");
            file = new File(fileName).getParentFile();
            if (file == null) {
                return null;
            }
            file = new File(String.valueOf(file.getAbsolutePath()) + File.separator + relativePath);
        }
        return file;
    }

    private static @NonNull CompiledScript loadScript(@NonNull IMcuDescriptor descriptor) throws IOException {
        File scriptFile = new File(String.valueOf(DataDirectory.getClocksJavaScriptDir(descriptor)) + File.separator + "codegenerator.js");
        CompiledScript script = JavaScriptHelper.compile((File)scriptFile);
        if (script == null) {
            throw new IOException("JavaScript used for code generation can not be compiled");
        }
        return script;
    }

    protected static @NonNull BitFieldsCache loadRegistersDB(@NonNull IMcuDescriptor mcuDescriptor) {
        IMcuIdentification mcuSelection = McuSelectionFactory.createMcuSelectionIdentification((String)mcuDescriptor.getID(), (String)mcuDescriptor.getPartNumber(), (String)mcuDescriptor.getSDKVersion());
        assert (mcuSelection != null);
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        assert (derivatives != null);
        IRegistersDatabaseAPI loadedRegisters = RegistersFactory.loadRegistersDB((ISupportedDerivativesForSwTools)derivatives, (IMcuIdentification)mcuSelection);
        assert (loadedRegisters != null);
        return new BitFieldsCache(loadedRegisters);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull IMcu parseMcuComponent(@NonNull CompiledScript script, @NonNull BitFieldsCache mcuRegisters, @NonNull IMcuDescriptor descriptor, @NonNull Element elem, @NonNull List<@NonNull PowerMode> powerModes, @Nullable String customPowerModesDescription, @Nullable File diagramFile) throws ParserException {
        ArrayList<DiagramSymbol> diagramSymbols;
        LinkedHashMap<@NonNull String, @NonNull IClockComponent> components = new LinkedHashMap<String, IClockComponent>();
        LinkedHashMap<@NonNull String, IClockElement> mcuElements = new LinkedHashMap<String, IClockElement>();
        HashMap<@NonNull String, String> signalMapping = new HashMap<String, String>();
        ArrayList<@NonNull Constraint> constraints = new ArrayList<Constraint>();
        ArrayList<@NonNull IConfigElement> configElements = new ArrayList<IConfigElement>();
        HashMap<@NonNull String, @NonNull String> notAvailableElements = new HashMap<String, String>();
        HashMap<@NonNull String, ClockSignalInterface> signalInterfaces = new HashMap();
        NodeList rootChildNodes = elem.getChildNodes();
        int i = 0;
        while (i < rootChildNodes.getLength()) {
            Node node = Objects.requireNonNull(rootChildNodes.item(i));
            if (node.getNodeType() == 1 && "interface".equals(node.getNodeName())) {
                Element interfaceElement = (Element)node;
                signalInterfaces = ComponentParser.parseSignalInterfaces("", interfaceElement, mcuRegisters);
                NodeList interfaceChildNodes = interfaceElement.getChildNodes();
                int j = 0;
                while (j < interfaceChildNodes.getLength()) {
                    Node childNode = Objects.requireNonNull(interfaceChildNodes.item(j));
                    if (childNode.getNodeType() == 1 && "output_clock_signal".equals(childNode.getNodeName())) {
                        Element clockOutputElement = (Element)childNode;
                        boolean available = ComponentParser.available(mcuRegisters, clockOutputElement);
                        if (available) {
                            ClockOutput output = McuParser.parseClockOutput(mcuRegisters, clockOutputElement, constraints, signalInterfaces);
                            mcuElements.put(output.getID(), output);
                        } else {
                            String id = UtilsText.safeString((String)clockOutputElement.getAttribute("id"));
                            String input = clockOutputElement.getElementsByTagName("input").getLength() == 0 ? "" : ComponentParser.parseInputSignalElement(ComponentContext.MCU_CONTEXT, id, clockOutputElement, new HashMap<String, String>());
                            notAvailableElements.put(id, input);
                        }
                    }
                    ++j;
                }
            } else if (node.getNodeType() == 1 && "implementation".equals(node.getNodeName())) {
                Element implementationElement = (Element)node;
                ComponentContext context = new ComponentContext("", "", mcuRegisters);
                mcuElements.putAll(ComponentParser.parseImplementation("", mcuRegisters, implementationElement, signalMapping, new HashMap<String, String>(), true, notAvailableElements, constraints, configElements, context, new HashMap<String, Pin>(), signalInterfaces, new ArrayList<ClockSlice>()));
                NodeList implementationChildNodes = implementationElement.getChildNodes();
                int j = 0;
                while (j < implementationChildNodes.getLength()) {
                    Node childNode = Objects.requireNonNull(implementationChildNodes.item(j));
                    if (childNode.getNodeType() == 1 && "component_instance".equals(childNode.getNodeName())) {
                        Element componentElement = (Element)childNode;
                        components.putAll(McuParser.parseComponentInstances(descriptor, mcuRegisters, componentElement, constraints, notAvailableElements));
                    }
                    ++j;
                }
            }
            ++i;
        }
        for (IClockElement element : mcuElements.values()) {
            String input;
            if (!"".equals(element.getInputSignal()) || (input = (String)signalMapping.get(element.getID())) == null) continue;
            element.setInputSignal(input);
        }
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(descriptor.getID(), descriptor.getSDKVersion());
        assert (info != null);
        PeripheralComponentFile peripheralComponentFile = ClockConsumers.getInstance().getPeripheralComponentFile(info, descriptor.getPartNumber());
        if (diagramFile != null) {
            DiagramLoader loader = new DiagramLoader(diagramFile);
            diagramSymbols = loader.load();
            DiagramData.removeUnwantedJunctions(0.01, diagramSymbols);
        } else {
            diagramSymbols = new ArrayList();
            LOGGER.warning("Diagram file was 'null', so no symbols could be loaded");
        }
        ProcessorFilterForClocksTool toolFilter = ProcessorFilterForClocksTool.getInstance();
        ICommonConfig commonConfig = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig();
        IMcuIdentification mcuSelection = commonConfig.getMcuIdentification();
        @NonNull Collection cores = commonConfig.getCores();
        McuInfo mcuInfo = new McuInfo(descriptor, commonConfig.getBoard(), commonConfig.getKit());
        Object mcuResourceTables = !toolFilter.isPeripheralsResourceTablesDirDefined((IMcuIdentification)mcuInfo) ? new EmptyMcuResourceTables() : McuResourceTables.getInstance((IMcuIdentification)mcuSelection, (AProcessorFilterForResourceTable)toolFilter);
        SdkFeatures sdkFeatures = SdkFeaturesProvider.getSdkFeatures((ISupportedDerivativesForSwTools)derivatives, (IMcuIdentification)mcuSelection);
        return new Mcu(script, mcuRegisters, descriptor, components, mcuElements, configElements, signalMapping, powerModes, customPowerModesDescription, notAvailableElements, diagramSymbols, peripheralComponentFile, (McuResourceTables)mcuResourceTables, (IMcuIdentification)mcuInfo, info, cores, sdkFeatures);
    }

    private static @NonNull Map<@NonNull String, @NonNull IClockComponent> parseComponentInstances(@NonNull IMcuDescriptor descriptor, @NonNull BitFieldsCache mcuRegisters, @NonNull Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> notAvailableElements) throws ParserException {
        LinkedHashMap<@NonNull String, @NonNull IClockComponent> components = new LinkedHashMap<String, IClockComponent>();
        HashMap<@NonNull String, @NonNull String> instanceMapping = new HashMap<String, String>();
        String id = UtilsText.safeString((String)elem.getAttribute("id"));
        String peripheral = UtilsText.safeString((String)elem.getAttribute("peripheral"));
        String file = UtilsText.safeString((String)elem.getAttribute("file"));
        String name = UtilsText.safeString((String)elem.getAttribute("name"));
        String comp = UtilsText.safeString((String)elem.getAttribute("component"));
        NodeList signalMaps = elem.getChildNodes();
        int i = 0;
        while (i < signalMaps.getLength()) {
            Node node = Objects.requireNonNull(signalMaps.item(i));
            if (node.getNodeType() == 1 && "signal_map".equals(node.getNodeName())) {
                Element signalMap = (Element)node;
                int j = 0;
                while (j < signalMap.getChildNodes().getLength()) {
                    Node childNode = Objects.requireNonNull(signalMap.getChildNodes().item(j));
                    if (childNode.getNodeType() == 1 && "input".equals(childNode.getNodeName())) {
                        Element input = (Element)childNode;
                        String inputVal = input.getAttribute("signal");
                        String inputKey = input.getAttribute("component_signal");
                        if (inputVal != null && inputKey != null) {
                            instanceMapping.put(String.valueOf(id) + "." + inputKey, inputVal);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        boolean available = ComponentParser.available(mcuRegisters, elem);
        if (available) {
            IClockComponent component = McuParser.parseComponent(descriptor, mcuRegisters, id, name, peripheral, comp, file, instanceMapping, constraints, notAvailableElements);
            if (component != null) {
                components.put(component.getID(), component);
            }
        } else {
            notAvailableElements.put(id, id);
        }
        return components;
    }

    private static @NonNull ClockOutput parseClockOutput(@NonNull BitFieldsCache mcuRegisters, @NonNull Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, ClockSignalInterface> signalInterfaces) throws ParserException {
        ArrayList<EnableDisableCondition> enableSetting;
        ClockElementData elementData = ComponentParser.parseElementData(mcuRegisters, elem, constraints, new HashMap<String, String>(), ComponentContext.MCU_CONTEXT, true);
        String group = UtilsText.safeString((String)elem.getAttribute("group"));
        ArrayList<@NonNull IConfigElement> configElements = new ArrayList<IConfigElement>();
        ArrayList<@NonNull List<@NonNull EnableDisableCondition>> enableConditions = new ArrayList<List<EnableDisableCondition>>();
        String inputSignal = McuParser.parseInputSignalOfOutput(elem, elementData.getId(), constraints, mcuRegisters, configElements, enableConditions);
        elementData.setConfigElements(configElements);
        ClockSignalInterface clockSignalInterface = signalInterfaces.get(elementData.getId());
        if (clockSignalInterface != null) {
            elementData.setName(clockSignalInterface.getName());
            String description = clockSignalInterface.getDescription();
            if (description != null) {
                elementData.setDescription(description);
            }
            group = clockSignalInterface.getGroup();
        } else {
            LOGGER.warning(String.valueOf(elementData.getId()) + " component output has no entry matching in component interface of top-level component");
        }
        ClockOutput.CMU cmu = ComponentParser.parseCMU(elementData.getConfigElements(), elem);
        ClockOutput clockOutput = new ClockOutput(elementData, inputSignal, cmu, group, new ArrayList<Pin>());
        if (enableConditions.size() == 1) {
            enableSetting = (ArrayList<EnableDisableCondition>)enableConditions.get(0);
        } else {
            enableSetting = new ArrayList<EnableDisableCondition>(0);
            LOGGER.warning("Exactly one enable/disable setting expected for element: " + elementData.getId());
        }
        clockOutput.addNestedSetting(new EnableSetting(elementData.getId(), (IElement)clockOutput, enableSetting));
        return clockOutput;
    }

    private static @NonNull String parseInputSignalOfOutput(@NonNull Element elem, @NonNull String id, @NonNull List<@NonNull Constraint> constraints, @NonNull BitFieldsCache mcuRegisters, @NonNull List<@NonNull IConfigElement> configElements, @NonNull List<@NonNull List<@NonNull EnableDisableCondition>> enableConditions) {
        String inputSignal = "";
        Element mapOut = ComponentParser.parseMapOut(elem, id);
        if (mapOut != null) {
            NodeList inputElements = mapOut.getElementsByTagName("input");
            Element inputElem = null;
            if (inputElements.getLength() == 1) {
                inputElem = (Element)inputElements.item(0);
            }
            inputSignal = inputElem != null ? UtilsText.safeString((String)inputElem.getAttribute("signal")) : "";
            try {
                configElements.addAll(ComponentParser.parseLocalConfigElements(mcuRegisters, mapOut, constraints, DefaultContext.getInstance(), new HashMap<String, String>()));
            }
            catch (ParserException e) {
                LOGGER.log(Level.WARNING, "Error in local config element parsing", e);
            }
            NodeList childNodes = mapOut.getChildNodes();
            assert (childNodes != null);
            enableConditions.add(ComponentParser.parseEnableAndConstraints(id, childNodes, DefaultContext.getInstance(), constraints, new HashMap<String, String>(), false));
        } else {
            LOGGER.severe("No mapping found for output: " + id);
        }
        return inputSignal;
    }

    private static @Nullable IClockComponent parseComponent(@NonNull IMcuDescriptor descriptor, @NonNull BitFieldsCache mcuRegisters, @NonNull String id, @NonNull String name, @NonNull String peripheral, @NonNull String comp, @NonNull String file, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> notAvailableElements) throws ParserException {
        String filePath = String.valueOf(DataDirectory.getClocksDataDir(descriptor)) + File.separator + file;
        try {
            Throwable throwable = null;
            Object var12_14 = null;
            try (BufferedInputStream fileStream = new BufferedInputStream(UtilsDecryption.getFileInputStream((File)new File(filePath)));){
                return ComponentParser.parse(mcuRegisters, fileStream, id, name, peripheral, comp, filePath, instanceMapping, constraints, notAvailableElements);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | SecurityException e) {
            LOGGER.log(Level.SEVERE, "Error while processing '" + filePath + "'.", e);
            assert (false);
            return null;
        }
    }

    private static @NonNull List<@NonNull PowerMode> parsePowerModes(@Nullable File pwrModeFile) {
        List<@NonNull PowerMode> result = new ArrayList<PowerMode>();
        if (pwrModeFile != null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream pwrModeInStr = UtilsDecryption.getFileInputStream((File)pwrModeFile);){
                    Persister serializer = new Persister();
                    PowerMode.PowerModeFile file = (PowerMode.PowerModeFile)serializer.read(PowerMode.PowerModeFile.class, pwrModeInStr);
                    if (SWToolsProperties.isPowerDownModesEnabled()) {
                        result = file.getModes();
                    } else {
                        file.getModes().stream().filter(x -> x.getType().equals((Object)PowerMode.Type.RUN)).forEach(result::add);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not load file with power mode information. One default run mode will be used instead.", e);
                result.add(PowerMode.createDefaultRun());
            }
        } else {
            LOGGER.log(Level.SEVERE, "The file with power mode information doesn't exists. One default run mode will be used instead.");
            result.add(PowerMode.createDefaultRun());
        }
        return result;
    }

    private static @Nullable String parseCustomPowerModeDescription(@NonNull Element root) {
        Attr description;
        NodeList powerModeElements = root.getElementsByTagName("power_modes");
        if (powerModeElements != null && powerModeElements.getLength() == 1 && (description = ((Element)Objects.requireNonNull(powerModeElements.item(0))).getAttributeNode("description")) != null) {
            return description.getNodeValue();
        }
        return null;
    }
}

