/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.Objects;

public class SettingValue {
    @NonNull
    public static final SettingValue N_A = new SettingValue("N/A");
    @NonNull
    public static final SettingValue FREQ_N_A = new SettingValue(Frequency.parseNonNull((String)"0 Hz"), "Inactive");
    @NonNull
    public static final SettingValue UNDEFINED = new SettingValue("UNDEFINED");
    @NonNull
    private final Object value;
    @NonNull
    private final String uiValue;

    public SettingValue(@NonNull Object value) {
        this(value, UtilsText.safeString((String)value.toString()));
    }

    public SettingValue(@NonNull Object value, @NonNull String uiValue) {
        this.value = value;
        this.uiValue = uiValue;
    }

    public @NonNull Object getValue() {
        return this.value;
    }

    public @NonNull String getUiValue() {
        return this.uiValue;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hash(this.value, this.uiValue);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SettingValue other = (SettingValue)obj;
        if (this.isN_A() != other.isN_A()) {
            return false;
        }
        if (this.isUndefined() != other.isUndefined()) {
            return false;
        }
        if (!this.value.equals(other.value)) {
            return false;
        }
        return this.uiValue.equals(other.uiValue);
    }

    public String toString() {
        return String.valueOf(this.uiValue) + "[" + this.value + "]";
    }

    public boolean isN_A() {
        return this == N_A || this == FREQ_N_A || this == UNDEFINED;
    }

    public boolean isUndefined() {
        return this == UNDEFINED;
    }
}

