/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.dependencies;

import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.ui.table.SettingValueChangeListener;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.dependencies.IFeatureData;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IProblemResolveHandler;
import com.nxp.swtools.validation.engine.IValidationProblem;
import java.util.List;
import java.util.logging.Logger;

@NonNullByDefault
public class FrequencyRangeHandler
implements IProblemResolveHandler {
    private static final Logger LOGGER = LogManager.getLogger(FrequencyRangeHandler.class);
    private Frequency from;
    private Frequency to;
    private IValidationProblem problem;

    public FrequencyRangeHandler(IValidationProblem problem) {
        List values = problem.getFeature().getData();
        assert (values.size() == 2);
        this.from = Frequency.parseNonNull((String)(String.valueOf(((IFeatureData)values.get(0)).getValue()) + ((IFeatureData)values.get(0)).getUnit()));
        this.to = Frequency.parseNonNull((String)(String.valueOf(((IFeatureData)values.get(1)).getValue()) + ((IFeatureData)values.get(1)).getUnit()));
        this.problem = problem;
    }

    public boolean resolveProblem(IBaseProblem baseProblem) {
        IClockElement elem = UiController.getInstance().getProfile().getMcu().getClockElement(this.problem.getDependency().getResourceId());
        if (elem != null && elem instanceof ClockOutput) {
            String configurationName = this.problem.getConfiguration().getConfigurationName();
            IClocksConfig config = UiController.getInstance().getProfile().getConfigByName(configurationName);
            assert (config != null) : String.valueOf(configurationName) + ": no such fuctional group found";
            ISetting setting = elem.getOutputFrequencySetting();
            SettingEditorHelper.findValueInRange(setting, config, new SettingValueChangeListener(this.problem), this.from, this.to);
            return true;
        }
        LOGGER.severe("Find near valid frequency has been called on Validation problem (" + elem + "), which is not refering to Clock output. Such functionality is not implemented.");
        return false;
    }

    public String getResolveProblemLabel(IBaseProblem baseProblem) {
        return "Find near valid value";
    }
}

