/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.expression;

import com.nxp.swtools.clocks.data.BitFieldsCache;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.expression.DefaultContext;
import com.nxp.swtools.clocks.expression.IRegistersContext;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.expression.FunctionInvocation;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.Value;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldValueAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryFactory;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import com.nxp.swtools.utils.registers.BitFieldProvider;
import com.nxp.swtools.utils.registers.EmptyRegistersDB;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;

public abstract class ARegistersContext
implements IRegistersContext {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ARegistersContext.class);

    public long getBitFieldValue(@NonNull String registerName, @NonNull String bitFieldName) {
        BitFieldsCache registersDb = this.getRegisters();
        BitFieldElement bitField = ClocksBitFieldProvider.getBitField(registerName, bitFieldName, registersDb);
        IClocksConfig activeConfig = UiController.getInstance().getProfile().getActiveConfig();
        if (bitField == null || activeConfig == null) {
            throw new IllegalStateException("Can not resolve bit field value");
        }
        IRegBitFieldValueAPI bitfieldValue = ClocksBitFieldProvider.getBitFieldValueOrResetValue(bitField, activeConfig);
        return bitfieldValue.getValue();
    }

    public int getBitFiledWidth(@NonNull String registerName, @NonNull String bitFieldName) {
        BitFieldElement bitField = ClocksBitFieldProvider.getBitField(registerName, bitFieldName, this.getRegisters());
        if (bitField == null) {
            throw new IllegalStateException(MessageFormat.format("Bit Field : {0}[{1}] not found.", registerName, bitFieldName));
        }
        return bitField.getBitField().getWidth();
    }

    public @NonNull String getBitFieldId(@NonNull String registerName, @NonNull String bitFieldName) {
        return BitFieldProvider.createBitFieldId((String)registerName, (String)bitFieldName);
    }

    private static @NonNull IValue parseQuerryResult(Collection<IDependencyQueryResult> results) {
        boolean defaultResult = false;
        for (IDependencyQueryResult item : results) {
            Object value = item.getValue();
            if (value instanceof String) {
                if (results.size() != 1) {
                    LOGGER.warning("Multiple results of query, only one was expected. Returning the first one!");
                }
                return Value.of((Object)value);
            }
            if (value instanceof Boolean) {
                defaultResult |= ((Boolean)value).booleanValue();
                continue;
            }
            LOGGER.severe("Unsupported query result type.");
        }
        return Value.of((boolean)defaultResult);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull IValue resolveFunction(@NonNull FunctionInvocation function, @NonNull IContext argContext) {
        EmptyRegistersDB registersDb = this instanceof DefaultContext ? EmptyRegistersDB.INSTANCE : this.getRegisters().getRegistersDb();
        switch (function.getName()) {
            case "hasPeripheral": {
                String peripheral = function.getArgument(0).resolve(argContext).getString();
                return Value.of((BitFieldProvider.findPeripheral((String)peripheral, (IRegistersDatabaseAPI)registersDb) != null ? 1 : 0) != 0);
            }
            case "hasRegister": {
                String peripheral = function.getArgument(0).resolve(argContext).getString();
                String register = function.getArgument(1).resolve(argContext).getString();
                return Value.of((BitFieldProvider.findRegister((String)peripheral, (String)register, (IRegistersDatabaseAPI)registersDb) != null ? 1 : 0) != 0);
            }
            case "hasBitField": {
                String peripheral = function.getArgument(0).resolve(argContext).getString();
                String register = function.getArgument(1).resolve(argContext).getString();
                String bitField = function.getArgument(2).resolve(argContext).getString();
                return Value.of((BitFieldProvider.findBitField((String)peripheral, (String)register, (String)bitField, (IRegistersDatabaseAPI)registersDb) != null ? 1 : 0) != 0);
            }
            case "hasBitFieldValue": {
                String peripheral = function.getArgument(0).resolve(argContext).getString();
                String register = function.getArgument(1).resolve(argContext).getString();
                String bitField = function.getArgument(2).resolve(argContext).getString();
                String value = function.getArgument(3).resolve(argContext).getString();
                return Value.of((BitFieldProvider.findBitFieldValue((String)peripheral, (String)register, (String)bitField, (String)value, (IRegistersDatabaseAPI)registersDb) != null ? 1 : 0) != 0);
            }
            case "queryFeature": {
                String resType = function.getArgument(0).resolve(argContext).getString();
                String resId = function.getArgument(1).resolve(argContext).getString();
                String featureName = function.getArgument(2).resolve(argContext).getString();
                if (Platform.isRunning()) {
                    Collection pinsEnabledResults;
                    boolean pinsEnabled;
                    ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
                    IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
                    if (resType.equals("PinSignal") && !(pinsEnabled = CollectionsUtils.getInstancesOf((pinsEnabledResults = queryEngine.query(configuration, "Tool", "Pins", "enabled")).stream().map(IDependencyQueryResult::getValue), Boolean.class).anyMatch(Boolean::booleanValue))) {
                        LOGGER.warning("Pins tool disabled. Query result might not be accurate for " + function.toString());
                        return Value.of((boolean)true);
                    }
                    @NonNull Collection results = queryEngine.query(configuration, resType, resId, featureName);
                    return ARegistersContext.parseQuerryResult(results);
                }
                LOGGER.warning("Cannot resolve query due to inactive workbench: " + function.getName() + "(" + resType + ", " + resId + ", " + featureName + ")");
                return Value.of((boolean)false);
            }
        }
        throw new IllegalArgumentException("Unknown function: " + function);
    }
}

