/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.main;

import com.nxp.swtools.clocks.data.model.EmptyConfig;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.AbstractSourceProvider;

public class ClocksServiceProvider
extends AbstractSourceProvider {
    @NonNull
    public static final String CONFIGURATION_REMOVABLE = "com.nxp.swtools.clocks.isConfigurationRemovable";
    @NonNull
    public static final String CONFIGURATION_SUPPORTED_MCU = "com.nxp.swtools.clocks.isMcuSupported";
    @NonNull
    public static final String CONFIGURATION_IS_UNLOCKABLE = "com.nxp.swtools.clocks.isUnlockableAll";
    @NonNull
    public static final String PATH_IS_UNLOCKABLE = "com.nxp.swtools.clocks.isUnlockablePath";
    @NonNull
    public static final String BOARD_OR_KIT = "com.nxp.swtools.clocks.isBoardOrKit";

    public Map<String, Object> getCurrentState() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        List<@NonNull IClocksConfig> configs = UiController.getInstance().getProfile().getConfigs();
        map.put(CONFIGURATION_REMOVABLE, configs.size() > 1);
        map.put(CONFIGURATION_SUPPORTED_MCU, ClocksServiceProvider.isMcuSupported(configs));
        map.put(CONFIGURATION_IS_UNLOCKABLE, ClocksServiceProvider.isSomeSettingLocked());
        map.put(PATH_IS_UNLOCKABLE, ClocksServiceProvider.isSomeSettingLockedOnPath());
        map.put(BOARD_OR_KIT, ClocksServiceProvider.isBoardOrKitConfig());
        return map;
    }

    private static boolean isBoardOrKitConfig() {
        IClocksProfile profile = UiController.getInstance().getProfile();
        return !UtilsText.isEmpty((String)profile.getKit()) || !UtilsText.isEmpty((String)profile.getBoard());
    }

    private static boolean isSomeSettingLocked() {
        IClocksProfile profile = UiController.getInstance().getProfile();
        IClocksConfig activeConfig = profile.getActiveConfig();
        if (activeConfig != null) {
            return activeConfig.isSomeSettingLocked();
        }
        return false;
    }

    private static boolean isSomeSettingLockedOnPath() {
        if (Display.getCurrent() != null) {
            return GuiController.getInstance().isSomeSettingLockedOnPath();
        }
        return false;
    }

    private static boolean isMcuSupported(List<@NonNull IClocksConfig> configs) {
        boolean mcuSupported = true;
        for (IClocksConfig config : configs) {
            if (!(config instanceof EmptyConfig)) continue;
            mcuSupported = false;
        }
        return mcuSupported;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{CONFIGURATION_REMOVABLE, CONFIGURATION_SUPPORTED_MCU, CONFIGURATION_IS_UNLOCKABLE, PATH_IS_UNLOCKABLE, BOARD_OR_KIT};
    }

    public void dispose() {
    }

    public void updateConfigurationState() {
        this.fireSourceChanged(0, this.getCurrentState());
    }
}

