/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.perspective;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.NonNullByDefault;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

@NonNullByDefault
public class ClocksExtensionsReader {
    private static Map<String, String> leftMap = new HashMap<String, String>();
    private static Map<String, String> rightMap = new HashMap<String, String>();
    private static List<String> showViewIds = new ArrayList<String>();
    private static final String EXT_POINT_PERSPECTIVE_EXTENSIONS = "com.nxp.swtools.clocks.perspectiveExtensions";
    private static final String TAG_VIEW = "view";
    private static final String TAG_ID = "id";
    private static final String TAG_RELATIONSHIP = "relationship";
    private static final String TAG_RELATIVE = "relative";
    private static final String TAG_FOCUS = "focus";
    private static final String TAG_LEFT = "left";
    private static final String TAG_RIGHT = "right";
    private static final String TRUE = "true";

    public static List<String> orderViews(List<String> views) {
        ClocksExtensionsReader.readPerspectiveExtensions();
        if (leftMap.isEmpty() && rightMap.isEmpty()) {
            return views;
        }
        ArrayList<String> orderedList = new ArrayList<String>(views);
        leftMap.forEach((key, value) -> {
            List<String> list2 = ClocksExtensionsReader.processElements(orderedList, key, value, 0);
        });
        rightMap.forEach((key, value) -> {
            List<String> list2 = ClocksExtensionsReader.processElements(orderedList, key, value, 1);
        });
        return orderedList;
    }

    public static void showView() {
        ClocksExtensionsReader.readPerspectiveExtensions();
        showViewIds.forEach(id -> PerspectivesHelper.showView((String)id));
    }

    private static List<String> processElements(List<String> views, String view, String relative, int index) {
        int pos = views.indexOf(relative);
        if (pos >= 0) {
            if (views.contains(view)) {
                views.remove(view);
            }
            views.add(pos + index, view);
        }
        return views;
    }

    private static void readPerspectiveExtensions() {
        IExtensionPoint extension;
        if (leftMap.isEmpty() && rightMap.isEmpty() && (extension = Platform.getExtensionRegistry().getExtensionPoint(EXT_POINT_PERSPECTIVE_EXTENSIONS)) != null) {
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(TAG_VIEW)) {
                    String id = element.getAttribute(TAG_ID);
                    String pos = element.getAttribute(TAG_RELATIONSHIP);
                    String relative = element.getAttribute(TAG_RELATIVE);
                    String focus = element.getAttribute(TAG_FOCUS);
                    if (pos.equals(TAG_LEFT)) {
                        leftMap.put(id, relative);
                    } else if (pos.equals(TAG_RIGHT)) {
                        rightMap.put(id, relative);
                    }
                    if (focus.equals(TRUE)) {
                        showViewIds.add(id);
                    }
                }
                ++n2;
            }
        }
    }
}

