/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagram;

import animations.swt.EaseSelector;
import animations.swt.OriginChanger;
import com.nxp.swtools.clocks.data.ClockSlice;
import com.nxp.swtools.clocks.data.ClockSliceUtils;
import com.nxp.swtools.clocks.data.DiagramData;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.ClockSelect;
import com.nxp.swtools.clocks.data.elements.ElementType;
import com.nxp.swtools.clocks.data.elements.FnPll;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.NoClock;
import com.nxp.swtools.clocks.data.elements.Pll;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.platform.IPlatformSpecific;
import com.nxp.swtools.clocks.platform.PlatformSpecificFactory;
import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.clocks.ui.IValueChangeListener;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.ui.diagram.DiagramConnection;
import com.nxp.swtools.clocks.ui.diagram.DiagramPicker;
import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagram.DiagramSymbolToolTipProviderFactory;
import com.nxp.swtools.clocks.ui.diagram.SliceDiagramDialog;
import com.nxp.swtools.clocks.ui.diagram.TextToolTipArea;
import com.nxp.swtools.clocks.ui.diagramsymbols.BoundingBox;
import com.nxp.swtools.clocks.ui.diagramsymbols.Color;
import com.nxp.swtools.clocks.ui.diagramsymbols.CompositeSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.DrawState;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.HitInfo;
import com.nxp.swtools.clocks.ui.diagramsymbols.InvisibleConnectionSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.LineStyle;
import com.nxp.swtools.clocks.ui.diagramsymbols.Pin;
import com.nxp.swtools.clocks.ui.diagramsymbols.Text;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.ui.table.SettingValueChangeListener;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.ui.utils.swt.ITooltipProvider;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.CanvasWithToolTips;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.ui.utils.swt.widgets.ToolTipArea;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.MultiEventAdapter;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.preferences.KEPreferences;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DiagramCanvas {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(DiagramCanvas.class);
    @NonNull
    private static final String DATA_TEMPORARY = "TEMPORARY_EDITOR_CONTROL";
    @NonNull
    public static final String DIAGRAM_IMAGE_FILE_NAME = "clocks_diagram.png";
    @NonNull
    public static final Pattern NUM_DEC_REGEX = Pattern.compile("(\\d+((\\.|,)\\d+)?)");
    @NonNull
    public static final Pattern NUM_INT_REGEX = Pattern.compile("(\\d+)");
    private static final int ANIMATION_DURATION = 200;
    @NonNull
    DiagramPicker mPicker;
    @NonNull
    ScrolledComposite mComposite;
    protected boolean mIsDirty;
    @NonNull
    protected DiagramData mDiagramData;
    @NonNull
    protected CanvasWithToolTips mCanvas;
    protected double mZoomMin = 1.0;
    protected double mZoomMax = 10.0;
    boolean mRecalculateDiagramSize;
    private boolean mExpanded;
    @NonNull
    private Point2D mOffsetDS;
    private double mZoom;
    public static final double DEFAULT_ZOOM = Rap.isActive() ? 6.7 : 5.0;
    protected BoundingBox mDiagramBB_DS;
    @Nullable
    protected IClocksConfig mSetConfig;
    @NonNull
    DiagramStyleProvider mDiagramStyleProvider;
    private static final int DIAGRAM_MARGIN_CS = 10;
    @NonNull
    final IValueChangeListener mChangeListener;
    @NonNull
    @NonNull Set<@NonNull IEventListener> listeners = new HashSet<IEventListener>();

    public DiagramCanvas(@NonNull Composite composite, @NonNull DiagramData data, @Nullable IClocksConfig config) {
        this(composite, data, config, true);
    }

    public DiagramCanvas(@NonNull Composite composite, @NonNull DiagramData data, @Nullable IClocksConfig config, boolean expanded) {
        this.mComposite = new ScrolledComposite(composite, 768);
        this.mComposite.setLayout((Layout)new FillLayout());
        this.mCanvas = new CanvasWithToolTips((Composite)this.mComposite, 0x20040000);
        this.mCanvas.addPaintListener((PaintListener)new DrawListener());
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.mCanvas, "diagramCanvasWithTooltips");
        this.mComposite.setContent((Control)this.mCanvas);
        this.mComposite.setExpandHorizontal(true);
        this.mComposite.setExpandVertical(true);
        this.addListeners();
        this.mChangeListener = new SettingValueChangeListener(this.mCanvas);
        this.mExpanded = expanded;
        this.mOffsetDS = new Point2D.Double();
        this.mPicker = new DiagramPicker(this);
        this.mDiagramData = data;
        this.mDiagramStyleProvider = new DiagramStyleProvider();
        this.initialize(config, data);
        this.mCanvas.addDisposeListener(e -> this.listeners.forEach(x -> GuiController.getInstance().removeModelListener((IEventListener)x)));
    }

    protected void initialize(@Nullable IClocksConfig config, @NonNull DiagramData data) {
        this.mDiagramData = data;
        this.mIsDirty = true;
        this.mDiagramBB_DS = new BoundingBox();
        this.mOffsetDS = new Point2D.Double();
        this.mZoom = DEFAULT_ZOOM;
        this.mRecalculateDiagramSize = true;
        this.setWorkingConfig(config);
        this.syncWithConfig(this.getWorkingConfig());
    }

    protected void openEditingSupportFor(@NonNull HitInfo hitInfo, @NonNull IClocksConfig config, int defaultX, int defaultY, boolean wasSelected) {
        IClockElement hitElement = config.getMcu().getClockElement(hitInfo.getId());
        boolean elementHitted = false;
        if (HitInfo.HitType.SLICE == hitInfo.getType()) {
            hitElement = config.getMcu().getClockElement("NO_CLOCK");
        }
        if (hitElement != null) {
            ISetting setting = null;
            boolean pllScale = false;
            boolean slice = false;
            boolean overridePosition = true;
            switch (hitInfo.getType()) {
                case SCALE_LOCK: {
                    if (hitElement instanceof Pll) {
                        List<ISetting> pllsettings = hitElement.getSettings(SettingType.FREQUENCY_MODIFIER);
                        setting = pllsettings.size() > 0 ? pllsettings.get(0) : null;
                        break;
                    }
                }
                case SCALE: {
                    setting = hitElement.getFrequencyModifierSetting();
                    if (!(hitElement instanceof Pll) && !(hitElement instanceof FnPll)) break;
                    setting = hitElement.getEnableSetting();
                    pllScale = true;
                    break;
                }
                case OUTPUT_FREQ: 
                case OUTPUT_FREQ_LOCK: {
                    setting = hitElement.getOutputFrequencySetting();
                    break;
                }
                case SLICE: {
                    slice = true;
                    setting = hitElement.getEnableSetting();
                    break;
                }
                default: {
                    if (wasSelected && (ElementType.CLOCK_SELECT.toString().equals(hitElement.getType()) || DiagramCanvas.isUserEnablable(hitElement))) {
                        overridePosition = false;
                        setting = hitElement.getFrequencyModifierSetting();
                        if (setting == null && DiagramCanvas.isUserEnablable(hitElement)) {
                            setting = hitElement.getMainSetting();
                        }
                    }
                    elementHitted = true;
                }
            }
            int fSize = -1;
            if (setting != null) {
                if (hitInfo.getType() == HitInfo.HitType.SCALE_LOCK || hitInfo.getType() == HitInfo.HitType.OUTPUT_FREQ_LOCK) {
                    if (setting.isUserLockable() && config.isLocked(setting)) {
                        ISetting finSet = setting;
                        SettingEditorHelper.lockSetting(finSet, config, false, this.mChangeListener);
                    }
                } else {
                    if (hitInfo.getElem() instanceof Text) {
                        Text f = (Text)hitInfo.getElem();
                        fSize = f.getFontSize(this.mZoom);
                    }
                    java.awt.Point pos = new java.awt.Point(defaultX, defaultY);
                    java.awt.Point size = new java.awt.Point(-1, -1);
                    if (overridePosition) {
                        this.getToCanvasTransform().transform(hitInfo.getElem().getBoundingBoxDS().getTopLeftCornerDS(), pos);
                        this.getToCanvasTransform().transform(hitInfo.getElem().getBoundingBoxDS().getBottomRightCornerDS(), size);
                        --pos.x;
                        --pos.y;
                        size.x -= pos.x;
                        size.y -= pos.y;
                    }
                    if (pllScale) {
                        this.openEditingSupportForPll(hitElement, config, pos.x, pos.y, size.x, size.y, fSize);
                    } else if (slice) {
                        this.openEditingSupportFor(setting, config, pos.x, pos.y, size.x, size.y / 2, fSize, elementHitted);
                    } else {
                        this.openEditingSupportFor(setting, config, pos.x, pos.y, size.x, size.y, fSize, elementHitted);
                    }
                }
            }
        }
    }

    private static boolean isUserEnablable(@NonNull IClockElement element) {
        ISetting mainSetting = element.getMainSetting();
        if (mainSetting != null) {
            return mainSetting.isUserEnableable();
        }
        return false;
    }

    public void scrollToSymbol(@Nullable String id) {
        if (id == null) {
            return;
        }
        if (Rap.isActive()) {
            return;
        }
        DiagramSymbol symbol = (DiagramSymbol)CollectionsUtils.findAny(this.mDiagramData.getAllSymbols(), s -> s.getId().equals(id));
        if (symbol != null) {
            Point compositeSizeCS = this.mComposite.getSize();
            Point2D symbolCS = this.getToCanvasTransform().transform(symbol.calculateMaxBoundingBoxDS().getCenterDS(), null);
            Point focusPointCS = new Point((int)symbolCS.getX() - compositeSizeCS.x / 2, (int)symbolCS.getY() - compositeSizeCS.y / 2);
            if (KEPreferences.isAnimationsEnabled()) {
                OriginChanger oc = new OriginChanger(this.mComposite, focusPointCS.x, focusPointCS.y, EaseSelector.LINEAR);
                oc.play(200);
            } else {
                this.mComposite.setOrigin(focusPointCS);
            }
        }
    }

    protected void openEditingSupportFor(@NonNull ISetting setting, @NonNull IClocksConfig config, int x, int y, int minWidth, int minHeight, int minFont, boolean isElement) {
        InstantSearchList control = null;
        String editorValue = SettingEditorHelper.getValue(setting, config);
        if (setting.getElement() instanceof NoClock) {
            control = this.createSliceSelectCombo(config);
        } else if (setting.isUserEnableable() && isElement) {
            control = this.createConnectDisconnectCombo(setting, config);
        } else if (!setting.isEditable(config)) {
            Label label = new Label((Composite)this.getCanvas(), 2048);
            label.setText(editorValue);
            label.setBackground(DiagramStyleProvider.getBgColor().getSWTColor());
            control = label;
        } else {
            @NonNull String[] values = SettingEditorHelper.getUiValuesForCombo(setting, config);
            if (values != null) {
                InstantSearchList list = new InstantSearchList((Composite)this.getCanvas(), 2048);
                if (setting.getType().equals((Object)SettingType.FREQUENCY_OUTPUT)) {
                    list.setAllowCustomValue(true);
                }
                list.setItems(values);
                list.select(editorValue);
                list.addListener(13, event -> {
                    String value = event.text;
                    SettingEditorHelper.setValue(setting, config, value, this.mChangeListener);
                    list.dispose();
                });
                list.setEditable(setting.isEditable(config));
                control = list;
            }
            if (control == null) {
                org.eclipse.swt.widgets.Text text = new org.eclipse.swt.widgets.Text((Composite)this.getCanvas(), 2048);
                text.setText(editorValue);
                text.addListener(1, event -> {
                    if (event.character == '\r' || event.character == '\n') {
                        String value = text.getText().trim();
                        SettingEditorHelper.setValue(setting, config, value, this.mChangeListener);
                        text.dispose();
                    }
                });
                text.setEditable(setting.isEditable(config));
                if (setting.isEditable(config)) {
                    text.selectAll();
                }
                text.setTextLimit(20);
                control = text;
            }
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)control, SettingEditorHelper.getEditorToolTip(setting, config));
        }
        if (FontFactory.getFontHeight((Control)control) < minFont) {
            FontFactory.changeFontSize((Control)control, (int)minFont);
        }
        DiagramCanvas.position((Control)control, x, y, minWidth, minHeight);
        control.setFocus();
        this.getCanvas().layout();
        InstantSearchList controlToDispose = control;
        control.setData(DATA_TEMPORARY, (Object)Boolean.TRUE);
        control.addListener(16, arg_0 -> DiagramCanvas.lambda$5((Control)controlToDispose, arg_0));
        if (!setting.isEditable(config)) {
            GuiController.getInstance().addListener(2, arg_0 -> DiagramCanvas.lambda$6((Control)controlToDispose, arg_0));
        }
        if (control instanceof InstantSearchList) {
            InstantSearchList finList = control;
            finList.getDisplay().asyncExec(() -> finList.open());
        }
    }

    private @NonNull InstantSearchList createSliceSelectCombo(@NonNull IClocksConfig config) {
        final InstantSearchList combo = new InstantSearchList((Composite)this.getCanvas(), 2048);
        final ArrayList slices = new ArrayList();
        config.getMcu().getClockComponents().values().forEach(s -> {
            boolean bl = slices.addAll(s.getSlices());
        });
        @NonNull String[] sliceItems = (String[])slices.stream().map(ClockSlice::getName).toArray(String[]::new);
        combo.setItems(sliceItems);
        combo.select(sliceItems[0]);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClockSlice slice = (ClockSlice)CollectionsUtils.nullableOptionalGet(slices.stream().filter(x -> x.getName().equals(combo.getText())).findAny());
                Shell shell = DiagramCanvas.this.getCanvas().getShell();
                combo.dispose();
                if (slice != null && shell != null) {
                    SliceDiagramDialog.getFor(slice, shell).open();
                }
            }
        });
        return combo;
    }

    protected void openEditingSupportForPll(@NonNull IClockElement element, @NonNull IClocksConfig config, int x, int y, int minWidth, int minHeight, int minFont) {
        String fnpllTooltip = UtilsText.safeString((String)Messages.get().DiagramCanvas_FnpllTooltip);
        String pllTooltip = UtilsText.safeString((String)Messages.get().DiagramCanvas_PllTooltip);
        org.eclipse.swt.widgets.Text text = new org.eclipse.swt.widgets.Text((Composite)this.getCanvas(), 2048);
        StringBuilder builder = new StringBuilder();
        DiagramCanvas.appendElementModifiers(element, config, builder);
        text.setText(builder.toString());
        text.addListener(1, this.createPllEditorListener(element, config, text, pllTooltip, fnpllTooltip));
        text.setEditable(true);
        text.selectAll();
        text.setTextLimit(20);
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)text, element instanceof FnPll ? fnpllTooltip : pllTooltip);
        if (FontFactory.getFontHeight((Control)text) < minFont) {
            FontFactory.changeFontSize((Control)text, (int)minFont);
        }
        DiagramCanvas.position((Control)text, x, y, minWidth, minHeight);
        text.setFocus();
        this.getCanvas().layout();
        org.eclipse.swt.widgets.Text controlToDispose = text;
        text.setData(DATA_TEMPORARY, (Object)Boolean.TRUE);
        text.addListener(16, arg_0 -> DiagramCanvas.lambda$11((Control)controlToDispose, arg_0));
        GuiController.getInstance().addListener(2, arg_0 -> DiagramCanvas.lambda$12((Control)controlToDispose, arg_0));
    }

    private Listener createPllEditorListener(final @NonNull IClockElement element, final @NonNull IClocksConfig config, final @NonNull org.eclipse.swt.widgets.Text text, final @NonNull String pllTooltip, final @NonNull String fnpllTooltip) {
        return new Listener(){

            private List<@NonNull String> findDigitsInExpression(@NonNull org.eclipse.swt.widgets.Text textInput, boolean allowFractional) {
                String value = textInput.getText().trim();
                return this.findDigitsInExpression(value.toString(), allowFractional);
            }

            private List<@NonNull String> findDigitsInExpression(@NonNull String input, boolean allowFractional) {
                Pattern digitsRegex = allowFractional ? NUM_DEC_REGEX : NUM_INT_REGEX;
                Matcher matcher = digitsRegex.matcher(input);
                ArrayList<@NonNull String> values = new ArrayList<String>();
                if (matcher.find()) {
                    do {
                        String group = matcher.group();
                        values.add(group);
                    } while (matcher.find());
                }
                return values;
            }

            public void handleEvent(Event event) {
                if (event.character == '\r' || event.character == '\n') {
                    if (element instanceof FnPll) {
                        this.handleFnPllTextChange(this.findDigitsInExpression(text, false));
                    } else if (element instanceof Pll) {
                        Pll pll = (Pll)element;
                        BigInteger fraction = pll.getMultiplier().getFraction(config);
                        List<@NonNull String> values = this.findDigitsInExpression(text, fraction.compareTo(BigInteger.ONE) > 0);
                        if (values.size() == 2) {
                            ISetting divSetting = pll.getDivider().getFrequencyModifierSetting();
                            ISetting mulSetting = pll.getMultiplier().getFrequencyModifierSetting();
                            if (divSetting != null && mulSetting != null) {
                                UiController.getInstance().runTransaction(() -> {
                                    SettingEditorHelper.setValue(divSetting, config, values.get(0), DiagramCanvas.this.mChangeListener);
                                    SettingEditorHelper.setValue(mulSetting, config, values.get(1), DiagramCanvas.this.mChangeListener);
                                });
                            }
                        } else {
                            MessageDialog.openError((Shell)DiagramCanvas.this.getCanvas().getShell(), (String)Messages.get().DiagramCanvas_InvalidInput, (String)pllTooltip);
                        }
                    }
                    text.dispose();
                }
            }

            private void handleFnPllTextChange(List<@NonNull String> values) {
                boolean valueChanged;
                StringBuilder exprBuilder = new StringBuilder();
                FnPll fnpll = (FnPll)element;
                DiagramCanvas.createFnPllScale(config, fnpll, exprBuilder);
                boolean bl = valueChanged = !Objects.equals(values, this.findDigitsInExpression(exprBuilder.toString(), true));
                if (valueChanged && values.size() == 3) {
                    String div = values.get(0);
                    String num = values.get(1);
                    String denom = values.get(2);
                    BigRational rationalNum = BigRational.tryParse((String)num);
                    BigRational rationalDenom = BigRational.tryParse((String)denom);
                    if (rationalNum != null && rationalDenom != null && rationalNum.compareTo(rationalDenom) > 0) {
                        MessageDialog.openError((Shell)DiagramCanvas.this.getCanvas().getShell(), (String)Messages.get().DiagramCanvas_InvalidInput, (String)fnpllTooltip);
                    } else {
                        UiController.getInstance().runTransaction(() -> {
                            boolean changed = SettingEditorHelper.setValue(fnpll.getDivSetting(), config, div, DiagramCanvas.this.mChangeListener);
                            changed |= SettingEditorHelper.setValue(fnpll.getNumSetting(), config, num, DiagramCanvas.this.mChangeListener);
                            if (!(changed |= SettingEditorHelper.setValue(fnpll.getDenomSetting(), config, denom, DiagramCanvas.this.mChangeListener))) {
                                MessageDialog.openError((Shell)DiagramCanvas.this.getCanvas().getShell(), (String)Messages.get().DiagramCanvas_InvalidInput, (String)fnpllTooltip);
                            }
                        });
                    }
                } else if (valueChanged) {
                    MessageDialog.openError((Shell)DiagramCanvas.this.getCanvas().getShell(), (String)Messages.get().DiagramCanvas_InvalidInput, (String)fnpllTooltip);
                } else {
                    UiController.getInstance().runTransaction(() -> {
                        SettingEditorHelper.lockSetting(fnpll.getDivSetting(), config, true, DiagramCanvas.this.mChangeListener);
                        SettingEditorHelper.lockSetting(fnpll.getNumSetting(), config, true, DiagramCanvas.this.mChangeListener);
                        SettingEditorHelper.lockSetting(fnpll.getDenomSetting(), config, true, DiagramCanvas.this.mChangeListener);
                    });
                }
            }
        };
    }

    public @NonNull Combo createConnectDisconnectCombo(final @NonNull ISetting setting, final @NonNull IClocksConfig config) {
        final Combo combo = new Combo((Composite)this.getCanvas(), 2056);
        SettingsConfig settingsConfig = config.getSettingsConfig();
        boolean userEnabled = settingsConfig.isUserEnabled(setting);
        combo.setItems(new String[]{Messages.get().DiagramCanvas_Connected, Messages.get().DiagramCanvas_Disconnected});
        combo.select(userEnabled ? 0 : 1);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enable = combo.getSelectionIndex() == 0;
                GuiController.getInstance().setUserEnableStateOf(setting, config, enable, DiagramCanvas.this.getCanvas().getShell());
                combo.dispose();
            }
        });
        return combo;
    }

    private static void position(@NonNull Control control, int x, int y, int minWidth, int minHeight) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, x);
        formData.top = new FormAttachment(0, y);
        control.setLayoutData((Object)formData);
        Point size = control.computeSize(-1, -1);
        if (minWidth > size.x) {
            formData.width = minWidth;
        }
        if (minHeight > size.y) {
            formData.height = minHeight;
        }
    }

    protected void clearNonLabels() {
        ArrayList<@NonNull Control> ctrls = new ArrayList<Control>();
        Control[] controlArray = this.getCanvas().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child != null && child.getData(DATA_TEMPORARY) != null) {
                ctrls.add(child);
            }
            ++n2;
        }
        ctrls.forEach(Widget::dispose);
    }

    protected void addListeners() {
        this.mCanvas.addMouseListener((org.eclipse.swt.events.MouseListener)new MouseListener());
        this.mComposite.addListener(37, event -> {
            if ((event.stateMask & 0x40000) == 262144) {
                this.zoomBy((double)event.count / 15.0, true);
            }
        });
        MultiEventAdapter modelListener = new MultiEventAdapter(){

            public void handle(@NonNull Collection<@NonNull ToolEvent> events) {
                if (ToolEvent.containAnyEventType((int)64, events)) {
                    if (!DiagramCanvas.this.mDiagramData.isSlice()) {
                        DiagramCanvas.this.initialize(DiagramCanvas.this.mSetConfig, GuiController.getInstance().getProfile().getMcu().getDiagramDataCopy());
                    } else {
                        DiagramCanvas.this.mCanvas.dispose();
                    }
                } else if (ToolEvent.containAnyEventType((int)12, events)) {
                    DiagramCanvas.this.syncWithConfig(DiagramCanvas.this.getWorkingConfig());
                    if (!ToolEvent.allEventsOriginator((Object)DiagramCanvas.this, events)) {
                        DiagramCanvas.this.scrollToSymbol(GuiController.getInstance().getSelectedElement());
                    }
                } else if (ToolEvent.containAnyEventType((int)50, events)) {
                    IClocksConfig workingConfig = DiagramCanvas.this.getWorkingConfig();
                    if (DiagramCanvas.this.mSetConfig == null || Objects.equals(DiagramCanvas.this.mSetConfig, workingConfig)) {
                        DiagramCanvas.this.syncWithConfig(workingConfig);
                    }
                }
            }
        };
        this.listeners.add((IEventListener)modelListener);
        GuiController.getInstance().addListener(-1, (IEventListener)modelListener);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void syncWithConfig(@Nullable IClocksConfig config) {
        if (config == null) {
            return;
        }
        @NonNull Collection<@NonNull Collection<@NonNull IClockElement>> usedPathElements = config.getAllOutputPaths();
        @Nullable @NonNull List selectedPathElements = CollectionsUtils.safeList(GuiController.getInstance().getActiveElementsPath());
        Set<@NonNull String> selectedPathIds = selectedPathElements.stream().map(IElement::getID).collect(Collectors.toSet());
        this.mDiagramData.getAllSymbols().forEach(x -> x.update(DrawState.State.CLEAR));
        this.mDiagramData.getSymbolsUnavailable().forEach(this::setSymbolUnavailable);
        this.mDiagramData.getSymbolsWithElement().forEach(x -> this.setSymbolWithElement((DiagramSymbol)x, config, selectedPathIds));
        this.mDiagramData.getSymbolsWithPin().forEach(x -> this.setSymbolWithPin((DiagramSymbol)x, config));
        this.mDiagramData.getSymbolsDiagramOnly().forEach(x -> this.setSymbolDiagramOnly((DiagramSymbol)x, selectedPathIds));
        this.setConnections(usedPathElements, selectedPathElements, selectedPathIds);
        this.updateToolTips(config);
        this.draw();
    }

    void setSymbolUnavailable(@NonNull DiagramSymbol symbol) {
        symbol.updateOutputFrequency(UtilsText.safeString((String)Messages.get().DiagramCanvas_UnavailableFrequency), false, DrawState.State.STATUS_UNAVAILABLE);
        symbol.update(DrawState.State.STATUS_UNAVAILABLE);
        symbol.updateScale("", false);
        this.mDiagramData.getConnections(symbol.getId()).forEach(x -> x.update(DrawState.State.STATUS_UNAVAILABLE));
    }

    void setSymbolDiagramOnly(@NonNull DiagramSymbol symbol, Set<@NonNull String> selectedPathIds) {
        symbol.update(DrawState.State.STATUS_FINE);
        String selectedElement = GuiController.getInstance().getSelectedElement();
        if (selectedElement != null && selectedElement.startsWith(symbol.getId())) {
            if (selectedElement.length() == symbol.getId().length()) {
                symbol.update(DrawState.State.SELECTED_FLAG);
            } else if (selectedElement.charAt(symbol.getId().length()) == '.') {
                symbol.update(DrawState.State.BOUNDARY_SELECTED_FLAG);
            }
        }
        if (symbol instanceof InvisibleConnectionSymbol) {
            this.setInvisibleConnectionSymbol((InvisibleConnectionSymbol)symbol);
        } else {
            IClocksConfig config;
            this.mDiagramData.getConnections(symbol.getId()).forEach(x -> x.update(DrawState.State.STATUS_FINE));
            if (symbol instanceof CompositeSymbol && ((CompositeSymbol)symbol).isClockSlices() && (config = this.getWorkingConfig()) != null && ClockSliceUtils.isAnySliceElementOnPath(selectedPathIds, config)) {
                symbol.update(DrawState.State.APPEARANCE_ACTIVE);
            }
        }
    }

    void setInvisibleConnectionSymbol(@NonNull InvisibleConnectionSymbol symbol) {
        Collection<@NonNull DiagramConnection> endConnections = this.mDiagramData.getConnectionsEndingIn(symbol.getId());
        if (endConnections.size() != 1) {
            return;
        }
        DiagramSymbol predecessor = ((DiagramConnection)CollectionsUtils.first(endConnections)).getPredecessor();
        IClocksConfig config = this.getWorkingConfig();
        boolean useSuccessor = !this.mDiagramData.isSlice() && config != null && ClockSliceUtils.isFromSlice(predecessor.getId(), config);
        DiagramSymbol symbolWithState = predecessor;
        for (DiagramConnection outputConnection : this.mDiagramData.getConnections(symbol.getId())) {
            Optional<GraphicalElement> element;
            GraphicalElement pin;
            if (useSuccessor) {
                symbolWithState = outputConnection.getSuccessor();
            }
            Pin pin2 = pin = symbolWithState != null ? symbolWithState.getActiveInputPin() : null;
            if (pin == null && symbolWithState != null && (element = symbolWithState.getGraphElems().stream().filter(x -> x instanceof Pin).findFirst()).isPresent()) {
                pin = element.get();
            }
            if (pin == null) {
                outputConnection.update(DrawState.State.STATUS_FINE);
                continue;
            }
            for (DrawState.State state : pin.getDrawState().get()) {
                if (state == DrawState.State.SELECTED_FLAG) continue;
                outputConnection.updateButPred(state);
            }
        }
    }

    void setSymbolWithPin(@NonNull DiagramSymbol symbol, @NonNull IClocksConfig config) {
        com.nxp.swtools.clocks.data.elements.Pin p = config.getMcu().getAllPins().get(symbol.getId());
        if (p != null) {
            symbol.update(DrawState.State.APPEARANCE_NORMAL);
            DrawState.State state = p.isEnabled(config) ? DrawState.State.STATUS_FINE : DrawState.State.STATUS_DISABLED;
            symbol.update(state);
            return;
        }
        assert (false);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    void setSymbolWithElement(@NonNull DiagramSymbol symbol, @NonNull IClocksConfig config, Set<@NonNull String> selectedPathIds) {
        ClockSelect cs;
        String predecessor;
        ClockOutput.CMU cmuFreq;
        boolean isLocked;
        String id = symbol.getId();
        IMcu mcu = config.getMcu();
        IClockElement element = mcu.getClockElement(id);
        if (element == null) {
            LOGGER.log(SWToolsProperties.isVerificationOn() ? Level.SEVERE : Level.WARNING, "Diagram symbol " + id + " should have respective model element in config " + config.getName() + " and MCU " + mcu.getMcuDescriptor().getPartNumber() + " but it was not found");
            assert (false);
            return;
        }
        DrawState.State internalState = DrawState.State.STATUS_FINE;
        internalState = element.isDisabled(config) ? DrawState.State.STATUS_DISABLED : internalState;
        internalState = element.isValid(config) ? internalState : DrawState.State.STATUS_ERROR;
        symbol.update(internalState);
        if (id.equals(GuiController.getInstance().getSelectedElement())) {
            symbol.update(DrawState.State.SELECTED_FLAG);
        }
        if (selectedPathIds.contains(id)) {
            symbol.update(DrawState.State.APPEARANCE_ACTIVE);
        }
        ISetting setting = element.getOutputFrequencySetting();
        SettingValue value = config.getSettingsConfig().getSettingValue(setting);
        String freq = value.getUiValue();
        boolean bl = isLocked = config.getSettingsConfig().isLocked(setting) && setting.isUserLockable();
        if (isLocked) {
            LockState tmp = config.getSettingsConfig().getLockState(setting);
            freq = tmp == null ? freq : tmp.getUiValue();
        }
        DrawState.State outputState = DrawState.State.STATUS_FINE;
        if (config.getSettingsConfig().isInvalid(setting)) {
            outputState = DrawState.State.STATUS_ERROR;
        } else if (value.isN_A()) {
            outputState = DrawState.State.STATUS_DISABLED;
        }
        symbol.updateOutputFrequency(freq, isLocked, outputState);
        if (element instanceof ClockOutput && (cmuFreq = ((ClockOutput)element).getCmuFreq()) != null) {
            ISetting lowFreq = cmuFreq.getLowFreqSetting();
            ISetting highFreq = cmuFreq.getHighFreqSetting();
            if (lowFreq != null && highFreq != null) {
                SettingValue lowFreqValue = config.getSettingsConfig().getSettingValue(lowFreq);
                SettingValue highFreqValue = config.getSettingsConfig().getSettingValue(highFreq);
                String cmuFreqValue = MessageFormat.format("({0}; {1})", lowFreqValue.getUiValue(), highFreqValue.getUiValue());
                symbol.updateCmuOutputFrequency(cmuFreqValue, false, DrawState.State.STATUS_ERROR);
            }
        }
        DrawState.State connState = outputState;
        this.mDiagramData.getConnections(id).forEach(x -> x.update(connState));
        StringBuilder scale = new StringBuilder();
        DiagramCanvas.appendElementModifiers(element, config, scale);
        @NonNull List<@NonNull ISetting> settings = element.getSettings(SettingType.FREQUENCY_MODIFIER);
        isLocked = settings.stream().anyMatch(x -> x.isUserLockable() && config.getSettingsConfig().isLocked((ISetting)x));
        symbol.updateScale(UtilsText.safeToString((Object)scale), isLocked);
        if (element instanceof ClockSelect && (predecessor = (cs = (ClockSelect)element).getActivePredecessor(config)) != null) {
            DiagramConnection connection = this.mDiagramData.getConnection(predecessor, cs.getID());
            if (connection != null) {
                symbol.setActiveInputPin(connection.succPin);
            } else if (mcu.getNoClockElement().getID().equals(predecessor)) {
                symbol.setActiveInputPin(null);
            } else {
                LOGGER.warning("Cannot find predecessor " + predecessor + " for symbol " + id);
                @NonNull List collect = (List)CollectionsUtils.getInstancesOf(symbol.getGraphElems(), Pin.class).filter(Pin::isInput).collect(CollectorsUtils.toList());
                symbol.setActiveInputPin((Pin)collect.get(0));
            }
        }
    }

    static @NonNull String createFnPllScale(@NonNull IClocksConfig config, @NonNull FnPll fractionalPllElement, @NonNull StringBuilder exprBuilder) {
        BigInteger div = fractionalPllElement.getDivValue(config);
        BigInteger num = fractionalPllElement.getNumValue(config);
        BigInteger denom = fractionalPllElement.getDenomValue(config);
        exprBuilder.append("*");
        exprBuilder.append("(");
        exprBuilder.append(div);
        exprBuilder.append(" + ");
        exprBuilder.append("(");
        exprBuilder.append(num);
        exprBuilder.append("/");
        exprBuilder.append(denom);
        exprBuilder.append(")");
        exprBuilder.append(")");
        return UtilsText.safeToString((Object)exprBuilder);
    }

    void setConnections(@NonNull Collection<@NonNull Collection<@NonNull IClockElement>> usedPathElements, @NonNull List<@NonNull IClockElement> selectedPath, @NonNull Set<@NonNull String> selectedPathIds) {
        Collection<DiagramConnection> allConnections = this.mDiagramData.getAllConnections();
        ArrayList inactiveConnections = new ArrayList(allConnections.size());
        ArrayList normalConnections = new ArrayList(allConnections.size());
        ArrayList selectedConnections = new ArrayList(allConnections.size());
        Set<@NonNull String> pathConnectionIds = DiagramCanvas.createPathsConnectionIds(usedPathElements);
        Set<@NonNull String> selectionConnectionIds = DiagramCanvas.createPathConnectionIds(selectedPath);
        allConnections.forEach(x -> {
            IClockElement successorElement;
            DiagramSymbol predecessor = x.getPredecessor();
            DiagramSymbol successor = x.getSuccessor();
            if (selectionConnectionIds.contains(x.getId())) {
                selectedConnections.add(x);
                return;
            }
            if (successor instanceof InvisibleConnectionSymbol && selectedPathIds.contains(predecessor.getId())) {
                Collection<@NonNull DiagramConnection> connections = this.mDiagramData.getConnections(x.getSuccessorId());
                for (DiagramConnection connection : connections) {
                    if (!selectionConnectionIds.contains(DiagramConnection.createConnectionID(x.getPredecessorId(), connection.getSuccessorId()))) continue;
                    selectedConnections.add(x);
                    return;
                }
            }
            IClocksConfig config = this.getWorkingConfig();
            if (predecessor instanceof InvisibleConnectionSymbol && successor != null && selectedPathIds.contains(successor.getId()) && config != null && (!((successorElement = config.getMcu().getClockElement(successor.getId())) instanceof ClockSelect) || Objects.equals(x.succPin, successor.getActiveInputPin()))) {
                selectedConnections.add(x);
                return;
            }
            if (pathConnectionIds.contains(x.getId())) {
                normalConnections.add(x);
                return;
            }
            inactiveConnections.add(x);
        });
        inactiveConnections.forEach(x -> x.update(DrawState.State.APPEARANCE_INACTIVE));
        normalConnections.forEach(x -> x.update(DrawState.State.APPEARANCE_NORMAL));
        selectedConnections.forEach(x -> x.update(DrawState.State.APPEARANCE_ACTIVE));
    }

    private static @NonNull Set<@NonNull String> createPathsConnectionIds(@NonNull Collection<@NonNull Collection<@NonNull IClockElement>> paths) {
        HashSet<@NonNull String> pathConnectionIds = new HashSet<String>();
        for (Collection<IClockElement> path : paths) {
            pathConnectionIds.addAll(DiagramCanvas.createPathConnectionIds(new ArrayList<IClockElement>(path)));
        }
        return pathConnectionIds;
    }

    private static @NonNull Set<@NonNull String> createPathConnectionIds(@NonNull List<@NonNull IClockElement> path) {
        int size = path.size();
        HashSet<@NonNull String> pathConnectionIds = new HashSet<String>(size);
        int i = size - 2;
        while (i >= 0) {
            pathConnectionIds.add(DiagramConnection.createConnectionID(path.get(i).getID(), path.get(i + 1).getID()));
            --i;
        }
        if (!path.isEmpty()) {
            pathConnectionIds.add(DiagramConnection.createConnectionID(path.get(size - 1).getID(), ""));
        }
        return pathConnectionIds;
    }

    public void zoomBy(double delta, boolean needsCentering) {
        double origZoom = this.getZoom();
        this.setZoom(origZoom + delta, needsCentering);
    }

    public void setZoom(double newVal, boolean needsCentering) {
        double old = this.mZoom;
        Point cursorLocation = this.mComposite.getDisplay().getCursorLocation();
        Point relativeCursorLocation = this.mCanvas.toControl(cursorLocation);
        this.mZoom = Math.max(this.mZoomMin, Math.min(this.mZoomMax, newVal));
        UIJobHelper.runNowOrInJob(this::updateCompositeSize, (String)"Updating diagram canvas size", (Display)this.mComposite.getDisplay());
        this.updateToolTipsAreas();
        if (this.mZoom < 4.5) {
            this.mDiagramStyleProvider.setThinLines();
        } else {
            this.mDiagramStyleProvider.setThickLines();
        }
        this.draw();
        this.clearNonLabels();
        double alpha = this.mZoom / old;
        Point oldOrigin = this.mComposite.getOrigin();
        Point newOrigin = new Point((int)((double)relativeCursorLocation.x * (alpha - 1.0)) + oldOrigin.x, (int)((double)relativeCursorLocation.y * (alpha - 1.0)) + oldOrigin.y);
        if (needsCentering) {
            this.mComposite.setOrigin(newOrigin);
            this.scrollToSymbol(GuiController.getInstance().getSelectedElement());
        }
    }

    private void updateToolTipsAreas() {
        this.mCanvas.getToolTipAreas().forEach(x -> {
            DiagramSymbol s;
            DiagramSymbol diagramSymbol = s = x instanceof TextToolTipArea ? this.findSymbol(((TextToolTipArea)((Object)x)).getElementSymbolId()) : this.findSymbol(x.getSymbolId());
            if (s != null) {
                if (x instanceof TextToolTipArea) {
                    TextToolTipArea textToolTipArea = (TextToolTipArea)((Object)x);
                    Optional<Text> text = s.getAllTexts().stream().filter(t -> t.getUUID() == textToolTipArea.getTextUUID()).findFirst();
                    if (text.isPresent()) {
                        x.setArea(this.getToolTipAreaFor(text.get()));
                    }
                } else {
                    x.setArea(this.getToolTipAreaFor(s));
                }
            }
        });
        if (Rap.isActive()) {
            this.mCanvas.resetToolTipsAreas();
        }
    }

    public @NonNull AffineTransform getToCanvasTransform() {
        AffineTransform trans = new AffineTransform();
        trans.translate(this.mOffsetDS.getX() * this.mZoom, this.mOffsetDS.getY() * this.mZoom);
        trans.scale(this.mZoom, this.mZoom);
        return trans;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull List<@NonNull Point> getGraphElemPosition(@NonNull String id, @NonNull HitInfo.HitType type) {
        ArrayList<@NonNull Point> result = new ArrayList<Point>();
        DiagramSymbol symbol = this.findSymbol(id);
        AffineTransform transform = this.getToCanvasTransform();
        if (symbol != null) {
            symbol.getGraphElemPosition(type).forEach(x -> {
                @NonNull Point2D tmp = transform.transform((Point2D)x, null);
                result.add(new Point((int)tmp.getX(), (int)tmp.getY()));
            });
        }
        return result;
    }

    private @Nullable DiagramSymbol findSymbol(@NonNull String id) {
        Optional<DiagramSymbol> s = this.mDiagramData.getAllSymbols().stream().filter(x -> x.getId().equals(id)).findFirst();
        if (s.isPresent()) {
            return s.get();
        }
        return null;
    }

    public @NonNull AffineTransform getToDiagramTransform() {
        AffineTransform trans = new AffineTransform();
        if (0.0 != this.mZoom) {
            trans.translate(-this.mOffsetDS.getX(), -this.mOffsetDS.getY());
            trans.scale(1.0 / this.mZoom, 1.0 / this.mZoom);
        } else {
            LOGGER.warning("Zoom was zero. Cannot create inverse transformation (to diagram space). Identity transform will be used instead.");
        }
        return trans;
    }

    public void draw() {
        this.mIsDirty = true;
        this.mCanvas.redraw();
    }

    protected void drawToolTipAreas(@NonNull PaintEvent e) {
        Color pink = new Color(255, 20, 147);
        GC gc = e.gc;
        assert (gc != null);
        this.mCanvas.drawToolTipAreas(gc, pink.getSWTColor());
    }

    protected void drawDiagramBoundary(@NonNull PaintEvent e) {
        Color pink = new Color(255, 20, 147);
        LineStyle ls = new LineStyle(LineStyle.Style.SOLID, 4, pink);
        this.mDiagramBB_DS.draw(this.getToCanvasTransform(), e, null, ls);
    }

    protected void drawClickLocations(@NonNull PaintEvent e) {
        Color pink = new Color(255, 20, 147);
        e.gc.setForeground(pink.getSWTColor());
        this.mDiagramData.getAllSymbols().forEach(x -> Arrays.asList(HitInfo.HitType.values()).forEach(hitType -> this.getGraphElemPosition(x.getId(), (HitInfo.HitType)((Object)((Object)hitType))).forEach(point -> paintEvent.gc.drawOval(point.x - 3, point.y - 3, 6, 6))));
    }

    public double getZoom() {
        return this.mZoom;
    }

    public void saveImage(@NonNull String path) {
        this.mComposite.setVisible(false);
        this.mCanvas.setRedraw(false);
        double old = this.mZoom;
        this.setZoom(this.mZoomMax, false);
        this.updateCompositeSize();
        Image image = new Image((Device)this.mCanvas.getDisplay(), this.mCanvas.getSize().x, this.mCanvas.getSize().y);
        IPlatformSpecific platformSpecific = PlatformSpecificFactory.getPlatformSpecific();
        platformSpecific.printImageOnCanvas(image, this.mCanvas, this.mDiagramData, this.getToCanvasTransform(), this.mDiagramStyleProvider);
        this.setZoom(old, false);
        this.mCanvas.setRedraw(true);
        this.mComposite.setVisible(true);
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save(UtilsFile.makeFullPath((String)path, (String)DIAGRAM_IMAGE_FILE_NAME), 5);
        image.dispose();
    }

    public void setDiagramOffset(@NonNull Point2D offsetDS) {
        this.mOffsetDS = offsetDS;
    }

    protected void updateToolTips(@NonNull IClocksConfig config) {
        ArrayList<@NonNull ToolTipArea> toolTipAreas = new ArrayList<ToolTipArea>(this.mDiagramData.getAllSymbols().size());
        for (DiagramSymbol s : this.mDiagramData.getAllSymbols()) {
            String id = s.getId();
            ITooltipProvider toolTipProvider = DiagramSymbolToolTipProviderFactory.create(s, config);
            if (toolTipProvider == null) continue;
            List<@NonNull Text> textElements = s.getAllTexts();
            for (Text text : textElements) {
                TextToolTipArea newTextToolTipArea = new TextToolTipArea(toolTipProvider, this.getToolTipAreaFor(text), text.getUUID());
                newTextToolTipArea.setSymbolId(id);
                toolTipAreas.add(newTextToolTipArea);
            }
            ToolTipArea newToolTipArea = new ToolTipArea(toolTipProvider, this.getToolTipAreaFor(s));
            newToolTipArea.setSymbolId(id);
            toolTipAreas.add(newToolTipArea);
        }
        this.mCanvas.setToolTips(toolTipAreas);
    }

    private @NonNull Rectangle getToolTipAreaFor(@NonNull DiagramSymbol symbol) {
        AffineTransform transform = this.getToCanvasTransform();
        Point2D tlc = transform.transform(symbol.getBoundingBoxDS().getTopLeftCornerDS(), null);
        Point2D brc = transform.transform(symbol.getBoundingBoxDS().getBottomRightCornerDS(), null);
        double width = brc.getX() - tlc.getX();
        double height = brc.getY() - tlc.getY();
        return new Rectangle((int)tlc.getX(), (int)tlc.getY(), (int)width, (int)height);
    }

    private @NonNull Rectangle getToolTipAreaFor(@NonNull Text text) {
        AffineTransform transform = this.getToCanvasTransform();
        Point2D tlc = transform.transform(text.getBoundingBoxDS().getTopLeftCornerDS(), null);
        Point2D brc = transform.transform(text.getBoundingBoxDS().getBottomRightCornerDS(), null);
        double width = brc.getX() - tlc.getX();
        double height = brc.getY() - tlc.getY();
        return new Rectangle((int)tlc.getX(), (int)tlc.getY(), (int)width, (int)height);
    }

    public void moveAndFillDiagram(boolean vertically) {
        int canvasLongerSideCS;
        int canvasShorterSideCS;
        int scrollBarOffset;
        ScrollBar sb;
        double diagramLongerSideDS;
        double diagramShorterSideDS;
        Point compositeSize = this.mComposite.getSize();
        BoundingBox bb = this.mDiagramBB_DS;
        if (vertically) {
            diagramShorterSideDS = bb.getHeight();
            diagramLongerSideDS = bb.getWidth();
            sb = this.mComposite.getHorizontalBar();
            scrollBarOffset = sb != null ? sb.getSize().y : 0;
            canvasShorterSideCS = compositeSize.y;
            canvasLongerSideCS = compositeSize.x;
        } else {
            diagramShorterSideDS = bb.getWidth();
            diagramLongerSideDS = bb.getHeight();
            sb = this.mComposite.getVerticalBar();
            scrollBarOffset = sb != null ? sb.getSize().x : 0;
            canvasShorterSideCS = compositeSize.x;
            canvasLongerSideCS = compositeSize.y;
        }
        double zoom = (double)canvasShorterSideCS / diagramShorterSideDS;
        double marginDS = 10.0 / zoom;
        scrollBarOffset = diagramLongerSideDS * zoom > (double)canvasLongerSideCS ? scrollBarOffset : 0;
        Point2D.Double offsetDS = new Point2D.Double(-bb.getTopLeftCornerDS().getX() + marginDS, -bb.getTopLeftCornerDS().getY() + marginDS);
        zoom = (double)(canvasShorterSideCS - scrollBarOffset) / (diagramShorterSideDS + 2.0 * marginDS);
        this.setDiagramOffset(offsetDS);
        this.setZoom(zoom *= 0.99, true);
    }

    public void updateCompositeSize() {
        try {
            int width;
            int height;
            if (this.mDiagramBB_DS == null) {
                Point p = this.mComposite.computeSize(-1, -1);
                height = p.y;
                width = p.x;
            } else {
                Point2D sizeDS = this.mDiagramBB_DS.getBottomRightCornerDS();
                Point2D sizeCS = this.getToCanvasTransform().transform(sizeDS, null);
                height = (int)(sizeCS.getY() + 20.0);
                width = (int)(sizeCS.getX() + 20.0);
            }
            this.mComposite.setMinSize(width, height);
            if (!(this.mExpanded || width == 0 && height == 0)) {
                this.expandCanvas();
            }
        }
        catch (SWTException e) {
            LOGGER.log(Level.WARNING, "Can't update main diagram composite size due to unexpected user action.", e);
        }
    }

    private void expandCanvas() {
        ScrolledComposite composite = this.mComposite;
        composite.setSize(composite.computeSize(-1, -1));
        while (!(composite instanceof Shell)) {
            composite = composite.getParent();
            composite.setSize(composite.computeSize(-1, -1));
        }
        this.mExpanded = true;
    }

    public static void appendElementModifiers(@NonNull IClockElement element, @NonNull IClocksConfig config, @NonNull StringBuilder stringBuilder) {
        block3: {
            block4: {
                List<ISetting> settings;
                block2: {
                    settings = element.getSettings(SettingType.FREQUENCY_GATE, SettingType.FREQUENCY_MODIFIER);
                    if (!(element instanceof FnPll)) break block2;
                    FnPll fractionalPllElement = (FnPll)element;
                    DiagramCanvas.createFnPllScale(config, fractionalPllElement, stringBuilder);
                    break block3;
                }
                if (settings.isEmpty()) break block4;
                for (ISetting setting : settings) {
                    SettingValue value = config.getSettingsConfig().getSettingValue(setting);
                    stringBuilder.append(SettingEditorHelper.getUiValueToShow(setting, value));
                    stringBuilder.append(" ");
                }
                break block3;
            }
            List<@NonNull IClockElement> internalElements = element.getInternalElements();
            if (internalElements == null) break block3;
            for (IClockElement internalElement : internalElements) {
                DiagramCanvas.appendElementModifiers(internalElement, config, stringBuilder);
            }
        }
    }

    protected void calculateDiagramBB() {
        BoundingBox bBox = new BoundingBox();
        for (DiagramSymbol symbol : this.mDiagramData.getTopLevelSymbols()) {
            bBox = bBox.merge(symbol.calculateMaxBoundingBoxDS());
        }
        this.mDiagramBB_DS = bBox;
    }

    public @NonNull CanvasWithToolTips getCanvas() {
        return this.mCanvas;
    }

    public @NonNull DiagramData getDiagramData() {
        return this.mDiagramData;
    }

    public void setWorkingConfig(@Nullable IClocksConfig config) {
        this.mSetConfig = config;
    }

    public @Nullable IClocksConfig getWorkingConfig() {
        return this.mSetConfig != null ? this.mSetConfig : GuiController.getInstance().getProfile().getActiveConfig();
    }

    public @Nullable HitInfo computeHitInfo(int x, int y) {
        return this.mPicker.computeHitInfo(new Point(x, y));
    }

    public void toggleSignalDirectionDrawing() {
        this.mDiagramStyleProvider.toggleSignalDirectionDrawing();
        this.draw();
    }

    private static /* synthetic */ void lambda$5(Control control, Event event) {
        control.dispose();
    }

    private static /* synthetic */ void lambda$6(Control control, ToolEvent event) {
        control.dispose();
    }

    private static /* synthetic */ void lambda$11(Control control, Event event) {
        control.dispose();
    }

    private static /* synthetic */ void lambda$12(Control control, ToolEvent event) {
        control.dispose();
    }

    protected class DrawListener
    implements PaintListener {
        protected DrawListener() {
        }

        public void paintControl(PaintEvent e) {
            assert (e != null);
            if (!DiagramCanvas.this.mCanvas.isVisible()) {
                return;
            }
            this.prepareCanvas(e);
            if (DiagramCanvas.this.mRecalculateDiagramSize) {
                DiagramCanvas.this.mRecalculateDiagramSize = false;
                DiagramCanvas.this.mDiagramData.getAllSymbols().forEach(symbol -> symbol.getAllTexts().forEach(Text::initialize));
                DiagramCanvas.this.calculateDiagramBB();
                DiagramCanvas.this.moveAndFillDiagram(false);
                return;
            }
            if (DiagramCanvas.this.mIsDirty) {
                DiagramCanvas.this.mDiagramStyleProvider.setLogging(true);
            }
            AffineTransform toCanvasTransform = DiagramCanvas.this.getToCanvasTransform();
            DiagramCanvas.this.mDiagramData.getTopLevelSymbols().forEach(x -> x.draw(toCanvasTransform, e, DiagramCanvas.this.mDiagramStyleProvider));
            if (DiagramCanvas.this.mIsDirty) {
                DiagramCanvas.this.mDiagramStyleProvider.setLogging(false);
                DiagramCanvas.this.mIsDirty = false;
            }
        }

        private void prepareCanvas(PaintEvent e) {
            Point size = DiagramCanvas.this.mCanvas.getSize();
            org.eclipse.swt.graphics.Color swtColorOrig = e.gc.getBackground();
            e.gc.setBackground(DiagramStyleProvider.getBgColor().getSWTColor());
            e.gc.fillRectangle(0, 0, size.x, size.y);
            if (swtColorOrig != null && !swtColorOrig.isDisposed()) {
                e.gc.setBackground(swtColorOrig);
            }
            e.gc.setAntialias(1);
        }
    }

    protected class MouseListener
    implements org.eclipse.swt.events.MouseListener {
        protected MouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            DiagramCanvas.this.mComposite.setFocus();
            GuiController guiController = GuiController.getInstance();
            HitInfo hitInfo = DiagramCanvas.this.computeHitInfo(e.x, e.y);
            String hitSymbol = hitInfo == null ? null : hitInfo.getId();
            boolean selectedBefore = Objects.equals(guiController.getSelectedElement(), hitSymbol);
            guiController.setSelectedElement(hitSymbol, DiagramCanvas.this);
            DiagramCanvas.this.clearNonLabels();
            IClocksConfig config = DiagramCanvas.this.getWorkingConfig();
            if (config != null && hitSymbol != null && hitInfo != null && e.button == 1) {
                DiagramCanvas.this.openEditingSupportFor(hitInfo, config, e.x + 1, e.y + 1, selectedBefore);
            }
        }

        public void mouseDown(MouseEvent e) {
            if (OSDetect.isMac()) {
                DiagramCanvas.this.mComposite.setFocus();
                HitInfo hitInfo = DiagramCanvas.this.computeHitInfo(e.x, e.y);
                GuiController.getInstance().setSelectedElement(hitInfo == null ? null : hitInfo.getId(), DiagramCanvas.this);
            }
        }
    }
}

