/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagram;

import com.nxp.swtools.clocks.ui.diagram.Junction;
import com.nxp.swtools.clocks.ui.diagram.XmlUtil;
import com.nxp.swtools.clocks.ui.diagramsymbols.Color;
import com.nxp.swtools.clocks.ui.diagramsymbols.CompositeSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.DrawState;
import com.nxp.swtools.clocks.ui.diagramsymbols.Fill;
import com.nxp.swtools.clocks.ui.diagramsymbols.Font;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.InvisibleConnectionSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.LineStyle;
import com.nxp.swtools.clocks.ui.diagramsymbols.Pin;
import com.nxp.swtools.clocks.ui.diagramsymbols.Polygon;
import com.nxp.swtools.clocks.ui.diagramsymbols.Rectangle;
import com.nxp.swtools.clocks.ui.diagramsymbols.SymbolBuilder;
import com.nxp.swtools.clocks.ui.diagramsymbols.Text;
import com.nxp.swtools.clocks.ui.diagramsymbols.TextField;
import com.nxp.swtools.clocks.ui.diagramsymbols.Wire;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.files.XmlDomProvider;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DiagramLoader {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(DiagramLoader.class);
    @NonNull
    protected File mFile;
    @NonNull
    protected @NonNull List<@NonNull DiagramSymbol> mSymbols;
    @NonNull
    protected @NonNull List<@NonNull InvisibleConnectionSymbol> mInputTeleports;
    @NonNull
    protected @NonNull List<@NonNull InvisibleConnectionSymbol> mOutputTeleports;
    @NonNull
    protected Map<String, SymbolBuilder> mSymbolDefMap;
    @NonNull
    protected Map<String, LineStyle> mLineStyleMap;
    @NonNull
    protected Map<String, Font> mFontMap;
    @NonNull
    protected Map<String, Fill> mFillMap;
    @NonNull
    protected XPath mXPath;
    @NonNull
    private static final String BOUNDARY = "Boundary";
    @NonNull
    public static final String TYPE = "Type";
    @NonNull
    private static final String DIAGRAM_ONLY = "Diagram_only";
    @NonNull
    protected static final String ROTATE = "rotate";
    @NonNull
    protected static final String RECTANGLE = "RECTANGLE";
    @NonNull
    protected static final String PIN = "PIN";
    @NonNull
    protected static final String POLYGON = "POLYGON";
    @NonNull
    protected static final String ORIGIN = "ORIGIN";
    @NonNull
    protected static final String HEIGHT = "HEIGHT";
    @NonNull
    protected static final String FACENAME = "FACENAME";
    @NonNull
    protected static final String ID = "id";
    @NonNull
    protected static final String POS = "pos";
    @NonNull
    protected static final String FIELD = "FIELD";
    @NonNull
    protected static final String IGNORE_FIELD = "$$";
    @NonNull
    public static final String DESCRIPTION = "description";
    @NonNull
    protected static final String VALUE = "value";
    @NonNull
    public static final String NAME = "Name";
    @NonNull
    protected static final String TELEPORT = "Teleport";
    @NonNull
    protected static final String IN = "IN";
    @NonNull
    protected static final String OUT = "OUT";
    @NonNull
    protected static final String SHOW = "show";
    @NonNull
    protected static final String COLOR = "COLOR";
    @NonNull
    protected static final String FONT = "font";
    @NonNull
    public static final String WIRES_ID = "Wires";
    @NonNull
    public static final String TEXTS_ID = "Texts";
    @NonNull
    public static final String JUNCTIONS_ID = "Junctions";
    @NonNull
    public static final String RECTANGLES_ID = "Rectangles";
    @NonNull
    public static final String OUTPUT_FREQ = "{{OUT_F}}";
    @NonNull
    public static final String CMU_FREQ = "{{CMU_FREQ}}";
    @NonNull
    protected static final String SCALE = "{{SCALE}}";
    @NonNull
    protected static final String SCALE_Y = "scale_y";
    @NonNull
    protected static final String SCALE_X = "scale_x";
    @NonNull
    protected static final String NUM_ONE = "1";
    @NonNull
    protected static final String THICKNESS = "THICKNESS";
    @NonNull
    protected static final String STYLE = "STYLE";
    @NonNull
    protected static final String INDEX = "INDEX";
    @NonNull
    public static final String REF = "Ref";
    @NonNull
    protected static final String B_CHAR = "b";
    @NonNull
    protected static final String A_CHAR = "a";
    @NonNull
    protected static final String DIRECTION = "direction";
    @NonNull
    protected static final String WHICH = "which";
    @NonNull
    protected static final String LENGTH = "length";
    @NonNull
    protected static final String POINT = "POINT";
    @NonNull
    protected static final String COMMA = ",";
    @NonNull
    protected static final String REF_POINT = "REF_POINT";
    @NonNull
    protected static final String YES = "yes";
    @NonNull
    private static final String CLOCKSLICES = "clock_slices";
    @NonNull
    private static final String VISIBLE = "Visible";
    @NonNull
    private static final String TRUE = "true";

    public DiagramLoader(@NonNull File file) {
        this.mFile = file;
        this.mSymbols = new ArrayList<DiagramSymbol>();
        this.mInputTeleports = new ArrayList<InvisibleConnectionSymbol>();
        this.mOutputTeleports = new ArrayList<InvisibleConnectionSymbol>();
        this.mSymbolDefMap = new TreeMap<String, SymbolBuilder>();
        this.mLineStyleMap = new TreeMap<String, LineStyle>();
        this.mFillMap = new TreeMap<String, Fill>();
        this.mFontMap = new TreeMap<String, Font>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        assert (xpath != null);
        this.mXPath = xpath;
    }

    public @NonNull List<@NonNull DiagramSymbol> load() throws IllegalArgumentException {
        if (!this.mFile.exists()) {
            LOGGER.severe("File " + this.mFile.getAbsolutePath() + " does not exists. Empty diagram will be used instead.");
            return this.mSymbols;
        }
        try {
            this.parse();
        }
        catch (IOException | XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
        this.processTeleports();
        return this.mSymbols;
    }

    private void processTeleports() {
        for (InvisibleConnectionSymbol sIn : this.mInputTeleports) {
            for (InvisibleConnectionSymbol sOut : this.mOutputTeleports) {
                sIn.merge(sOut);
            }
            this.mSymbols.add(sIn);
        }
        for (InvisibleConnectionSymbol sOut : this.mOutputTeleports) {
            this.mSymbols.add(sOut);
        }
    }

    private void parse() throws IOException, XPathExpressionException {
        Document doc = XmlDomProvider.getAsW3CDom((InputStream)UtilsDecryption.getFileInputStream((File)this.mFile), (String)this.mFile.getAbsolutePath(), null);
        if (doc == null) {
            throw new IllegalArgumentException("Fail on parsing: " + this.mFile.getAbsolutePath());
        }
        doc.normalize();
        XPathExpression styleExpr = this.mXPath.compile("/TinyCADSheets/TinyCAD/STYLE");
        NodeList styles = (NodeList)styleExpr.evaluate(doc, XPathConstants.NODESET);
        for (Node n : XmlUtil.asList(styles)) {
            Element e = (Element)XmlUtil.detach(n);
            assert (e != null);
            this.parseLineStyle(e);
        }
        XPathExpression fillExpr = this.mXPath.compile("/TinyCADSheets/TinyCAD/FILL");
        NodeList fills = (NodeList)fillExpr.evaluate(doc, XPathConstants.NODESET);
        for (Node n : XmlUtil.asList(fills)) {
            Element e = (Element)XmlUtil.detach(n);
            assert (e != null);
            this.parseFill(e);
        }
        XPathExpression fontExpr = this.mXPath.compile("/TinyCADSheets/TinyCAD/FONT");
        NodeList fonts = (NodeList)fontExpr.evaluate(doc, XPathConstants.NODESET);
        for (Node n : XmlUtil.asList(fonts)) {
            Element e = (Element)XmlUtil.detach(n);
            assert (e != null);
            this.parseFont(e);
        }
        XPathExpression symbolDefExpr = this.mXPath.compile("/TinyCADSheets/TinyCAD/SYMBOLDEF");
        NodeList symbolDefs = (NodeList)symbolDefExpr.evaluate(doc, XPathConstants.NODESET);
        for (Node n : XmlUtil.asList(symbolDefs)) {
            this.parseSymbolDef(XmlUtil.detach(n));
        }
        XPathExpression symbolExpr = this.mXPath.compile("/TinyCADSheets/TinyCAD/SYMBOL");
        NodeList symbols = (NodeList)symbolExpr.evaluate(doc, XPathConstants.NODESET);
        for (Node n : XmlUtil.asList(symbols)) {
            this.parseSymbol(XmlUtil.detach(n));
        }
        CompositeSymbol textSymbol = new CompositeSymbol(TEXTS_ID, false, false, false, false);
        XPathExpression textExpr = this.mXPath.compile("/TinyCADSheets/TinyCAD/TEXT");
        NodeList texts = (NodeList)textExpr.evaluate(doc, XPathConstants.NODESET);
        for (Node n : XmlUtil.asList(texts)) {
            this.parseText(textSymbol, XmlUtil.detach(n));
        }
        if (!textSymbol.getGraphElems().isEmpty()) {
            this.mSymbols.add(textSymbol);
        }
        CompositeSymbol wireSymbol = new CompositeSymbol(WIRES_ID, false, false, true, false);
        XPathExpression wiresExpr = this.mXPath.compile("/TinyCADSheets/TinyCAD/WIRE");
        NodeList wires = (NodeList)wiresExpr.evaluate(doc, XPathConstants.NODESET);
        for (Node n : XmlUtil.asList(wires)) {
            this.parseWire(wireSymbol, XmlUtil.detach(n));
        }
        this.mSymbols.add(wireSymbol);
        CompositeSymbol junctionSymbol = new CompositeSymbol(JUNCTIONS_ID, false, false, true, false);
        XPathExpression junctionExpr = this.mXPath.compile("/TinyCADSheets/TinyCAD/JUNCTION");
        NodeList junctions = (NodeList)junctionExpr.evaluate(doc, XPathConstants.NODESET);
        for (Node n : XmlUtil.asList(junctions)) {
            this.parseJunction(junctionSymbol, XmlUtil.detach(n));
        }
        this.mSymbols.add(junctionSymbol);
        CompositeSymbol rectangleSymbol = new CompositeSymbol(RECTANGLES_ID, true, false, true, false);
        XPathExpression rectangleExpr = this.mXPath.compile("/TinyCADSheets/TinyCAD/RECTANGLE");
        NodeList rectangles = (NodeList)rectangleExpr.evaluate(doc, XPathConstants.NODESET);
        for (Node n : XmlUtil.asList(rectangles)) {
            Element e = (Element)XmlUtil.detach(n);
            assert (e != null);
            GraphicalElement rec = this.parseRectangle(e, true);
            if (rec == null) continue;
            rectangleSymbol.addGraphElem(rec);
        }
        if (!rectangleSymbol.getGraphElems().isEmpty()) {
            this.mSymbols.add(rectangleSymbol);
        }
    }

    private void parseText(@NonNull CompositeSymbol symbol, @NonNull Node n) {
        Element e = (Element)n;
        String fontId = e.getAttribute(FONT);
        Font font = Objects.requireNonNull(this.mFontMap.get(fontId)).makeCopy();
        assert (font != null);
        Point2D pos = this.parsePoint(e.getAttribute(POS));
        Color color = DiagramLoader.parseColor(e.getAttribute(COLOR.toLowerCase()));
        font.setColor(color);
        String text = e.getTextContent();
        assert (text != null);
        symbol.addGraphElem(new Text(pos, text, font));
    }

    protected void parseSymbol(@NonNull Node n) throws XPathExpressionException {
        Element e = (Element)n;
        String symbolDefId = e.getAttribute(ID);
        SymbolBuilder builder = this.mSymbolDefMap.get(symbolDefId);
        if (builder != null) {
            String id = DiagramLoader.parseSymbolId(e);
            Point2D position = this.parsePoint(e.getAttribute(POS));
            DiagramSymbol.Orientation orientation = DiagramSymbol.Orientation.values()[Integer.parseInt(e.getAttribute(ROTATE))];
            assert (orientation != null);
            Point2D scale = DiagramLoader.parseScale(e);
            XPathExpression fieldsExpr = this.mXPath.compile(FIELD);
            NodeList fieldsList = (NodeList)fieldsExpr.evaluate(n, XPathConstants.NODESET);
            boolean definesBoundary = DiagramLoader.isBoundary(fieldsList);
            boolean isClockSlices = DiagramLoader.isClockSlices(fieldsList);
            boolean isDiagramOnly = definesBoundary || isClockSlices || DiagramLoader.isDiagramOnly(fieldsList);
            Map<@NonNull String, @NonNull TextField> fields = this.parseSymbolFields(fieldsList);
            TextField outputFreq = null;
            for (Map.Entry<String, TextField> entry : fields.entrySet()) {
                if (!entry.getValue().getText().equals(OUTPUT_FREQ)) continue;
                outputFreq = entry.getValue();
                fields.remove(entry.getKey());
                break;
            }
            TextField scaleField = null;
            for (Map.Entry<String, TextField> entry : fields.entrySet()) {
                if (!entry.getValue().getText().equals(SCALE)) continue;
                scaleField = entry.getValue();
                fields.remove(entry.getKey());
                break;
            }
            TextField cmuFreq = null;
            for (Map.Entry<String, TextField> entry : fields.entrySet()) {
                if (!entry.getValue().getText().equals(CMU_FREQ)) continue;
                cmuFreq = entry.getValue();
                fields.remove(entry.getKey());
                break;
            }
            Optional<Boolean> isInputTeleport = DiagramLoader.definesTeleport(fieldsList);
            if (isInputTeleport.isPresent()) {
                boolean input = isInputTeleport.get();
                boolean isVisible = DiagramLoader.isVisible(fieldsList);
                InvisibleConnectionSymbol symbol = builder.getInvisibleConnectionSymbol(id, position, orientation, scale, fields, input, isVisible);
                if (input) {
                    this.mInputTeleports.add(symbol);
                } else {
                    this.mOutputTeleports.add(symbol);
                }
            } else {
                this.mSymbols.add(builder.getCompositeSymbol(id, position, orientation, scale, fields, outputFreq, scaleField, cmuFreq, definesBoundary, isDiagramOnly, isClockSlices));
            }
        } else {
            LOGGER.severe("Could not find symbol definition with ID=" + symbolDefId);
        }
    }

    private static boolean isBoundary(@Nullable NodeList fields) {
        for (Node n : XmlUtil.asList(fields)) {
            Element e = (Element)n;
            Assert.isNotNull((Object)e);
            String description = e.getAttribute(DESCRIPTION);
            String text = e.getAttribute(VALUE);
            if (!description.equals(TYPE) || !text.equals(BOUNDARY)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDiagramOnly(@Nullable NodeList fields) {
        for (Node n : XmlUtil.asList(fields)) {
            Element e = (Element)n;
            Assert.isNotNull((Object)e);
            String description = e.getAttribute(DESCRIPTION);
            String text = e.getAttribute(VALUE);
            if (!description.equals(DIAGRAM_ONLY) || !text.equals(YES)) continue;
            return true;
        }
        return false;
    }

    private static boolean isClockSlices(@Nullable NodeList fields) {
        for (Node n : XmlUtil.asList(fields)) {
            Element e = (Element)n;
            Assert.isNotNull((Object)e);
            String description = e.getAttribute(DESCRIPTION);
            String text = e.getAttribute(VALUE);
            if (!description.equals(TYPE) || !text.equals(CLOCKSLICES)) continue;
            return true;
        }
        return false;
    }

    private static @NonNull Optional<Boolean> definesTeleport(@Nullable NodeList fields) {
        Optional<Boolean> result;
        boolean isTeleport = false;
        Boolean isInput = null;
        for (Node n : XmlUtil.asList(fields)) {
            Element e = (Element)n;
            Assert.isNotNull((Object)e);
            String description = e.getAttribute(DESCRIPTION);
            String value = e.getAttribute(VALUE);
            if (description.equals(NAME) && value.startsWith(TELEPORT)) {
                isTeleport = true;
            }
            if (description.equals(TYPE) && value.equals(IN)) {
                isInput = Boolean.TRUE;
            }
            if (!description.equals(TYPE) || !value.equals(OUT)) continue;
            isInput = Boolean.FALSE;
        }
        Optional<Object> optional = result = isTeleport ? Optional.of(isInput) : Optional.empty();
        assert (result != null);
        return result;
    }

    private static boolean isVisible(@Nullable NodeList fields) {
        for (Node n : XmlUtil.asList(fields)) {
            Element e = (Element)n;
            Assert.isNotNull((Object)e);
            String description = e.getAttribute(DESCRIPTION);
            String text = e.getAttribute(VALUE);
            if (!description.equals(VISIBLE) || !text.equals(TRUE)) continue;
            return true;
        }
        return false;
    }

    private static @NonNull Point2D parseScale(@NonNull Element e) {
        double x = 1.0;
        double y = 1.0;
        String xStr = e.getAttribute(SCALE_X);
        String yStr = e.getAttribute(SCALE_Y);
        try {
            x = Double.parseDouble(xStr);
            y = Double.parseDouble(yStr);
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.SEVERE, "Error while parsing number. Default value '1' will be used instead.", ex);
        }
        return new Point2D.Double(x, y);
    }

    private void parseLineStyle(@NonNull Element e) throws XPathExpressionException {
        XPathExpression styleExpr = this.mXPath.compile(STYLE);
        Element styleElem = (Element)styleExpr.evaluate(e, XPathConstants.NODE);
        int style = Integer.parseInt(styleElem.getTextContent());
        XPathExpression colorExpr = this.mXPath.compile(COLOR);
        Element colorElem = (Element)colorExpr.evaluate(e, XPathConstants.NODE);
        Color color = DiagramLoader.parseColor(colorElem.getTextContent());
        XPathExpression thicknessExpr = this.mXPath.compile(THICKNESS);
        Element thicknessElem = (Element)thicknessExpr.evaluate(e, XPathConstants.NODE);
        int thickness = Integer.parseInt(thicknessElem.getTextContent());
        LineStyle.Style lineStyle = LineStyle.Style.values()[style];
        assert (lineStyle != null);
        LineStyle result = new LineStyle(lineStyle, thickness, color);
        this.mLineStyleMap.put(e.getAttribute(ID), result);
    }

    private void parseFill(@NonNull Element e) throws XPathExpressionException {
        XPathExpression indexExpr = this.mXPath.compile(INDEX);
        Element indexElem = (Element)indexExpr.evaluate(e, XPathConstants.NODE);
        int index = Integer.parseInt(indexElem.getTextContent());
        XPathExpression colorExpr = this.mXPath.compile(COLOR);
        Element colorElem = (Element)colorExpr.evaluate(e, XPathConstants.NODE);
        Color color = DiagramLoader.parseColor(colorElem.getTextContent());
        Fill fill = new Fill(-1 == index, color);
        this.mFillMap.put(e.getAttribute(ID), fill);
    }

    private void parseFont(@NonNull Element e) throws XPathExpressionException {
        XPathExpression heightExpr = this.mXPath.compile(HEIGHT);
        Element heightElem = (Element)heightExpr.evaluate(e, XPathConstants.NODE);
        int height = Integer.parseInt(heightElem.getTextContent());
        if (height < 0) {
            height *= -1;
        }
        XPathExpression fontExpr = this.mXPath.compile(FACENAME);
        Element fontElem = (Element)fontExpr.evaluate(e, XPathConstants.NODE);
        String fontName = fontElem.getTextContent();
        assert (fontName != null);
        this.mFontMap.put(e.getAttribute(ID), new Font(fontName, height));
    }

    private static @NonNull Color parseColor(@Nullable String color) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (color == null) {
            LOGGER.warning("Cannot create color from null string. Default values will be used.");
        } else {
            b = Integer.parseInt(color.substring(0, 2), 16);
            g = Integer.parseInt(color.substring(2, 4), 16);
            r = Integer.parseInt(color.substring(4, 6), 16);
        }
        return new Color(r, g, b);
    }

    private static @NonNull String parseSymbolId(@NonNull Element e) {
        String id = "";
        for (Node n : XmlUtil.asList(e.getChildNodes())) {
            Node description;
            NamedNodeMap attribs;
            if (!n.hasAttributes() || (attribs = n.getAttributes()) == null || !REF.equals((description = attribs.getNamedItem(DESCRIPTION)).getTextContent())) continue;
            id = attribs.getNamedItem(VALUE).getTextContent();
            assert (id != null);
            break;
        }
        return id;
    }

    private @NonNull Map<@NonNull String, @NonNull TextField> parseSymbolFields(@Nullable NodeList list) {
        HashMap<@NonNull String, @NonNull TextField> map = new HashMap<String, TextField>();
        for (Node n : XmlUtil.asList(list)) {
            Element e = (Element)n;
            Assert.isNotNull((Object)e);
            String description = e.getAttribute(DESCRIPTION);
            boolean show = NUM_ONE.equals(e.getAttribute(SHOW));
            String text = e.getAttribute(VALUE);
            if (!show || description.contains(IGNORE_FIELD) || text.equals("")) continue;
            Point2D loc = this.parsePoint(e.getAttribute(POS));
            loc.setLocation(loc.getX(), loc.getY());
            TextField textField = new TextField(description, loc, text);
            map.put(description, textField);
        }
        return map;
    }

    private void parseWire(@NonNull CompositeSymbol symbol, @NonNull Node n) {
        NamedNodeMap attribs = n.getAttributes();
        if (attribs != null) {
            Point2D start = this.parsePoint(attribs.getNamedItem(A_CHAR).getTextContent());
            Point2D end = this.parsePoint(attribs.getNamedItem(B_CHAR).getTextContent());
            symbol.addGraphElem(new Wire(start, end));
        }
    }

    private void parseSymbolDef(@NonNull Node n) throws XPathExpressionException, NumberFormatException {
        String id;
        NamedNodeMap attribs = n.getAttributes();
        String string = id = attribs == null ? null : attribs.getNamedItem(ID).getTextContent();
        if (id != null) {
            XPathExpression refPointExpr = this.mXPath.compile(REF_POINT);
            Element refPoint = (Element)refPointExpr.evaluate(n, XPathConstants.NODE);
            Point2D refPointPos = this.parsePoint(refPoint.getAttribute(POS));
            SymbolBuilder sb = new SymbolBuilder(refPointPos);
            XPathExpression symbolDefExpr = this.mXPath.compile("TinyCAD/*");
            NodeList grafElems = (NodeList)symbolDefExpr.evaluate(n, XPathConstants.NODESET);
            for (Node node : XmlUtil.asList(grafElems)) {
                Element elem = (Element)XmlUtil.detach(node);
                Assert.isNotNull((Object)elem);
                String elemType = elem.getNodeName();
                GraphicalElement result = null;
                if (RECTANGLE.equals(elemType)) {
                    result = this.parseRectangle(elem, false);
                }
                if (PIN.equals(elemType)) {
                    result = this.parsePin(elem);
                }
                if (POLYGON.equals(elemType)) {
                    result = this.parsePolygon(elem, false);
                }
                if (result != null) {
                    sb.addGraphElem(result);
                    continue;
                }
                if (ORIGIN.equals(elemType)) continue;
                LOGGER.warning("Symbol definition with ID=" + id + " contains unsupported graphical elements.");
            }
            this.mSymbolDefMap.put(id, sb);
        }
    }

    protected @NonNull Point2D parsePoint(@Nullable String loc) {
        double x = 0.0;
        double y = 0.0;
        if (loc == null) {
            LOGGER.warning("Cannot create Point from null String. Default values will be used.");
        } else {
            try {
                x = Double.parseDouble(loc.split(COMMA)[0]);
                y = Double.parseDouble(loc.split(COMMA)[1]);
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.SEVERE, "Error while parsing number", ex);
            }
        }
        return new Point2D.Double(x, y);
    }

    protected @Nullable GraphicalElement parsePolygon(@NonNull Element e, boolean definesSubcomponent) {
        Point2D refPoint = this.parsePoint(e.getAttribute(POS));
        ArrayList<@NonNull Point2D> corners = new ArrayList<Point2D>();
        for (Node pointNode : XmlUtil.asList(e.getElementsByTagName(POINT))) {
            Element pointElem = (Element)pointNode;
            Point2D point = this.parsePoint(pointElem.getAttribute(POS));
            assert (point != null);
            point.setLocation(point.getX() + refPoint.getX(), point.getY() + refPoint.getY());
            corners.add(point);
        }
        Polygon poly = new Polygon(corners);
        if (definesSubcomponent) {
            poly.update(DrawState.State.BOUNDARY_FLAG);
        }
        return poly;
    }

    protected @Nullable GraphicalElement parseRectangle(@NonNull Element e, boolean definesSubcomponent) {
        Point2D topLeftCorner = this.parsePoint(e.getAttribute(A_CHAR));
        Point2D bottomRightCorner = this.parsePoint(e.getAttribute(B_CHAR));
        Rectangle rec = new Rectangle(topLeftCorner, bottomRightCorner);
        if (definesSubcomponent) {
            rec.update(DrawState.State.BOUNDARY_FLAG);
        }
        return rec;
    }

    protected @Nullable GraphicalElement parsePin(@NonNull Element e) {
        double SIZE_CONSTANT = 5.0;
        Point2D origin = this.parsePoint(e.getAttribute(POS));
        double size = (double)Float.parseFloat(e.getAttribute(LENGTH)) / SIZE_CONSTANT;
        Pin.Type type = Pin.Type.values()[Integer.parseInt(e.getAttribute(WHICH))];
        Pin.Direction dir = Pin.Direction.values()[Integer.parseInt(e.getAttribute(DIRECTION))];
        assert (type != null);
        assert (dir != null);
        String textContent = e.getTextContent();
        boolean input = UtilsText.isEmpty((String)textContent) || Objects.requireNonNull(textContent).startsWith(IN);
        return new Pin(origin, dir, size, type, input);
    }

    protected void parseJunction(@NonNull CompositeSymbol symbol, @NonNull Node n) {
        NamedNodeMap attribs = n.getAttributes();
        Point2D pos = this.parsePoint(attribs == null ? null : attribs.getNamedItem(POS).getTextContent());
        symbol.addGraphElem(new Junction(pos));
    }
}

