/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.HitInfo;
import com.nxp.swtools.clocks.ui.diagramsymbols.Pin;
import com.nxp.swtools.clocks.ui.diagramsymbols.Wire;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.events.PaintEvent;

public class InvisibleConnectionSymbol
extends DiagramSymbol {
    @NonNull
    protected @NonNull List<@NonNull Wire> mInvWires;
    @NonNull
    Pin mConnectionPin;
    @NonNull
    Pin mOutputPin;
    boolean isInput;
    boolean visible = false;

    public InvisibleConnectionSymbol(@NonNull String id, @NonNull Pin connectionPin, boolean isInput, boolean isVisible) {
        super(id, true);
        this.isInput = isInput;
        this.mInvWires = new ArrayList<Wire>();
        this.mConnectionPin = connectionPin;
        Pin pinToAdd = connectionPin.makeCopy();
        pinToAdd.mInput = false;
        this.mOutputPin = pinToAdd;
        this.visible = isVisible;
        this.addGraphElem(connectionPin);
        this.addGraphElem(pinToAdd);
    }

    protected void addConnection(@NonNull Point2D start, @NonNull Point2D end) {
        Wire w = new Wire(start, end);
        this.mInvWires.add(w);
        this.mGraphElems.add(w);
    }

    @Override
    public void draw(AffineTransform transform, PaintEvent e, DiagramStyleProvider styleProvider) {
        for (GraphicalElement x : this.mGraphElems) {
            if (this.mInvWires.contains(x) || !this.visible && Objects.equals(x, this.mConnectionPin) || Objects.equals(x, this.mOutputPin)) continue;
            x.draw(transform, e, styleProvider);
        }
    }

    public void merge(InvisibleConnectionSymbol output) {
        if (this.getId().equals(output.getId())) {
            this.addConnection(this.mConnectionPin.mEndDS, output.mConnectionPin.mStartDS);
        }
    }

    @Override
    public @Nullable HitInfo computeHitInfo(@NonNull Point2D p) {
        return null;
    }

    public @NonNull Pin getInputPin() {
        return this.mConnectionPin;
    }

    @Override
    public @NonNull InvisibleConnectionSymbol makeCopy() {
        InvisibleConnectionSymbol copy = new InvisibleConnectionSymbol(this.mId, this.mConnectionPin.makeCopy(), this.isInput, this.visible);
        this.mInvWires.forEach(x -> copy.addConnection(x.getStartDS(), x.getEndDS()));
        this.mGraphElems.forEach(x -> {
            if (!(this.mInvWires.contains(x) || Objects.equals(x, this.mConnectionPin) || Objects.equals(x, this.mOutputPin))) {
                copy.addGraphElem((GraphicalElement)x);
            }
        });
        return copy;
    }

    public @NonNull Pin getOutputPin() {
        return this.mOutputPin;
    }

    public boolean isInput() {
        return this.isInput;
    }

    @Override
    public @NonNull String getId() {
        return this.mId;
    }
}

