/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.table;

import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.ui.table.ISettingNode;
import com.nxp.swtools.clocks.ui.table.SettingsInput;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SettingNode
implements ISettingNode {
    @NonNull
    private String id;
    @NonNull
    private ISettingNode @Nullable [] settings;
    @Nullable
    private ISettingNode parent;
    @Nullable
    private ISetting setting;

    public SettingNode(@NonNull ISetting setting, @NonNull ISettingNode @Nullable [] settings) {
        this(setting.getId(), settings);
        this.setting = setting;
    }

    public SettingNode(@NonNull String id, @NonNull ISettingNode @Nullable [] settings) {
        this.id = id;
        this.settings = settings;
        if (settings != null) {
            ISettingNode[] iSettingNodeArray = settings;
            int n = settings.length;
            int n2 = 0;
            while (n2 < n) {
                ISettingNode child = iSettingNodeArray[n2];
                child.setParent(this);
                ++n2;
            }
        }
    }

    public SettingNode(@NonNull String id, @NonNull ISetting setting, @NonNull ISettingNode @Nullable [] settings) {
        this(id, settings);
        this.setting = setting;
    }

    @Override
    public @NonNull ISettingNode @Nullable [] getChildren() {
        return this.settings;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ISettingNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ISettingNode parent) {
        this.parent = parent;
    }

    @Override
    public @Nullable ISetting getSetting() {
        return this.setting;
    }

    @Override
    public @Nullable IClockElement getClockElement() {
        if (this.setting != null) {
            IElement settingElement = this.setting.getElement();
            if (settingElement instanceof IClockElement) {
                return (IClockElement)settingElement;
            }
            if (this.parent != null) {
                return this.parent.getClockElement();
            }
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parent);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SettingNode other = (SettingNode)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.parent, other.parent);
    }

    @Override
    public boolean isIdentical(@NonNull ISettingNode other) {
        if (this.getClass() != other.getClass() || !Objects.equals(this.id, other.getId()) || this.setting != other.getSetting()) {
            return false;
        }
        @NonNull ISettingNode[] otherChildren = other.getChildren();
        @NonNull ISettingNode[] settingsLoc = this.settings;
        if (settingsLoc == null) {
            return otherChildren == null;
        }
        if (otherChildren == null) {
            return false;
        }
        if (settingsLoc.length != otherChildren.length) {
            return false;
        }
        int i = 0;
        while (i < settingsLoc.length) {
            if (!settingsLoc[i].isIdentical(otherChildren[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static class Builder {
        @Nullable
        private ISetting setting;
        @Nullable
        private String id;
        @NonNull
        private @NonNull List<@NonNull ISettingNode> children = new ArrayList<ISettingNode>();

        public Builder(@NonNull String id, @NonNull ISetting setting) {
            this.id = id;
            this.setting = setting;
        }

        public Builder(@NonNull ISetting setting) {
            this.setting = setting;
        }

        public Builder(@NonNull String id) {
            this.id = id;
        }

        public Builder addChildren(@NonNull Collection<@NonNull ISettingNode> childs) {
            this.children.addAll(childs);
            return this;
        }

        public Builder addChild(@NonNull ISettingNode child) {
            this.children.add(child);
            return this;
        }

        public @NonNull SettingNode build() {
            String nameLoc = this.id;
            ISetting settingLoc = this.setting;
            if (nameLoc != null) {
                if (settingLoc != null) {
                    return new SettingNode(nameLoc, settingLoc, SettingsInput.toArray(this.children));
                }
                return new SettingNode(nameLoc, SettingsInput.toArray(this.children));
            }
            assert (settingLoc != null);
            return new SettingNode(settingLoc, SettingsInput.toArray(this.children));
        }
    }
}

