/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.utils;

import com.nxp.swtools.clocks.model.FrequencyRange;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.clocks.utils.ParenthesesType;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;

public class Text {
    @NonNull
    public static final String QUOTE = "\"";
    @NonNull
    public static final String PLUS_MINUS = "\u00b1";
    @NonNull
    public static final String TRUE = Boolean.TRUE.toString();
    @NonNull
    public static final String FALSE = Boolean.FALSE.toString();
    @NonNull
    public static final String NL = "\n";
    @NonNull
    public static final String NL_REGEX = "\\n";
    @NonNull
    public static final String EMPTY = "";
    @NonNull
    public static final String SPACE = " ";
    @NonNull
    public static final String REGEX_EMPTY_SPACE = "\\s+";
    @NonNull
    public static final String OPENING_BRACKET = "(";
    @NonNull
    public static final String CLOSING_BRACKET = ")";
    @NonNull
    public static final String OPENING_CURLY_BRACKET = "{";
    @NonNull
    public static final String CLOSING_CURLY_BRACKET = "}";
    @NonNull
    public static final String OPENING_ANGLE_BRACKET = "<";
    @NonNull
    public static final String CLOSING_ANGLE_BRACKET = ">";
    @NonNull
    public static final String OPENING_SQUARE_BRACKET = "[";
    @NonNull
    public static final String CLOSING_SQUARE_BRACKET = "]";
    @NonNull
    public static final String LOGICAL_EQUALS = "==";
    @NonNull
    public static final String LOGICAL_OR = "||";
    @NonNull
    public static final String LOGICAL_AND = "&&";
    @NonNull
    public static final String POWER_MODE = "powerMode";
    @NonNull
    public static final String DOT = ".";
    @NonNull
    public static final String COMMA = ",";
    @NonNull
    public static final String COLON = ":";
    @NonNull
    public static final String SEMICOLON = ";";
    @NonNull
    public static final String PERIPHERAL_SEPARATOR = "::";
    @NonNull
    public static final String REGEX_EVERYTHING_AFTER = ".*";
    @NonNull
    public static final String DOUBLE_BACKSLASH = "\\";
    @NonNull
    public static final String REGEX_EVERYTHING_AFTER_DOT = "\\..*";
    @NonNull
    public static final String PERCENT = "%";
    @NonNull
    public static final String BACK_QUOTE = "`";
    @NonNull
    public static final String TAB = "\t";
    @NonNull
    public static final String REGEX_EOL = "$";
    @NonNull
    public static final String INTERVAL_SEPARATOR = "..";
    @NonNull
    public static final String SLASH = "/";
    @NonNull
    public static final String ASTERISK = "*";
    @NonNull
    public static final String EXT_C = ".c";
    @NonNull
    public static final String DOLLAR = "$";
    @NonNull
    public static final String ELLIPSIS = "...";
    @NonNull
    public static final String AT_SIGN = "@";
    @NonNull
    public static final String MINUS = "-";

    public static <T> @NonNull String collectionToString(@NonNull Collection<T> collection) {
        return CollectionsUtils.formatList(collection, (String)", ", null);
    }

    public static @NonNull String accuracyToPercent(@NonNull BigRational accuracy) {
        BigRational accuracyPercent = accuracy.multiply(100);
        String number = accuracyPercent.toExactDecimalString();
        return PLUS_MINUS + number + PERCENT;
    }

    public static @NonNull String getComponentID(@NonNull String elementID) {
        int dotIdx = elementID.indexOf(46);
        if (dotIdx >= 0) {
            return elementID.substring(0, dotIdx);
        }
        return elementID;
    }

    public static @Nullable String replaceNewLinesWithSpace(@Nullable String value) {
        String result = value;
        if (result != null) {
            result = result.replaceAll("[\\n\\s+]+", SPACE);
            result = result.trim();
        }
        return result;
    }

    public static @NonNull String wrapWithParentheses(@NonNull String text, ParenthesesType type) {
        String result = EMPTY;
        switch (type) {
            case ANGLE: {
                result = OPENING_ANGLE_BRACKET + text + CLOSING_ANGLE_BRACKET;
                break;
            }
            case CURLY: {
                result = OPENING_CURLY_BRACKET + text + CLOSING_CURLY_BRACKET;
                break;
            }
            case ROUND: {
                result = OPENING_BRACKET + text + CLOSING_BRACKET;
                break;
            }
            case SQUARE: {
                result = OPENING_SQUARE_BRACKET + text + CLOSING_SQUARE_BRACKET;
                break;
            }
            default: {
                result = text;
            }
        }
        return result;
    }

    public static @NonNull String formatListOfFrequencyRanges(@NonNull List<@NonNull FrequencyRange> frequencyRanges) {
        Frequency minFrequency = null;
        Frequency maxFrequency = null;
        StringJoiner ranges = new StringJoiner("; ");
        for (FrequencyRange range : frequencyRanges) {
            minFrequency = Converter.toNormalizedFrequency(range.getMinimalFrequency());
            if (minFrequency.compareTo(maxFrequency = Converter.toNormalizedFrequency(range.getMaximalFrequency())) == 0) {
                ranges.add(minFrequency.toString());
                continue;
            }
            ranges.add(MessageFormat.format("&lt;{0}, {1}&gt;", minFrequency, maxFrequency));
        }
        return ranges.toString();
    }
}

