/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.verification;

import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.valueMaps.IValueMap;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.expression.BitFieldVariable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldValueAPI;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;

public class ExpressionVerificator {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ExpressionVerificator.class);
    @NonNull
    private static final ExpressionVerificator INSTANCE = new ExpressionVerificator();
    @NonNull
    private @NonNull Collection<@NonNull Expression> expressions = new ArrayList<Expression>();
    @NonNull
    private @NonNull Collection<@NonNull IValueMap> valueMaps = new ArrayList<IValueMap>();

    private ExpressionVerificator() {
    }

    public static @NonNull ExpressionVerificator getInstance() {
        return INSTANCE;
    }

    public void addExpression(@NonNull Expression expr) {
        if (SWToolsProperties.isVerificationOn()) {
            this.expressions.add(expr);
        }
    }

    public void addValueMap(@NonNull IValueMap valueMap) {
        if (SWToolsProperties.isVerificationOn()) {
            this.valueMaps.add(valueMap);
        }
    }

    public void verifyExpressions(@NonNull IClocksConfig config) {
        LOGGER.info("-------- Expression validation started --------");
        HashSet<@NonNull String> errors = new HashSet<String>();
        for (Expression expr : this.expressions) {
            IContext context = expr.getContext();
            for (BitFieldVariable bfVariable : expr.getBitFields()) {
                String bitFieldId = context.getBitFieldId(bfVariable.getRegisterName(), bfVariable.getBitFieldName());
                BitFieldElement bitField = ClocksBitFieldProvider.getBitFieldById(bitFieldId, config.getMcu().getBitFieldsCache());
                if (bitField != null) continue;
                errors.add(String.format("Bit field with id: '%s' not found", bitFieldId));
            }
            for (String id : expr.getSettings()) {
                ISetting setting = SettingProvider.getSettingById(id, config.getMcu());
                if (setting != null) continue;
                errors.add(String.format("Setting with id: '%s' not found", id));
            }
        }
        if (!errors.isEmpty()) {
            String errorText = UtilsText.join(errors, (String)",\n");
            LOGGER.severe("Found Problems:\n" + errorText);
        }
        LOGGER.info("-------- Expression validation finished --------");
    }

    public void clear() {
        this.expressions.clear();
        this.valueMaps.clear();
    }

    public void verifyBitFields() {
        StringBuilder message = new StringBuilder();
        LOGGER.info("-------- Bit Field validation started --------");
        for (IValueMap valueMap : this.valueMaps) {
            int n;
            Collection<@NonNull String> uiValues = valueMap.getUiValues();
            Range range = valueMap.getRange();
            @NonNull BitFieldElement[] bitFields = valueMap.getBitFields();
            if (bitFields.length == 0) continue;
            String bfNames = UtilsText.join(Arrays.stream(bitFields).map(BitFieldElement::getName), (String)", ");
            BigInteger mapValuesCount = valueMap.getSize();
            if (mapValuesCount == null) {
                BitFieldElement[] bitFieldElementArray = bitFields;
                n = bitFields.length;
                int n2 = 0;
                while (n2 < n) {
                    BitFieldElement bitField = bitFieldElementArray[n2];
                    ExpressionVerificator.checkAllOrNoValuesDefined(bitField, message);
                    ++n2;
                }
                continue;
            }
            if (!uiValues.isEmpty() || range != null && mapValuesCount.compareTo(BigInteger.valueOf(1024L)) <= 0) {
                if (range != null) {
                    uiValues = ExpressionVerificator.toUiValues(valueMap, range);
                }
                HashSet<LongValues> usedBfValues = new HashSet<LongValues>();
                for (String uiValue : uiValues) {
                    LongValues bfValues = valueMap.getBfFromUiValue(uiValue);
                    if (bfValues == null) continue;
                    if (!usedBfValues.add(bfValues)) {
                        message.append("\n").append("Duplicates in bitfield values combinations: " + usedBfValues + " for bitfields " + bfNames);
                    }
                    ExpressionVerificator.checkValuesInRange(bitFields, bfValues, message);
                }
                continue;
            }
            if (range != null && mapValuesCount.compareTo(BigInteger.valueOf(1024L)) > 0) {
                BigInteger bfValues = BigInteger.ONE;
                BitFieldElement[] bitFieldElementArray = bitFields;
                int n3 = bitFields.length;
                n = 0;
                while (n < n3) {
                    BitFieldElement bitField = bitFieldElementArray[n];
                    bfValues = bfValues.multiply(ExpressionVerificator.countBitFieldValuesOrSize(bitField));
                    ++n;
                }
                if (mapValuesCount.compareTo(bfValues) >= 0) continue;
                message.append("\n").append("Values inconsistent for bitfields: ").append(bfNames).append("\n").append("Bitfields have range of " + bfValues + " values but obtained " + mapValuesCount + " possibilities from value mapping");
                continue;
            }
            message.append("\n").append("[TOOL] Value map contains neither range nor values").append("\n");
        }
        if (message.length() != 0) {
            LOGGER.info(message.append("\n").toString());
        }
        LOGGER.info("-------- Bit Field validation finished --------");
    }

    private static void checkValuesInRange(@NonNull BitFieldElement @NonNull [] bitfields, @NonNull LongValues values, @NonNull StringBuilder message) {
        if (bitfields.length != values.getLength()) {
            message.append("\n").append("[TOOL] bitfield count does not match bitfield values count");
            return;
        }
        int i = 0;
        while (i < bitfields.length) {
            BitFieldElement bitfield = bitfields[i];
            Long value = values.getValue(i);
            ExpressionVerificator.checkValueInRange(bitfield, value, message);
            ++i;
        }
    }

    private static void checkValueInRange(@NonNull BitFieldElement bitfield, @NonNull Long value, @NonNull StringBuilder message) {
        boolean found = false;
        IRegBitFieldValueAPI[] values = bitfield.getBitField().getValues();
        BigInteger bigIntValue = new BigInteger(Long.toUnsignedString(value));
        if (values.length == 0) {
            found = bigIntValue.bitLength() <= bitfield.getWidth();
        } else {
            IRegBitFieldValueAPI[] iRegBitFieldValueAPIArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                IRegBitFieldValueAPI bfValue = iRegBitFieldValueAPIArray[n2];
                if (bfValue.matchesValue(value.longValue())) {
                    found = true;
                    break;
                }
                ++n2;
            }
        }
        if (!found) {
            message.append("\n").append("Value " + bigIntValue + " not defined (or out of range) for " + bitfield.getName());
        }
    }

    private static @NonNull Collection<@NonNull String> toUiValues(@NonNull IValueMap valueMap, @NonNull Range range) {
        BigInteger size = range.getSize();
        ArrayList<@NonNull String> values = size == null ? new ArrayList<String>() : new ArrayList(size.intValue());
        BigRational value = range.getMin();
        while (value.compareTo(range.getMax()) <= 0) {
            String uiValue = valueMap.getUiValueByControlValue(value);
            if (uiValue != null) {
                values.add(uiValue);
            }
            value = value.add(range.getStep());
        }
        return values;
    }

    private static void checkAllOrNoValuesDefined(@NonNull BitFieldElement bitField, @NonNull StringBuilder message) {
        BigInteger bitFieldSize;
        BigInteger dbValuesCount = ExpressionVerificator.countBitFieldValues(bitField);
        if (dbValuesCount.compareTo(BigInteger.ZERO) != 0 && dbValuesCount.compareTo(bitFieldSize = ExpressionVerificator.countBitFieldSize(bitField)) < 0) {
            message.append("\n").append("Values inconsistent for bitfield: ").append(bitField.getId()).append("\n").append("Bitfield has range of " + bitFieldSize + " values but obtained " + dbValuesCount + "from registers database");
        }
    }

    private static @NonNull BigInteger countBitFieldValues(@NonNull BitFieldElement bitField) {
        IRegBitFieldValueAPI[] values = bitField.getBitField().getValues();
        BigInteger dbValuesCount = BigInteger.ZERO;
        IRegBitFieldValueAPI[] iRegBitFieldValueAPIArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            IRegBitFieldValueAPI value = iRegBitFieldValueAPIArray[n2];
            dbValuesCount = dbValuesCount.add(BigInteger.valueOf(value.numberOfValues()));
            ++n2;
        }
        return dbValuesCount;
    }

    private static @NonNull BigInteger countBitFieldSize(@NonNull BitFieldElement bitField) {
        return BigInteger.valueOf(2L).pow(bitField.getBitField().getWidth());
    }

    private static @NonNull BigInteger countBitFieldValuesOrSize(@NonNull BitFieldElement bitField) {
        BigInteger dbValuesCount = ExpressionVerificator.countBitFieldValues(bitField);
        if (dbValuesCount.compareTo(BigInteger.ZERO) != 0) {
            return dbValuesCount;
        }
        return ExpressionVerificator.countBitFieldSize(bitField);
    }
}

