/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dcd.model.settings;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Validate;

@Root(name="allowed_address_ranges", strict=false)
public class AllowedAddressRanges {
    @ElementList(inline=true)
    private List<AddressRange> addressRanges;

    protected AllowedAddressRanges() {
        this(new ArrayList<AddressRange>());
    }

    public AllowedAddressRanges(List<AddressRange> addressRanges) {
        this.addressRanges = new ArrayList<AddressRange>(addressRanges);
    }

    public List<AddressRange> getAddressRanges() {
        return this.addressRanges;
    }

    public void setAddressRanges(List<AddressRange> addressRanges) {
        this.addressRanges = addressRanges;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.addressRanges);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllowedAddressRanges other = (AllowedAddressRanges)obj;
        return Objects.equals(this.addressRanges, other.addressRanges);
    }

    @Root(name="address_range", strict=false)
    public static class AddressRange {
        private static final Logger LOGGER = LogManager.getLogger(AddressRange.class);
        @Attribute(name="name", required=true)
        private String name;
        @Attribute(name="lower_boundary", required=true)
        private String lowerBoundary;
        @Attribute(name="upper_boundary", required=true)
        private String upperBoundary;
        private BigInteger lowerBoundaryBigInt;
        private BigInteger upperBoundaryBigInt;

        protected AddressRange() {
            this("", "", "");
        }

        public AddressRange(String name, String lowerBoundary, String upperBoundary) {
            this.name = name;
            this.lowerBoundary = lowerBoundary;
            this.upperBoundary = upperBoundary;
            this.lowerBoundaryBigInt = BigInteger.ZERO;
            this.upperBoundaryBigInt = BigInteger.ZERO;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLowerBoundary() {
            return this.lowerBoundary;
        }

        public void setLowerBoundary(String lowerBoundary) {
            this.lowerBoundary = lowerBoundary;
        }

        public BigInteger getLowerBoundaryBigInt() {
            return this.lowerBoundaryBigInt;
        }

        public String getUpperBoundary() {
            return this.upperBoundary;
        }

        public void setUpperBoundary(String upperBoundary) {
            this.upperBoundary = upperBoundary;
        }

        public BigInteger getUpperBoundaryBigInt() {
            return this.upperBoundaryBigInt;
        }

        @Validate
        public void validate() {
            try {
                this.lowerBoundaryBigInt = NumberFormatter.getBigIntegerWithSuffix((String)this.lowerBoundary);
                this.upperBoundaryBigInt = NumberFormatter.getBigIntegerWithSuffix((String)this.upperBoundary);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.severe(MessageFormat.format("Invalid lowerBoundary ''{0}'' or upperBoundary ''{1}'' for address range ''{2}''", this.lowerBoundary, this.upperBoundary, this.name));
                this.lowerBoundaryBigInt = BigInteger.ZERO;
                this.upperBoundaryBigInt = BigInteger.ZERO;
            }
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Objects.hashCode(this.name);
            result = 31 * result + Objects.hashCode(this.lowerBoundary);
            result = 31 * result + Objects.hashCode(this.upperBoundary);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddressRange other = (AddressRange)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.upperBoundary, other.upperBoundary) && Objects.equals(this.lowerBoundary, other.lowerBoundary);
        }

        public String toString() {
            return "AddressRange [name=" + this.name + ", lowerBoundary=" + this.lowerBoundary + ", upperBoundary=" + this.upperBoundary + "]";
        }
    }
}

