/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dcd.model.settings;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.dcd.model.settings.Action;
import com.nxp.swtools.dcd.model.settings.ActionType;
import com.nxp.swtools.dcd.model.settings.CommandType;
import com.nxp.swtools.dcd.model.settings.ICommand;
import com.nxp.swtools.dcd.model.settings.ICommandSetting;
import java.text.MessageFormat;

public class Command
implements ICommand {
    private String id;
    private String name;
    private CommandType commandType;
    @Nullable
    private ICommandSetting commandSetting;
    @Nullable
    private Action commandAction;
    private ActionType actionType = ActionType.EMPTY;
    public static final String COMMAND_NAME_FORMAT = "{0} - {1}";
    public static final String COMMAND_ID_FORMAT = "{0}_{1}";
    public static final ICommand NA = new Command(CommandType.NA);

    Command(CommandType commandType, ICommandSetting commandSetting, Action commandAction) {
        this.commandType = commandType;
        this.commandSetting = commandSetting;
        this.commandAction = commandAction;
        this.actionType = commandAction.getType();
        this.name = MessageFormat.format(COMMAND_NAME_FORMAT, commandType.getName(), commandAction.getName());
        this.id = MessageFormat.format(COMMAND_ID_FORMAT, commandType.getId(), commandAction.getId());
    }

    Command(CommandType commandType, ICommandSetting commandSetting) {
        this.commandType = commandType;
        this.commandSetting = commandSetting;
        this.name = commandType.getName();
        this.id = commandType.getId();
    }

    Command(CommandType commandType, ICommandSetting commandSetting, ActionType actionType) {
        this.commandType = commandType;
        this.commandSetting = commandSetting;
        this.actionType = actionType;
        this.name = MessageFormat.format(COMMAND_NAME_FORMAT, commandType.getName(), actionType.getName());
        this.id = MessageFormat.format(COMMAND_ID_FORMAT, commandType.getId(), actionType.getId());
    }

    Command(CommandType commandType) {
        this.commandType = commandType;
        this.name = commandType.getName();
        this.id = commandType.getId();
    }

    Command(CommandType commandType, String id) {
        this.commandType = commandType;
        this.name = id;
        this.id = id;
    }

    public static ICommand createUnsupportedCommand(String cmdId) {
        return new Command(CommandType.NA, cmdId);
    }

    @Override
    public CommandType getCommandType() {
        return this.commandType;
    }

    @Override
    public @NonNull ActionType getActionType() {
        return this.actionType;
    }

    @Override
    public @Nullable Action getAction() {
        return this.commandAction;
    }

    @Override
    public @Nullable ICommandSetting getCommandSetting() {
        return this.commandSetting;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return "Command [name=" + this.name + ", id=" + this.id + "]";
    }
}

