/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dcd.model.settings;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.dcd.model.settings.ABaseAttributes;
import com.nxp.swtools.dcd.model.settings.Tag;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="dcd_header", strict=false)
public class DCDHeader {
    @Attribute(name="offset")
    protected String offset;
    @Attribute(name="size")
    protected int size;
    @Attribute(name="byte_order", required=false)
    private String byteOrder = "be";
    @Element(name="tag")
    protected Tag tag;
    @Element(name="length")
    protected Length length;
    @Element(name="version")
    protected Version version;

    public DCDHeader() {
        this("", 0, new Tag(), new Length(), new Version());
    }

    public DCDHeader(String offset, int size, Tag tag, Length length, Version version) {
        this.offset = offset;
        this.size = size;
        this.tag = tag;
        this.length = length;
        this.version = version;
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public Length getLength() {
        return this.length;
    }

    public void setLength(Length length) {
        this.length = length;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(String byteOrder) {
        this.byteOrder = byteOrder;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.offset);
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Objects.hashCode(this.tag);
        result = 31 * result + Objects.hashCode(this.length);
        result = 31 * result + Objects.hashCode(this.byteOrder);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DCDHeader other = (DCDHeader)obj;
        return this.size == other.size && Objects.equals(this.offset, other.offset) && Objects.equals(this.version, other.version) && Objects.equals(this.tag, other.tag) && Objects.equals(this.length, other.length) && Objects.equals(this.byteOrder, other.byteOrder);
    }

    @Root(name="length", strict=false)
    public static class Length
    extends ABaseAttributes {
        private static final Logger LOGGER = LogManager.getLogger(Length.class);
        @Attribute(name="max_length")
        private int maxLength;
        @Attribute(name="align_to_value_ref", required=false)
        protected String alignToValue = "";

        public Length() {
            super(0, 0);
            this.maxLength = 0;
        }

        public Length(int size, int startPosition, int maxLength, String alignToValue) {
            super(size, startPosition);
            this.maxLength = maxLength;
            this.alignToValue = alignToValue;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }

        public String getAlignToValue() {
            return this.alignToValue;
        }

        public void setAlignToValue(String alignToValue) {
            this.alignToValue = alignToValue;
        }

        public int getAlignValueInBytes() {
            int sizeVal = 0;
            Pattern SIZE_BYTE_UNIT_VALUE_REGEXP = Pattern.compile("([0-9]*)\\s*(bytes|byte)");
            Matcher matcher = SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(this.alignToValue);
            if (matcher.matches() && matcher.groupCount() > 1) {
                try {
                    sizeVal = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException err) {
                    LOGGER.log(Level.WARNING, "Error parsing ", err);
                }
            }
            return sizeVal;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Length other = (Length)obj;
            return this.maxLength == other.maxLength;
        }
    }

    @Root(name="version", strict=false)
    public static class Version
    extends Tag {
    }
}

