/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.core;

import com.nxp.s32ds.cle.runtime.migration.MigrationObjectDescriptor;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationEntityAnnotation;
import com.nxp.s32ds.cle.runtime.migration.documentation.MigrationEntityDocumentation;
import com.nxp.s32ds.cle.runtime.migration.documentation.MigrationPropertyDocumentation;
import com.nxp.s32ds.cle.runtime.migration.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationConfigurationDiagnostic;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationConfigurationObjectDescriptor;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.reflection.MigrationReflectionSupport;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;

public abstract class MigrationConfigurationDocumentedObjectDescriptor<C, D extends MigrationObjectDescriptor>
extends MigrationConfigurationObjectDescriptor<D> {
    private final Class<C> realClass;
    private final MigrationEntityDocumentation documentation;

    public MigrationConfigurationDocumentedObjectDescriptor(IConfigurationElement element, Class<C> extensionClass, String ... requiredAttributes) {
        super(element, requiredAttributes);
        this.realClass = this.loadRealClass(extensionClass);
        this.documentation = MigrationReflectionSupport.getMigrationEntityDocumentation(this.realClass);
    }

    public Class<C> getRealClass() {
        return this.realClass;
    }

    protected Class<C> loadRealClass(Class<C> extensionClass) {
        Object extension = Extensions.createExecutableExtension((IConfigurationElement)this.element, (String)"class", extensionClass);
        if (extension != null) {
            return extension.getClass();
        }
        return null;
    }

    public MigrationEntityDocumentation getDocumentation() {
        return this.documentation;
    }

    @Override
    public MigrationConfigurationDiagnostic validate() {
        if (this.realClass == null) {
            return new MigrationConfigurationDiagnostic(this.element, NLS.bind((String)Messages.MigrationConfigurationDocumentedObjectDescriptor_cannot_fetch_implementation_class_0, (Object)this.getAttribute("class")));
        }
        if (this.documentation == null) {
            return new MigrationConfigurationDiagnostic(this.element, NLS.bind((String)Messages.MigrationConfigurationDocumentedObjectDescriptor_class_0_must_be_annotated_by_1, (Object)this.realClass.getCanonicalName(), (Object)MigrationEntityAnnotation.class.getSimpleName()));
        }
        List duplicates = this.documentation.getProperties().stream().collect(Collectors.groupingBy(p -> p.getName())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            return new MigrationConfigurationDiagnostic(this.element, null, duplicates.stream().map(e -> new MigrationConfigurationDiagnostic(this.element, MigrationConfigurationDocumentedObjectDescriptor.getPropertyAnnotationError(e, NLS.bind((String)Messages.MigrationConfigurationDocumentedObjectDescriptor_duplicate_property_name_0_for_field_1, (Object)e.getName(), (Object)e.getPropertyField().toString())))).collect(Collectors.toList()));
        }
        return new MigrationConfigurationDiagnostic(this.element, null, this.documentation.getProperties().stream().map(p -> this.validate((MigrationPropertyDocumentation)p)).collect(Collectors.toList()));
    }

    private MigrationConfigurationDiagnostic validate(MigrationPropertyDocumentation property) {
        int modifiers = property.getPropertyField().getModifiers();
        if ((modifiers & 0x10) != 0) {
            return new MigrationConfigurationDiagnostic(this.element, MigrationConfigurationDocumentedObjectDescriptor.getPropertyAnnotationError(property, Messages.MigrationConfigurationDocumentedObjectDescriptor_field_should_not_be_final));
        }
        if ((modifiers & 8) != 0) {
            return new MigrationConfigurationDiagnostic(this.element, MigrationConfigurationDocumentedObjectDescriptor.getPropertyAnnotationError(property, Messages.MigrationConfigurationDocumentedObjectDescriptor_field_should_not_be_static));
        }
        int minOccurs = property.getMinOccurs();
        if (minOccurs < 0) {
            return new MigrationConfigurationDiagnostic(this.element, MigrationConfigurationDocumentedObjectDescriptor.getPropertyAnnotationError(property, Messages.MigrationConfigurationDocumentedObjectDescriptor_minoccurs_must_be_equal_to_or_greater_than_zero));
        }
        int maxOccurs = property.getMaxOccurs();
        if (maxOccurs < 0 && maxOccurs != -1 || maxOccurs >= 0 && maxOccurs < minOccurs) {
            return new MigrationConfigurationDiagnostic(this.element, MigrationConfigurationDocumentedObjectDescriptor.getPropertyAnnotationError(property, Messages.MigrationConfigurationDocumentedObjectDescriptor_maxoccurs_must_be_or_minus_1_or_greater_than_or_equal_to_minoccurs));
        }
        Class type = property.getType();
        if (maxOccurs == 1) {
            if (minOccurs == 0) {
                if (!MigrationConfigurationDocumentedObjectDescriptor.contains(type, new Class[][]{MigrationReflectionSupport.ALLOWED_CLASSES}) && !MigrationConfigurationDocumentedObjectDescriptor.isEnum(type)) {
                    return new MigrationConfigurationDiagnostic(this.element, MigrationConfigurationDocumentedObjectDescriptor.getPropertyAnnotationError(property, NLS.bind((String)Messages.MigrationConfigurationDocumentedObjectDescriptor_wrong_type_0_for_optional_propert_allowed_types_are_1_or_enum, (Object)MigrationConfigurationDocumentedObjectDescriptor.toString(type), (Object)MigrationConfigurationDocumentedObjectDescriptor.toString(new Class[][]{MigrationReflectionSupport.ALLOWED_CLASSES}))));
                }
            } else if (!MigrationConfigurationDocumentedObjectDescriptor.contains(type, MigrationReflectionSupport.ALLOWED_PRIMITIVES, MigrationReflectionSupport.ALLOWED_CLASSES) && !MigrationConfigurationDocumentedObjectDescriptor.isEnum(type)) {
                return new MigrationConfigurationDiagnostic(this.element, MigrationConfigurationDocumentedObjectDescriptor.getPropertyAnnotationError(property, NLS.bind((String)Messages.MigrationConfigurationDocumentedObjectDescriptor_wrong_type_0_for_required_property_allowed_types_are_1_or_enum, (Object)MigrationConfigurationDocumentedObjectDescriptor.toString(type), (Object)MigrationConfigurationDocumentedObjectDescriptor.toString(MigrationReflectionSupport.ALLOWED_PRIMITIVES, MigrationReflectionSupport.ALLOWED_CLASSES))));
            }
        } else {
            if (!MigrationConfigurationDocumentedObjectDescriptor.contains(type, new Class[][]{MigrationReflectionSupport.ALLOWED_COLLECTIONS})) {
                return new MigrationConfigurationDiagnostic(this.element, MigrationConfigurationDocumentedObjectDescriptor.getPropertyAnnotationError(property, NLS.bind((String)Messages.MigrationConfigurationDocumentedObjectDescriptor_wrong_type_0_for_properties_collection_allowed_types_are_1, (Object)MigrationConfigurationDocumentedObjectDescriptor.toString(type), (Object)MigrationConfigurationDocumentedObjectDescriptor.toString(new Class[][]{MigrationReflectionSupport.ALLOWED_COLLECTIONS}))));
            }
            Class collectionType = property.getCollectionType();
            if (collectionType == null) {
                Type genericType = property.getPropertyField().getGenericType();
                if (genericType instanceof Class) {
                    return new MigrationConfigurationDiagnostic(this.element, MigrationConfigurationDocumentedObjectDescriptor.getPropertyAnnotationError(property, Messages.MigrationConfigurationDocumentedObjectDescriptor_raw_collection_is_not_supported));
                }
                if (genericType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)genericType;
                    return this.wrongCollectionElementsType(property, parameterizedType.getActualTypeArguments()[0]);
                }
            } else if (!MigrationConfigurationDocumentedObjectDescriptor.contains(collectionType, new Class[][]{MigrationReflectionSupport.ALLOWED_CLASSES}) && !MigrationConfigurationDocumentedObjectDescriptor.isEnum(collectionType)) {
                return this.wrongCollectionElementsType(property, collectionType);
            }
        }
        return MigrationConfigurationDiagnostic.OK;
    }

    private MigrationConfigurationDiagnostic wrongCollectionElementsType(MigrationPropertyDocumentation property, Type collectionType) {
        return new MigrationConfigurationDiagnostic(this.element, MigrationConfigurationDocumentedObjectDescriptor.getPropertyAnnotationError(property, NLS.bind((String)Messages.MigrationConfigurationDocumentedObjectDescriptor_wrong_type_0_for_element_of_properties_collection_allowed_types_are_1_or_enum, (Object)MigrationConfigurationDocumentedObjectDescriptor.toString(collectionType), (Object)MigrationConfigurationDocumentedObjectDescriptor.toString(new Class[][]{MigrationReflectionSupport.ALLOWED_CLASSES}))));
    }

    private static String getPropertyAnnotationError(MigrationPropertyDocumentation property, String message) {
        return NLS.bind((String)Messages.MigrationConfigurationDocumentedObjectDescriptor_wrong_0_property_annotation_1, (Object)property.getName(), (Object)message);
    }

    private static String toString(Class<?>[] ... classesArray) {
        return String.join((CharSequence)", ", MigrationConfigurationDocumentedObjectDescriptor.streamOf(classesArray).map(c -> MigrationConfigurationDocumentedObjectDescriptor.toString(c)).collect(Collectors.toList()));
    }

    private static String toString(Type type) {
        if (type instanceof Class) {
            return MigrationConfigurationDocumentedObjectDescriptor.toString((Class)type);
        }
        return type.toString();
    }

    private static String toString(Class<?> type) {
        return type.getSimpleName();
    }

    private static boolean isEnum(Class<?> type) {
        return Enum.class.isAssignableFrom(type);
    }

    private static boolean contains(Class<?> type, Class<?>[] ... allowedClasses) {
        return MigrationConfigurationDocumentedObjectDescriptor.streamOf(allowedClasses).filter(c -> c.equals(type)).findAny().isPresent();
    }

    @SafeVarargs
    private static <T> Stream<T> streamOf(T[] ... objects) {
        if (objects == null) {
            return Stream.empty();
        }
        return Stream.of(objects).flatMap(a -> Stream.of(a));
    }
}

