/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.ContextSettings;
import com.freescale.s32ds.cross.core.Messages;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.CoreDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectContextSettings
implements ContextSettings {
    public static final String BUNDLE_ID = "com.freescale.s32ds.cross.core";
    public static final String QUALIFIER = "com.nxp.s32ds.cle.runtime.component";
    public static final String ARCHETYPE_APPLICATION = "application";
    public static final String ARCHETYPE_LIBRARY = "library";
    public static final String DEFAULT_VALUE = "";
    private final IProject project;
    private final IEclipsePreferences projectNode;
    private final ProjectScope projectScope;
    private final IPreferencesService preferensesService = Platform.getPreferencesService();
    private Map<String, String> contextMap = new HashMap<String, String>();

    public ProjectContextSettings(IProject project) {
        this.project = project;
        this.projectScope = new ProjectScope(project);
        this.projectNode = this.projectScope.getNode(QUALIFIER);
        this.contextMap.clear();
    }

    public ProjectContextSettings(IProject project, String qualifier) {
        this.project = project;
        this.projectScope = new ProjectScope(project);
        this.projectNode = this.projectScope.getNode(qualifier);
        this.contextMap.clear();
    }

    public ProjectContextSettings setAttribute(String key, String value) {
        if (value == null) {
            Activator.logWarning(NLS.bind((String)Messages.ProjectContextSettings_setting_null_value, (Object)key));
            value = DEFAULT_VALUE;
        }
        this.projectNode.put(key, value);
        return this;
    }

    public String getAttributeByKey(String key) {
        return this.preferensesService.getString(QUALIFIER, key, DEFAULT_VALUE, new IScopeContext[]{this.projectScope});
    }

    public void storeProjectContext(String family, String device, String core, String deviceCore, String deviceRevision, String contextType, String langId, String platformId) {
        this.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.core.id", core);
        this.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id", deviceCore);
        this.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.device.id", device);
        this.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id", deviceRevision);
        this.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.family.id", family);
        this.setAttribute("com.nxp.s32ds.cle.runtime.component.registry.archetype.id", contextType);
        this.setAttribute("com.nxp.s32ds.cle.runtime.component.registry.archetype.platform.id", platformId);
        this.setAttribute("com.nxp.s32ds.cle.runtime.lang.registry.lang.id", langId);
        this.store();
    }

    public void storeProjectContext(String family, String device, String core, String deviceCore, String deviceRevision, String contextType, String langId, String platformId, String toolchainId) {
        this.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.core.id", core);
        this.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id", deviceCore);
        this.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.device.id", device);
        this.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id", deviceRevision);
        this.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.family.id", family);
        this.setAttribute("com.nxp.s32ds.cle.runtime.hardware.registry.toolchain.id", toolchainId);
        this.setAttribute("com.nxp.s32ds.cle.runtime.component.registry.archetype.id", contextType);
        this.setAttribute("com.nxp.s32ds.cle.runtime.component.registry.archetype.platform.id", platformId);
        this.setAttribute("com.nxp.s32ds.cle.runtime.lang.registry.lang.id", langId);
        this.store();
    }

    public void createContextMap(String family, String device, String core, String deviceCore, String deviceRevision, String contextType, String langId, String platformId, String toolchainId) {
        this.contextMap.put("com.nxp.s32ds.cle.runtime.hardware.registry.core.id", core);
        this.contextMap.put("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id", deviceCore);
        this.contextMap.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.id", device);
        this.contextMap.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id", deviceRevision);
        this.contextMap.put("com.nxp.s32ds.cle.runtime.hardware.registry.family.id", family);
        this.contextMap.put("com.nxp.s32ds.cle.runtime.hardware.registry.toolchain.id", toolchainId);
        this.contextMap.put("com.nxp.s32ds.cle.runtime.component.registry.archetype.id", contextType);
        this.contextMap.put("com.nxp.s32ds.cle.runtime.component.registry.archetype.platform.id", platformId);
        this.contextMap.put("com.nxp.s32ds.cle.runtime.lang.registry.lang.id", langId);
    }

    public void storeProjectContextMap() {
        this.contextMap.forEach((k, v) -> {
            ProjectContextSettings projectContextSettings = this.setAttribute((String)k, (String)v);
        });
        this.store();
    }

    public void setFamily2Context(String v) {
        this.contextMap.put("com.nxp.s32ds.cle.runtime.hardware.registry.family.id", v);
    }

    @Override
    public String getFamily2Context() {
        return this.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.family.id");
    }

    public void setDevice2Context(String v) {
        this.contextMap.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.id", v);
    }

    @Override
    public String getDevice2Context() {
        String deviceIdAttribute = this.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
        DeviceDescriptor device = DeviceDescriptors.getDeviceDescriptor((String)deviceIdAttribute);
        return device != null ? device.getId() : deviceIdAttribute;
    }

    public void setCore2Context(String v) {
        this.contextMap.put("com.nxp.s32ds.cle.runtime.hardware.registry.core.id", v);
    }

    @Override
    public String getCore2Context() {
        String coreIdAttribute = this.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
        CoreDescriptor core = CoreDescriptors.getCoreDescriptor((String)coreIdAttribute);
        return core != null ? core.getId() : coreIdAttribute;
    }

    public void setDeviceCore2Context(String v) {
        this.contextMap.put("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id", v);
    }

    @Override
    public String getDeviceCore2Context() {
        String deviceCoreIdAttribute = this.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        DeviceCoreDescriptor deviceCore = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreIdAttribute);
        return deviceCore != null ? deviceCore.getId() : deviceCoreIdAttribute;
    }

    public void setDeviceRevision2Context(String v) {
        this.contextMap.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id", v);
    }

    @Override
    public String getDeviceRevision2Context() {
        return this.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id");
    }

    public void setToolChain2Context(String v) {
        this.contextMap.put("com.nxp.s32ds.cle.runtime.hardware.registry.toolchain.id", v);
    }

    @Override
    public String getToolChain2Context() {
        return this.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.toolchain.id");
    }

    public void setArchType2Context(String v) {
        this.contextMap.put("com.nxp.s32ds.cle.runtime.component.registry.archetype.id", v);
    }

    @Override
    public String getArchType2Context() {
        return this.getAttributeByKey("com.nxp.s32ds.cle.runtime.component.registry.archetype.id");
    }

    public void setLang2Context(String v) {
        this.contextMap.put("com.nxp.s32ds.cle.runtime.lang.registry.lang.id", v);
    }

    @Override
    public String getLang2Context() {
        return this.getAttributeByKey("com.nxp.s32ds.cle.runtime.lang.registry.lang.id");
    }

    public void setPlatform2Context(String v) {
        this.contextMap.put("com.nxp.s32ds.cle.runtime.component.registry.archetype.platform.id", v);
    }

    @Override
    public String getPlatform2Context() {
        return this.getAttributeByKey("com.nxp.s32ds.cle.runtime.component.registry.archetype.platform.id");
    }

    public void setBootableCore(boolean isCoreBootable) {
        this.contextMap.put("com.nxp.s32ds.cle.runtime.hardware.registry.bootable.core", String.valueOf(isCoreBootable));
    }

    @Override
    public boolean isLibrary() {
        return ARCHETYPE_LIBRARY.equals(this.getArchType2Context());
    }

    @Override
    public boolean isBootableCore() {
        return Boolean.parseBoolean(this.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.bootable.core"));
    }

    public Map<String, String> getProjectContextAttributes() {
        HashMap<String, String> context = new HashMap<String, String>();
        this.addAttribute(context, "com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
        this.addAttribute(context, "com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
        this.addAttribute(context, "com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        this.addAttribute(context, "com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id");
        this.addAttribute(context, "com.nxp.s32ds.cle.runtime.hardware.registry.family.id");
        this.addAttribute(context, "com.nxp.s32ds.cle.runtime.hardware.registry.toolchain.id");
        this.addAttribute(context, "com.nxp.s32ds.cle.runtime.component.registry.archetype.platform.id");
        this.addAttribute(context, "com.nxp.s32ds.cle.runtime.lang.registry.lang.id");
        return context;
    }

    public void store() {
        try {
            if (this.project.isOpen()) {
                this.projectNode.flush();
            }
        }
        catch (BackingStoreException e) {
            Status status = new Status(4, BUNDLE_ID, e.getMessage());
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    private void addAttribute(Map<String, String> context, String key) {
        String attribute = this.getAttributeByKey(key);
        if (attribute != null && !attribute.isEmpty()) {
            context.put(key, attribute);
        }
    }
}

