/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model;

import com.freescale.s32ds.cross.core.model.ITemplateVariableProvider;
import com.freescale.s32ds.cross.core.model.ModelUtil;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import java.util.Objects;
import org.eclipse.core.runtime.IConfigurationElement;

public class TemplateVariable {
    private final String id;
    private final String tag;
    private final ITemplateVariableProvider variableProvider;
    private final boolean executable;
    private final boolean library;

    public TemplateVariable(IConfigurationElement ce) {
        this.id = ce.getAttribute("id");
        this.tag = ce.getAttribute("tag");
        this.variableProvider = ModelUtil.parseTemplateVariableProvider(ce);
        this.executable = ModelUtil.parseBoolean(ce.getAttribute("executable"), true);
        this.library = ModelUtil.parseBoolean(ce.getAttribute("library"), true);
    }

    public String getId() {
        return this.id;
    }

    public ITemplateVariableProvider getVariableProvider() {
        return this.variableProvider;
    }

    public String getValue(AbstractContext context) {
        if (this.variableProvider != null) {
            return this.variableProvider.createValue(this.id, this.tag, context);
        }
        String value = context.getStringValue(this.tag);
        return value != null ? value.toString() : null;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public boolean isLibrary() {
        return this.library;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TemplateVariable)) {
            return false;
        }
        TemplateVariable variable = (TemplateVariable)obj;
        return this.id.equals(variable.id) && this.tag.equals(variable.tag) && Objects.equals(this.variableProvider, variable.variableProvider) && this.executable == variable.executable && this.library == variable.library;
    }
}

