/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.data;

import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreKindData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureSlaveData;
import com.freescale.s32ds.cross.core.model.data.CoreTypeData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ObjectData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.model.data.TemplateData;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public abstract class CoreNatureData
extends ObjectData {
    private Map<String, TemplateData> templateMap = new LinkedHashMap<String, TemplateData>();

    public CoreNatureData(IConfigurationElement ce, ConfigurationData parent, ModelRegistry registry) {
        super(ce, parent, registry);
    }

    public String getCoreNatureId() {
        return this.getId();
    }

    public abstract String getSuffix();

    public abstract ProcessorData getProcessor();

    public abstract CoreTypeData getCoreType();

    public abstract boolean isAutoStart();

    public boolean isEnabledByDefault() {
        if (this.isAutoStart()) {
            return true;
        }
        ConfigurationData el = this.getElement("enabledByDefault");
        return el != null ? el.getBooleanValue("enabledByDefault") : true;
    }

    public abstract List<CoreNatureSlaveData> getSlaves();

    public abstract CoreNatureSlaveData getSlave(String var1);

    public FamilyData getFamily() {
        ProcessorData processor = this.getProcessor();
        return processor != null ? processor.getFamily() : null;
    }

    public CoreKindData getCoreKind() {
        return (CoreKindData)this.getElement("coreKind");
    }

    public String getCoreKindId() {
        CoreKindData coreKind = this.getCoreKind();
        return coreKind != null ? coreKind.getId() : "undefined";
    }

    public List<TemplateData> getTemplates() {
        return new ArrayList<TemplateData>(this.templateMap.values());
    }

    public boolean containsTemplate(TemplateData template) {
        return this.templateMap.containsKey(template.getId());
    }

    public TemplateData getDefaultTemplate() {
        List<TemplateData> templates = this.getTemplates();
        return templates.size() > 0 ? templates.get(0) : null;
    }

    protected void addTemplate(TemplateData template) {
        if (!this.containsTemplate(template)) {
            this.templateMap.put(template.getId(), template);
        }
    }
}

