/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ExtensionLoader {
    private static volatile Supplier<ExtensionLoader> instance = new Supplier<ExtensionLoader>(){

        @Override
        public synchronized ExtensionLoader get() {
            if (instance == this) {
                ExtensionLoader loader = new ExtensionLoader(null);
                instance = () -> loader;
            }
            return (ExtensionLoader)instance.get();
        }
    };
    private final HashMap<String, List<String>> disassemblersMap = new HashMap();
    private final HashMap<String, String> preprocessors = new HashMap();
    private static final String NAME_DISASSEMBLER = "disassembler";
    private static final String NAME_PREPROCESSOR = "preprocessor";
    private static final String ATTR_ID = "id";
    private static final String ATTR_TARGET_TOOL = "targetTool";
    private static final String ATTR_COMPILER_ID = "compilerId";

    public static ExtensionLoader getInstance() {
        return instance.get();
    }

    private ExtensionLoader() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.freescale.s32ds.cross.core.additionalTools");
        if (ep != null) {
            IExtension[] iExtensionArray = ep.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    String name = ce.getName();
                    String idAttr = ce.getAttribute(ATTR_ID);
                    if (name.equals(NAME_DISASSEMBLER)) {
                        String target = ce.getAttribute(ATTR_TARGET_TOOL);
                        List list = this.disassemblersMap.computeIfAbsent(target, k -> new ArrayList());
                        if (!list.contains(idAttr)) {
                            list.add(idAttr);
                        }
                    } else if (name.equals(NAME_PREPROCESSOR)) {
                        this.preprocessors.put(ce.getAttribute(ATTR_COMPILER_ID), idAttr);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private static <T> T getTool(ITool target, Map<String, T> map, T defaultValue) {
        String id = target.getBaseId();
        if (map.containsKey(id)) {
            return map.get(id);
        }
        ITool parent = target.getSuperClass();
        return parent == null ? defaultValue : ExtensionLoader.getTool(parent, map, defaultValue);
    }

    public List<String> getDisassemblers(ITool targetTool) {
        return ExtensionLoader.getTool(targetTool, this.disassemblersMap, Collections.emptyList());
    }

    public String getPreprocessor(ITool compiler) {
        return ExtensionLoader.getTool(compiler, this.preprocessors, null);
    }

    /* synthetic */ ExtensionLoader(ExtensionLoader extensionLoader) {
        this();
    }
}

