/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.actions.launch;

import com.nxp.s32ds.cle.cdt.internal.migration.CdtMigrationActivator;
import com.nxp.s32ds.cle.cdt.internal.migration.Messages;
import com.nxp.s32ds.cle.cdt.migration.actions.launch.UpdateLaunchConfigurationActionBase;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationEntityAnnotation;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;

@MigrationEntityAnnotation(name="Update S32 debugger launch configuration.", description="Update S32 debugger launch configuration for specified toolchain ID.")
public class UpdateS32DebuggerLaunchConfigurationAction
extends UpdateLaunchConfigurationActionBase {
    private static final String EMPTY_STRING = "";
    private static final String DEBUGGER_ATTRIBUTE_NAME = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";
    private static final String S32DEBUGGER_ID = "s32debugger";
    private static final String S32DEBUGGER_CONFIG_TYPE = "com.nxp.s32ds.debug.ide.s32debugger.core.s32DebuggerLaunchConfigurationType";
    private static final String S32DEBUGGER_CORE_CORE = "com.nxp.s32ds.debug.ide.s32debugger.core.core";
    private static final String S32DEBUGGER_CORE_DEVICE = "com.nxp.s32ds.debug.ide.s32debugger.core.device";
    private static final String S32DEBUGGER_CORE_DEVICE_CORE_ID = "com.nxp.s32ds.debug.ide.s32debugger.core.deviceCoreId";

    @Override
    public String getConfigurationName() {
        return S32DEBUGGER_CONFIG_TYPE;
    }

    @Override
    protected String getDebuggerId() {
        return S32DEBUGGER_ID;
    }

    @Override
    protected void migrateWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy, IProject project, String targetToolchain) throws CoreException {
        String deviceCoreId = workingCopy.getAttribute(S32DEBUGGER_CORE_DEVICE_CORE_ID, EMPTY_STRING);
        if (deviceCoreId.isEmpty() && (deviceCoreId = UpdateS32DebuggerLaunchConfigurationAction.getBackwardCompatibilityDeviceCoreId(workingCopy)) == null) {
            throw new CoreException(CdtMigrationActivator.getInstance().createError(NLS.bind((String)Messages.UpdateS32DebuggerLaunchConfigurationAction_cannot_fetch_device_core_id_for_0_launch_configuration, (Object)workingCopy.getName())));
        }
        String gdbClientValue = LaunchConfigurationUtil.getGDBClientValue((String)deviceCoreId, (String)this.getDebuggerId(), (String)targetToolchain);
        if (!"gdb".equals(gdbClientValue)) {
            workingCopy.setAttribute(DEBUGGER_ATTRIBUTE_NAME, gdbClientValue);
        }
    }

    private static String getBackwardCompatibilityDeviceCoreId(ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        String deviceId = workingCopy.getAttribute(S32DEBUGGER_CORE_DEVICE, EMPTY_STRING);
        String coreName = workingCopy.getAttribute(S32DEBUGGER_CORE_CORE, EMPTY_STRING);
        if (deviceId.isEmpty() || coreName.isEmpty()) {
            return null;
        }
        return DeviceDescriptors.getDeviceRegistry().getDeviceCoreDescriptorsByDeviceId(deviceId).stream().filter(d -> coreName.equals(d.getName())).findAny().map(EntityDescriptor::getId).orElse(null);
    }
}

