/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.entities.sdk;

import com.nxp.s32ds.cle.cdt.migration.entities.sdk.AbstractSdkMigrationEntity;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachData;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachProcessor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class SdkDetachMigrationEntity
extends AbstractSdkMigrationEntity {
    IStatus status = Status.OK_STATUS;

    public IStatus migrate(String sourceId, String targetId, Map<String, Object> attributes, IProgressMonitor monitor) {
        IProject project = (IProject)attributes.get("s32ds.migration.payload.attributes.project");
        if (sourceId == null || sourceId.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        if (project == null || !project.exists()) {
            return Status.CANCEL_STATUS;
        }
        List undefinedSDK = SdkAttachDataHolder.getUndefinedSdksByProject((IProject)project);
        for (SdkDescriptor sdk : undefinedSDK) {
            if (!sdk.getId().equals(sourceId)) continue;
            Display.getDefault().syncExec(() -> {
                this.status = SdkAttachProcessor.detachUnresolvedSdk((SdkDescriptor)sdk, (IProject)project);
                MultiStatus multiStatus = this.status;
            });
        }
        if (undefinedSDK.isEmpty()) {
            Collection sdkAttachData = SdkAttachDataHolder.getProjectAttachData((IProject)project);
            for (SdkAttachData attachedSdk : sdkAttachData) {
                if (!attachedSdk.getSdkId().equals(sourceId)) continue;
                Display.getDefault().syncExec(() -> {
                    SdkDescriptor sdkDescriptor = SdkDescriptors.getSdkDescriptor((String)attachedSdk.getSdkId());
                    this.status = SdkAttachProcessor.detachSdkFromProject((SdkDescriptor)sdkDescriptor, (IProject)project, (IProgressMonitor)monitor);
                });
            }
        }
        return this.status;
    }
}

