/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.newconfig;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.newconfig.NewConfigWizardPage;
import com.nxp.swtools.framework.ui.newconfig.WizardData;
import com.nxp.swtools.framework.ui.newconfig.containers.ProcessorSelectionContainer;
import com.nxp.swtools.kex.selector.IMcuSelectionWritable;
import java.util.logging.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;

public class NewConfigurationProcessorPage
extends NewConfigWizardPage {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(NewConfigurationProcessorPage.class);
    @NonNull
    ProcessorSelectionContainer selectionContainer = new ProcessorSelectionContainer(canFinish -> this.setPageComplete((boolean)canFinish), finish -> this.finishOrNextPage());

    protected NewConfigurationProcessorPage(@NonNull String pageName, @NonNull WizardData wizardData) {
        super(pageName, wizardData);
        this.setPageComplete(false);
        this.setTitleBasedOnMode();
    }

    private void setTitleBasedOnMode() {
        if (this.selectionContainer.isSwitchingProcessor()) {
            this.setTitle(Messages.get().NewConfigDialog_TitleForSwitch);
        } else {
            this.setTitle(Messages.get().NewConfigDialog_Title);
        }
    }

    public void createControl(Composite parent) {
        assert (parent != null);
        Composite composite = new Composite(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        this.selectionContainer.createControls(composite);
        this.setControl((Control)composite);
        if (!this.selectionContainer.isSwitchingProcessor()) {
            this.setDescription(Messages.get().NewConfigDialog_TipForImportMex);
        }
    }

    void finishOrNextPage() {
        IWizardPage nextPage = this.getNextPage();
        if (nextPage != null) {
            this.getContainer().showPage(nextPage);
        } else {
            IWizard wizard = this.getWizard();
            assert (wizard != null);
            if (wizard.performFinish()) {
                wizard.getContainer().getShell().close();
            }
        }
    }

    public @NonNull ProcessorSelectionContainer getSelectionContainer() {
        return this.selectionContainer;
    }

    public void setPageComplete(boolean complete) {
        if (complete) {
            ((IMcuSelectionWritable)this.wizardData.newConfiguration.getCommonConfig()).setMcu(UtilsText.safeString((String)this.selectionContainer.getSelectedMcu()));
        }
        super.setPageComplete(complete);
    }

    @Override
    protected void validatePage() {
        if (SWToolsProperties.isDevelopmentWithNoDataUpdateOn()) {
            this.setMessage(null, 2);
        } else if (this.getSelectionContainer().getOnlineDataInfo().getOnlineProcessorsWeb().isEmpty()) {
            this.setMessage(Messages.get().NewConfigDialog_OfflineMode, 2);
        } else {
            this.setMessage(null, 2);
            if (this.selectionContainer.isSwitchingProcessor()) {
                this.setMessage(com.nxp.swtools.utils.Messages.get().SelectPackageDialog_WarningSwitching, 1);
            }
        }
        this.setErrorMessage(null);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitleBasedOnMode();
            this.selectionContainer.setSearchTitle();
            FilteredTree tree = this.selectionContainer.getTree();
            if (tree != null) {
                tree.setFocus();
            }
            this.selectionContainer.setCreateFromTemplateAllowed(true);
            this.validatePage();
        }
    }

    @Override
    protected boolean canBeShown() {
        return this.wizardData.getMode().selectBoardProcessor();
    }
}

