/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.newconfig;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISWToolsDataFolderInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.provider.processors.ISWToolsProcessorInfo;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.processors.OnlineDataInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@NonNullByDefault
public class ProcessorMergeHelper {
    private ISupportedDerivativesForSwTools derivatives;
    private Collection<IProcessorMasterToolInfo> onlineProcessors;
    private Collection<ITemplateInfo> onlineBoards;
    private Collection<ITemplateInfo> onlineKits;

    public ProcessorMergeHelper(ISupportedDerivativesForSwTools derivatives, OnlineDataInfo onlineDataInfo) {
        this.derivatives = derivatives;
        this.onlineProcessors = onlineDataInfo.getOnlineProcessors();
        this.onlineBoards = onlineDataInfo.getOnlineBoards();
        this.onlineKits = onlineDataInfo.getOnlineKits();
    }

    public ProcessorMergeHelper(ISupportedDerivativesForSwTools derivatives, Collection<IProcessorMasterToolInfo> onlineProcessors, Collection<ITemplateInfo> onlineBoards, Collection<ITemplateInfo> onlineKits) {
        this.derivatives = derivatives;
        this.onlineProcessors = onlineProcessors;
        this.onlineBoards = onlineBoards;
        this.onlineKits = onlineKits;
    }

    public Map<String, IProcessorMasterToolInfo> getSdkProcessorMap(String mcu) {
        Hashtable<String, IProcessorMasterToolInfo> sdkMap = new Hashtable<String, IProcessorMasterToolInfo>();
        this.getMasterToolInfos(mcu).filter(p -> p instanceof ISWToolsProcessorInfo || KExProcessorsProvider.PROCESSOR_FILTER.test(p)).forEach(p -> {
            IProcessorMasterToolInfo iProcessorMasterToolInfo = sdkMap.put(p.getSWToolsDataFolderID(), (IProcessorMasterToolInfo)p);
        });
        return sdkMap;
    }

    public Stream<IProcessorMasterToolInfo> getMasterToolInfos(String mcu) {
        return Stream.concat(this.derivatives.getProcessorMasterToolInfos(mcu), this.onlineProcessors.stream().filter(p -> mcu.equals(p.getId())));
    }

    public Collection<String> getAllSeries(Predicate<String> processorFilter) {
        return (Collection)Stream.concat(KExProcessorsProvider.getSeriesMasterTool((Collection)((Collection)this.onlineProcessors.stream().filter(p -> processorFilter.test(p.getId())).collect(CollectorsUtils.toList()))).stream(), this.getAllMasterToolInfos().stream().filter(p -> processorFilter.test(p.getId())).map(IProcessorMasterToolInfo::getSeries)).collect(CollectorsUtils.toSet());
    }

    public Collection<IProcessorMasterToolInfo> getAllMasterToolInfos() {
        return Stream.concat(this.onlineProcessors.stream(), this.derivatives.getAllProcessorMasterToolInfos().filter(KExProcessorsProvider.PROCESSOR_FILTER)).collect(Collectors.toList());
    }

    public Collection<String> getAllSdks() {
        return (Collection)this.getAllMasterToolInfos().stream().map(ISWToolsDataFolderInfo::getSWToolsDataFolderID).collect(CollectorsUtils.toSet());
    }

    public Collection<IProcessorMasterToolInfo> getMasterToolsForSeries(String series) {
        return Stream.concat(this.derivatives.getAllProcessorMasterToolInfos().filter(KExProcessorsProvider.PROCESSOR_FILTER), this.onlineProcessors.stream()).filter(i -> series.equals(i.getSeries())).collect(Collectors.toSet());
    }

    public Collection<IProcessorMasterToolInfo> getMasterToolsForSeriesFilteredById(String series, boolean showDuplicates) {
        HashSet ids = new HashSet();
        Set infos = this.getMasterToolsForSeries(series).stream().sorted(new MasterToolComparator()).collect(Collectors.toSet());
        if (showDuplicates) {
            return infos.stream().filter(i -> ids.add(String.valueOf(i.getId()) + "/" + i.getSWToolsDataFolderID())).collect(Collectors.toSet());
        }
        return infos.stream().filter(i -> ids.add(i.getId())).collect(Collectors.toSet());
    }

    public Collection<ITemplateInfo> getAllBoards() {
        Collection localBoards = this.derivatives.getAllBoardsInfos();
        return Stream.concat(localBoards.stream().filter(b -> {
            String master = b.getMasterToolName();
            Stream infos = this.derivatives.getProcessorMasterToolInfos(master);
            return infos.anyMatch(KExProcessorsProvider.PROCESSOR_FILTER);
        }), this.onlineBoards.stream()).collect(Collectors.toList());
    }

    public Collection<ITemplateInfo> getAllKits() {
        Collection localKits = this.derivatives.getAllKitsInfos();
        return Stream.concat(localKits.stream().filter(b -> {
            String master = b.getMasterToolName();
            Stream infos = this.derivatives.getProcessorMasterToolInfos(master);
            return infos.anyMatch(KExProcessorsProvider.PROCESSOR_FILTER);
        }), this.onlineKits.stream()).collect(Collectors.toList());
    }

    public Collection<ITemplateInfo> getAllBoardsFilteredById() {
        HashSet ids = new HashSet();
        return this.getAllBoards().stream().filter(b -> ids.add(b.getId())).collect(Collectors.toList());
    }

    public Collection<ITemplateInfo> getAllKitsFilteredById() {
        HashSet ids = new HashSet();
        return this.getAllKits().stream().filter(b -> ids.add(b.getId())).collect(Collectors.toList());
    }

    public Map<String, ITemplateInfo> getSdkBoardMap(String id, ITemplateInfo.TemplateType templateType) {
        Hashtable<String, ITemplateInfo> sdkMap = new Hashtable<String, ITemplateInfo>();
        @NonNull Collection<ITemplateInfo> infos = ITemplateInfo.TemplateType.ttKit.equals((Object)templateType) ? this.getAllKits() : this.getAllBoards();
        infos.stream().filter(b -> id.equals(b.getId())).forEach(p -> {
            ITemplateInfo iTemplateInfo = sdkMap.put(p.getSWToolsDataFolderID(), (ITemplateInfo)p);
        });
        return sdkMap;
    }

    static class MasterToolComparator
    implements Comparator<IProcessorMasterToolInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(IProcessorMasterToolInfo o1, IProcessorMasterToolInfo o2) {
            if (Objects.equals(o1.getClass(), o2.getClass())) {
                return 0;
            }
            return o1 instanceof ISWToolsProcessorInfo ? -1 : 1;
        }
    }
}

