/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.orbit.clt;

import com.nxp.s32ds.ext.orbit.cli.CliOption;
import com.nxp.s32ds.ext.orbit.cli.CliOptionBuilder;
import com.nxp.s32ds.ext.orbit.cli.CliParseException;
import com.nxp.s32ds.ext.orbit.cli.CliParsedOptions;
import com.nxp.s32ds.ext.orbit.cli.CliSupport;
import com.nxp.s32ds.ext.orbit.clt.cli.apache.ApacheCli;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class CltRunner {
    public static final String HELP = "h";
    public static final String HELP_LONG = "help";
    protected static final int ERROR_EXIT_CODE = 1;
    protected static final int OK_EXIT_CODE = 0;
    protected static Logger logger = Logger.getLogger(CltRunner.class);
    protected static final CliSupport CLI = new ApacheCli();
    private static final CliOption HELP_OPTION = CLI.cliOptionBuilder().withDescription("print this message").withLongOpt("help").create("h");

    public static Logger getLogger() {
        return logger;
    }

    public final int run(String[] args) {
        Set<CliOption> options = this.getOptions();
        if (args.length == 0 || args.length == 1 && (args[0].equals(CliOptionBuilder.getOption((String)HELP)) || args[0].equals(CliOptionBuilder.getLongOption((String)HELP_LONG)))) {
            logger.info((Object)CLI.generateHelp(this.getCmdLineSyntax(), options));
            return 0;
        }
        try {
            return this.run(CLI.parse(options, args));
        }
        catch (CliParseException e) {
            logger.error((Object)e.getMessage());
            logger.info((Object)CLI.generateHelp(this.getCmdLineSyntax(), options));
            return 1;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return 1;
        }
    }

    protected abstract int run(CliParsedOptions var1);

    protected String getName() {
        return "clt";
    }

    protected Set<CliOption> getOptions() {
        Set options = CLI.newOptions();
        options.add(HELP_OPTION);
        return options;
    }

    private String getCmdLineSyntax() {
        return this.getName();
    }
}

