/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.internal.ui;

import com.nxp.s32ds.debug.ide.internal.ui.SmartCardMessages;
import com.nxp.s32ds.debug.ide.ui.SWTUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SmartCardPasswordDialog
extends TitleAreaDialog {
    private static final int MAX_PASS_SIZE = 255;
    private static final char NULL_TERMINATOR_CHAR = '\u0000';
    private static final char HIDDEN_CHAR_PLACEHOLDER = '\u25cf';
    private Button butOK;
    private Button butShowPassword;
    private Button butStorePassword;
    private Text txtPassword;
    private String password = "";
    private boolean resisableOnInit = true;
    private boolean storePassword = false;
    private boolean showStoreCheckbox;

    public SmartCardPasswordDialog(Shell parentShell) {
        super(parentShell);
        this.showStoreCheckbox = false;
    }

    public SmartCardPasswordDialog(Shell parentShell, boolean allowCachingChoice) {
        super(parentShell);
        this.showStoreCheckbox = allowCachingChoice;
    }

    public void create() {
        super.create();
        this.setTitle(SmartCardMessages.SCPasswordDialog_smartcard_password_message);
    }

    public Control createDialogArea(Composite parent) {
        Composite innerComposite = new Composite(parent, 2048);
        GridData horizontalFill = new GridData(4, 16, true, false);
        innerComposite.setLayoutData((Object)horizontalFill);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 15;
        innerComposite.setLayout((Layout)gridLayout);
        SWTUtils.createLabel(innerComposite, SmartCardMessages.SCPasswordDialog_enter_password_message);
        this.txtPassword = SWTUtils.createWideText(innerComposite, 0x400804, true, 1);
        this.txtPassword.setEditable(true);
        this.txtPassword.addModifyListener(listener -> this.validate());
        this.butShowPassword = SWTUtils.createButtonWithHorizontalSpan(innerComposite, SmartCardMessages.SCPasswordDialog_show_password_message, 32, 2);
        this.butShowPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SmartCardPasswordDialog.this.butShowPassword.getSelection()) {
                    SmartCardPasswordDialog.this.txtPassword.setEchoChar('\u0000');
                } else {
                    SmartCardPasswordDialog.this.txtPassword.setEchoChar('\u25cf');
                }
            }
        });
        if (this.showStoreCheckbox) {
            this.butStorePassword = SWTUtils.createButtonWithHorizontalSpan(innerComposite, SmartCardMessages.SCPasswordDialog_store_password_message, 32, 2);
        }
        this.getShell().setText(SmartCardMessages.SCPasswordDialog_smartcard_password_title);
        this.setHelpAvailable(false);
        this.setMessage(null);
        return innerComposite;
    }

    private void validate() {
        String pass = this.txtPassword.getText();
        if (this.butOK != null) {
            if (pass.isEmpty()) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(SmartCardMessages.SCPasswordDialog_empty_password_field_message);
            } else if (pass.length() > 255) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(SmartCardMessages.SCPasswordDialog_password_too_long_message);
            } else {
                this.butOK.setEnabled(true);
                this.setErrorMessage(null);
            }
        }
    }

    protected boolean isResizable() {
        return this.resisableOnInit;
    }

    protected Control createButtonBar(Composite parent) {
        Control butBar = super.createButtonBar(parent);
        this.butOK = this.getButton(0);
        Point currentSize = super.getInitialSize();
        super.getShell().pack();
        Point newSize = super.getShell().getSize();
        super.getShell().setSize(currentSize.x, newSize.y);
        this.resisableOnInit = false;
        this.validate();
        return butBar;
    }

    protected void okPressed() {
        this.password = this.txtPassword.getText();
        if (this.butStorePassword != null && !this.password.isEmpty()) {
            this.storePassword = this.butStorePassword.getSelection();
        }
        super.okPressed();
    }

    public String getInput() {
        return this.password;
    }

    public boolean getStorePassword() {
        return this.storePassword;
    }
}

