/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.controller;

import com.nxp.s32ds.tad.common.controller.TadFactoryData;
import com.nxp.s32ds.tad.common.model.IDataListener;
import com.nxp.s32ds.tad.common.model.ITadModelListener;
import com.nxp.s32ds.tad.common.model.TadModel;
import com.nxp.s32ds.tad.common.view.TadView;

public abstract class TadViewController
implements ITadModelListener,
IDataListener {
    protected TadView view;
    protected Object previousData;
    protected final TadModel tadModel;
    private boolean analyticsDataLogged;

    public TadViewController(TadModel tadModel, TadView view) {
        this.view = view;
        this.tadModel = tadModel;
        tadModel.addListener(this);
    }

    public void requestData() {
        this.tadModel.requestViewData(this, this.view.getTitle());
    }

    public boolean isDataReady() {
        return this.tadModel.getDataCache().isViewDataReady(this.view.getTitle());
    }

    public void dispose() {
        this.tadModel.removeListener(this);
    }

    @Override
    public void debuggerSuspended() {
        if (this.view != null && this.view.isVisible() && !this.view.isViewPaused()) {
            this.view.showProgressBar();
            this.view.enableAllActions(true);
            this.requestData();
        }
    }

    @Override
    public void debuggerTerminated() {
        this.analyticsDataLogged = false;
        if (this.view != null) {
            this.view.showTadView();
            this.view.clearData();
            this.view.enableAllActions(false);
            this.view.enableAllViewers(false);
        }
    }

    @Override
    public void debuggerResumed() {
        if (this.view != null && !this.view.isViewPaused()) {
            this.view.enableAllViewers(false);
        }
    }

    @Override
    public void debuggerSessionCreated() {
        if (this.view != null) {
            this.view.clearData();
            this.view.enableAllViewers(false);
        }
    }

    @Override
    public void dataCorrupted() {
        if (this.view != null) {
            this.view.showTadView();
            this.view.refreshData(null, false);
        }
    }

    @Override
    public void dataEmpty(TadFactoryData data) {
        this.view.showMessage(data.getStatus(), data.getMessage());
        this.view.enableAllViewers(false);
    }
}

