/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.logger;

import com.nxp.s32ds.tad.common.TadCommonActivator;
import com.nxp.s32ds.tad.common.logger.Log;
import com.nxp.s32ds.tad.common.logger.LogType;
import com.nxp.s32ds.tad.common.messages.Messages;
import com.nxp.s32ds.tad.common.model.Time;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public abstract class Logger {
    private List<Log> logs;
    private static final int STORED_LOG_COUNT = 3;
    private MessageConsoleStream tadConsoleStream;

    public Logger(MessageConsole messageConsole) {
        this.tadConsoleStream = messageConsole.newMessageStream();
    }

    private synchronized void log(Log log) {
        if (this.logs == null) {
            this.logs = new LinkedList<Log>();
        }
        this.logs.add(log);
        this.tadConsoleStream.println(log.toString());
    }

    public synchronized void info(String text) {
        this.log(new Log(LogType.INFO, text));
    }

    public synchronized void debug(String text, Object ... args) {
        this.log(new Log(LogType.DEBUG, String.format(text, args)));
    }

    public synchronized void error(String text) {
        this.log(new Log(LogType.ERROR, text));
    }

    public synchronized void exception(Exception e, String message) {
        this.log(new Log(e, message));
    }

    public synchronized void exception(Exception e) {
        this.log(new Log(LogType.EXCEPTION, e.getClass().getSimpleName()));
    }

    public void clear() {
        if (this.logs != null) {
            this.logs.clear();
        }
    }

    public Log[] getLogs() {
        if (!this.logs.isEmpty()) {
            return this.logs.toArray(new Log[this.logs.size()]);
        }
        return new Log[0];
    }

    protected abstract String getDefaultDirName();

    protected abstract String getDirName();

    protected String getDirName(IPreferenceStore prefStore) {
        String loggingLocation = prefStore.getString(String.valueOf(this.getPreferencesPrefix()) + "rtosLoggingLocation");
        if ("rtosLoggingWorkspace".equals(loggingLocation)) {
            return this.getDefaultDirName();
        }
        if ("rtosLoggingCustom".equals(loggingLocation)) {
            return prefStore.getString(String.valueOf(this.getPreferencesPrefix()) + "rtosLoggingLocationCustomPath");
        }
        return this.getDefaultDirName();
    }

    public void saveLogFile() {
        block20: {
            if (!this.mustSaveLogs()) {
                return;
            }
            String tadLogsDirStr = this.getDirName();
            File tadLogsDir = new File(tadLogsDirStr);
            if (!tadLogsDir.isAbsolute()) {
                File workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
                tadLogsDir = workspace != null && workspace.exists() ? new File(workspace, tadLogsDirStr) : null;
            }
            if (tadLogsDir != null) {
                try {
                    if (!tadLogsDir.exists() && !tadLogsDir.mkdir()) {
                        this.error(String.format(Messages.Error_LogDirNotCreated, tadLogsDir.getAbsolutePath()));
                        return;
                    }
                }
                catch (SecurityException e) {
                    this.exception(e, Messages.Exception_WhileSavingLog);
                }
                this.deleteOldLogFiles(tadLogsDir);
                try {
                    String logName = String.valueOf(Messages.Log_SaveName) + Time.SAVE_FORMAT.toString() + Messages.Log_FileExtension;
                    File logPath = new File(tadLogsDir, logName);
                    if (logPath == null) break block20;
                    try {
                        Throwable throwable = null;
                        Object var6_10 = null;
                        try (OutputStreamWriter txt = new OutputStreamWriter((OutputStream)new FileOutputStream(logPath), StandardCharsets.UTF_8);){
                            txt.write(String.format("\"%s\" %s %s", Messages.General_Tad, Messages.General_Version, TadCommonActivator.getDefault().getVersionAsString()));
                            txt.write(System.getProperty("line.separator"));
                            txt.write(Messages.General_Copyright);
                            txt.write(System.getProperty("line.separator"));
                            txt.write("==================================");
                            txt.write(System.getProperty("line.separator"));
                            for (Log msg : this.logs) {
                                txt.write(msg.toString());
                                txt.write(System.getProperty("line.separator"));
                            }
                            ((Writer)txt).close();
                            this.info(String.format(Messages.Log_Saved, logPath));
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        this.exception(e, null);
                    }
                }
                catch (NullPointerException e) {
                    this.exception(e, null);
                }
            }
        }
    }

    public void deleteOldLogFiles(File directory) {
        Object[] files = null;
        try {
            files = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name != null && dir != null && dir.isDirectory()) {
                        return name.contains(Messages.Log_FileExtension);
                    }
                    return false;
                }
            });
        }
        catch (SecurityException e) {
            this.exception(e, String.format(Messages.Exception_CouldNotAccess, directory));
        }
        if (files != null && files.length > 3) {
            try {
                Arrays.sort(files);
            }
            catch (ClassCastException e) {
                this.exception(e, Messages.Exception_ElementsNotComparable);
            }
            File[] fileArray = (File[])Arrays.copyOfRange(files, 0, files.length - 3);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    file.delete();
                }
                catch (SecurityException e) {
                    this.exception(e, Messages.Exception_CouldNotAccess);
                }
                ++n2;
            }
        }
    }

    protected abstract boolean mustSaveLogs();

    protected boolean mustSaveLogs(IPreferenceStore prefStore) {
        String loggingLocation = prefStore.getString(String.valueOf(this.getPreferencesPrefix()) + "rtosLoggingLocation");
        return !"rtosLoggingOmit".equals(loggingLocation);
    }

    protected abstract String getPreferencesPrefix();
}

