/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.model.view.tasks;

import java.util.List;
import java.util.ListIterator;

public class GenericTaskStack {
    protected long baseAddress;
    protected long endAddress;
    protected long highWaterMarkAddress;
    protected boolean stackOverflow;

    public GenericTaskStack(long baseAddress, long endAddress, long highWaterMarkAddress, boolean stackOverflow) {
        this.baseAddress = baseAddress;
        this.endAddress = endAddress;
        this.highWaterMarkAddress = highWaterMarkAddress;
        this.stackOverflow = stackOverflow;
    }

    public long getBaseAddress() {
        return this.baseAddress;
    }

    public long getEndAddress() {
        return this.endAddress;
    }

    public long getHighWaterMarkAddress() {
        return this.highWaterMarkAddress;
    }

    public long getSize() {
        return this.endAddress - this.baseAddress;
    }

    public long getUsage() {
        return this.endAddress - this.highWaterMarkAddress;
    }

    public boolean isOverflown() {
        return this.stackOverflow;
    }

    public static long getStackHighWaterMarkBytes(List<Integer> memory, int stackFillByte) {
        ListIterator<Integer> iter = memory.listIterator();
        long freeBytesCount = 0L;
        while (iter.hasNext() && iter.next() == stackFillByte) {
            ++freeBytesCount;
        }
        return freeBytesCount;
    }

    public static boolean isStackOverflown(List<Integer> memory, int stackFillByte) {
        int i = 0;
        while (i < 16) {
            if (memory.get(i) != stackFillByte) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

