/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.server.core.servlets.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.nxp.s32ds.rcp.collateral.CollateralPack;
import com.nxp.s32ds.rcp.collateral.CollateralResource;
import com.nxp.s32ds.rcp.collateral.CollateralTag;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CollateralPackageSerializer
implements JsonSerializer<CollateralPack> {
    public JsonElement serialize(CollateralPack collateralPack, Type type, JsonSerializationContext context) {
        HashMap map = new HashMap();
        Set collect = collateralPack.getFeatures().stream().map(feature -> feature.getResources()).flatMap(res -> res.stream()).collect(Collectors.toSet());
        for (CollateralResource collateralResource : collect) {
            for (CollateralTag collateralTag : collateralResource.getTags()) {
                if (map.containsKey(collateralTag)) {
                    ((Set)map.get(collateralTag)).add(collateralResource);
                    continue;
                }
                HashSet<CollateralResource> packs = new HashSet<CollateralResource>();
                packs.add(collateralResource);
                map.put(collateralTag, packs);
            }
        }
        JsonObject result = new JsonObject();
        result.add("name", (JsonElement)new JsonPrimitive(collateralPack.getName()));
        JsonArray array = new JsonArray();
        result.add("resources", (JsonElement)array);
        for (Map.Entry entry : map.entrySet()) {
            JsonObject tagJsonObject = new JsonObject();
            tagJsonObject.add("id", (JsonElement)new JsonPrimitive(((CollateralTag)entry.getKey()).getId()));
            tagJsonObject.add("name", (JsonElement)new JsonPrimitive(((CollateralTag)entry.getKey()).getName()));
            tagJsonObject.add("description", (JsonElement)new JsonPrimitive(((CollateralTag)entry.getKey()).getDescription()));
            JsonArray jsonDataArray = new JsonArray();
            for (CollateralResource resource : (Set)entry.getValue()) {
                JsonObject resourceJsonObject = new JsonObject();
                resourceJsonObject.add("id", (JsonElement)new JsonPrimitive(resource.getId()));
                resourceJsonObject.add("name", (JsonElement)new JsonPrimitive(resource.getName()));
                String urlLink = resource.getUrlLink();
                if (urlLink != null) {
                    resourceJsonObject.add("uriLink", (JsonElement)new JsonPrimitive(urlLink.trim()));
                }
                jsonDataArray.add((JsonElement)resourceJsonObject);
            }
            tagJsonObject.add("resources", (JsonElement)jsonDataArray);
            array.add((JsonElement)tagJsonObject);
        }
        return result;
    }
}

