/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.server.core.servlets.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.nxp.s32ds.rcp.collateral.CollateralResource;
import com.nxp.s32ds.rcp.collateral.CollateralTag;
import java.lang.reflect.Type;

public class CollateralResourcesSerializer
implements JsonSerializer<CollateralResource> {
    public JsonElement serialize(CollateralResource collateralResource, Type type, JsonSerializationContext context) {
        String urlLink;
        JsonObject result = new JsonObject();
        result.add("id", (JsonElement)new JsonPrimitive(collateralResource.getId()));
        String name = collateralResource.getName();
        if (name != null) {
            result.add("name", (JsonElement)new JsonPrimitive(name));
        }
        if ((urlLink = collateralResource.getUrlLink()) != null) {
            result.add("uriLink", (JsonElement)new JsonPrimitive(urlLink.trim()));
        }
        result.add("packId", (JsonElement)new JsonPrimitive(collateralResource.getFeature().getPack().getId()));
        JsonArray jsonDataArray = new JsonArray();
        for (CollateralTag collateralTag : collateralResource.getTags()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("id", (JsonElement)new JsonPrimitive(collateralTag.getId()));
            jsonObject.add("name", (JsonElement)new JsonPrimitive(collateralTag.getName()));
            jsonDataArray.add((JsonElement)jsonObject);
        }
        result.add("tagsId", (JsonElement)jsonDataArray);
        return result;
    }
}

