/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.core;

import com.nxp.s32ds.cle.uct.core.UctCore;
import com.nxp.s32ds.cle.uct.internal.core.ProjectPropertiesManager;
import com.nxp.s32ds.cle.uct.internal.core.SDKProjectHandler;
import com.nxp.s32ds.cle.uct.providers.ISDKManifest;
import com.nxp.s32ds.cle.uct.providers.SDKManifestProvider;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.nxp.s32ds.cle.uct.core";
    public static final String IMG_PACKAGE = "img.package";
    public static final String IMG_COMPONENT = "img.view.sdk.component";
    public static final String IMG_WIZ_BANNER_COMP = "img.sdk.manage.components";
    public static final String IMG_SELECTALL = "img.select.all";
    public static final String IMG_DESELECTALL = "img.select.none";
    public static final String IMG_CLEAN = "img.clean.filter";
    public static final String IMG_COLLAPSE_ALL = "img.collapse.all";
    public static final String IMG_EXPAND_ALL = "img.expand.all";
    public static final String IMG_CATEGORY = "img.examples.category";
    public static final String IMG_MASK = "img.examples.mask";
    public static final String IMG_EXAMPLE = "img.examples.item";
    public static final String IMG_DEC_ASSISTANT = "img.decorator.assistant";
    private IEventListener removeComponentsListener;
    private IEventListener addComponentsListener;
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        UctCore.init();
        this.addListeners();
    }

    public void stop(BundleContext context) throws Exception {
        for (SDKManifestProvider provider : SDKManifestProvider.getInstance()) {
            for (ISDKManifest manifest : provider.getManifests()) {
                manifest.dispose();
            }
        }
        plugin = null;
        this.removeListeners();
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private void registerImage(ImageRegistry registry, String key, String fileName) {
        try {
            Path path = new Path("icons/" + fileName);
            URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)path, null);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                registry.put(key, desc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, IMG_PACKAGE, "package_obj.gif");
        this.registerImage(registry, IMG_WIZ_BANNER_COMP, "packrefact_wiz.png");
        this.registerImage(registry, IMG_SELECTALL, "selectall.gif");
        this.registerImage(registry, IMG_DESELECTALL, "removeall.gif");
        this.registerImage(registry, IMG_CLEAN, "clear.gif");
        this.registerImage(registry, IMG_EXPAND_ALL, "expandall.gif");
        this.registerImage(registry, IMG_COLLAPSE_ALL, "collapseall.gif");
        this.registerImage(registry, IMG_CATEGORY, "category_obj.gif");
        this.registerImage(registry, IMG_MASK, "all_sc_obj.gif");
        this.registerImage(registry, IMG_EXAMPLE, "ctxhelp_desc_obj.gif");
        this.registerImage(registry, IMG_DEC_ASSISTANT, "contassist_ovr.gif");
        this.registerImage(registry, IMG_COMPONENT, "plugin_mf_obj.gif");
    }

    private void addListeners() {
        this.removeComponentsListener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                if (Activator.this.getSyncWithPeriphToolStatus()) {
                    Controller controllerInstance;
                    ArrayList<String> compToBeRemoved = new ArrayList<String>(Arrays.asList(event.originator.toString().split(";")));
                    boolean removed = Activator.this.getProjectHandler().remComponent(compToBeRemoved, true);
                    if (removed && (controllerInstance = Controller.getInstance()).isMcuSupported()) {
                        ArrayList<String> swComponents = new ArrayList<String>();
                        controllerInstance.getProfile().getAllInstances().forEach(x -> x.getComponent().getComponents().forEach(swComp -> swComponents.add(swComp.getName())));
                        if (!swComponents.isEmpty() && !swComponents.equals(compToBeRemoved)) {
                            Activator.this.getProjectHandler().addComponent(swComponents, true, true, false, true);
                        }
                    }
                }
            }
        };
        this.addComponentsListener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                if (Activator.this.getSyncWithPeriphToolStatus()) {
                    Map peripheralsComponents;
                    Controller controllerInstance;
                    ArrayList<String> compToBeAdded = new ArrayList<String>(Arrays.asList(event.originator.toString().split(";")));
                    boolean compAdded = Activator.this.getProjectHandler().addComponent(compToBeAdded, true, true, false, true);
                    if (compAdded && (controllerInstance = Controller.getInstance()).isMcuSupported() && !(peripheralsComponents = controllerInstance.getPeripheralsForComponents(compToBeAdded)).isEmpty()) {
                        HashMap selectedPeripherals = new HashMap();
                        peripheralsComponents.keySet().forEach(x -> {
                            List peripheralInstances = (List)peripheralsComponents.get(x);
                            if (peripheralInstances != null) {
                                selectedPeripherals.put(x, (String)peripheralInstances.get(0));
                            } else {
                                selectedPeripherals.put(x, null);
                            }
                        });
                        controllerInstance.createComponentInstance(selectedPeripherals);
                    }
                }
            }
        };
        Controller.getInstance().addListener(8, this.addComponentsListener);
        Controller.getInstance().addListener(16, this.removeComponentsListener);
    }

    private void removeListeners() {
        Controller.getInstance().removeListener(8, this.addComponentsListener);
        Controller.getInstance().removeListener(16, this.removeComponentsListener);
    }

    private SDKProjectHandler getProjectHandler() {
        IProject project = ConfigurationUtils.getEclipseProject((ISharedConfiguration)SharedConfigurationFactory.getSharedConfigurationSingleton());
        return new SDKProjectHandler(project);
    }

    private boolean getSyncWithPeriphToolStatus() {
        IProject project = ConfigurationUtils.getEclipseProject((ISharedConfiguration)SharedConfigurationFactory.getSharedConfigurationSingleton());
        return ProjectPropertiesManager.getSyncWithPeriphToolPreferencesStatus(project);
    }
}

