/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.exceptions;

import com.nxp.s32ds.cle.uct.core.Activator;
import com.nxp.s32ds.cle.uct.providers.ISDKManifest;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.preference.IPreferenceStore;

public class SDKException
extends Exception {
    private List<ISDKManifest> wrong = new ArrayList<ISDKManifest>();
    protected static final Logger LOGGER = LogManager.getLogger(SDKException.class);
    private static final long serialVersionUID = 814664129390350604L;
    public static boolean loadErrorLogged = false;
    private final List<Exception> exList = new ArrayList<Exception>();
    private static IPreferenceStore store = Activator.getDefault().getPreferenceStore();

    public SDKException() {
    }

    public SDKException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public SDKException(String message, Throwable cause) {
        super(message, cause);
    }

    public SDKException(String message) {
        super(message);
    }

    public SDKException(Throwable cause) {
        super(cause);
    }

    public List<Exception> getExList() {
        return this.exList;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Exception e : this.exList) {
            buffer.append(String.valueOf(e.getMessage()) + "\n");
        }
        return buffer.toString();
    }

    public void addWrongManifest(ISDKManifest manifest) {
        manifest.dispose();
        this.wrong.add(manifest);
    }

    public List<ISDKManifest> getWrongManifests() {
        ArrayList<ISDKManifest> list = new ArrayList<ISDKManifest>();
        list.addAll(this.wrong);
        for (Exception e : this.getExList()) {
            if (!(e instanceof SDKException)) continue;
            list.addAll(((SDKException)e).getWrongManifests());
        }
        return list;
    }

    private static void reportException(SDKException ex) {
        for (Exception e : ex.getExList()) {
            if (e.getMessage() != null) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            if (!(e instanceof SDKException)) continue;
            SDKException.reportException((SDKException)e);
        }
    }
}

